/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.commands.AccessoriesCommands;
import io.wispforest.accessories.commands.AccessoriesMixedSlotArgument;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.base.Argument;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandTreeBuilder;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class AccessoriesItemCommands
implements CommandTreeGenerator.Branched {
    public static final AccessoriesItemCommands INSTANCE = new AccessoriesItemCommands();
    private static final Dynamic3CommandExceptionType ERROR_TARGET_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((object, object2, object3) -> Component.translatableEscape((String)"commands.item.target.not_a_container", (Object[])new Object[]{object, object2, object3}));
    private static final Dynamic3CommandExceptionType ERROR_SOURCE_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((object, object2, object3) -> Component.translatableEscape((String)"commands.item.source.not_a_container", (Object[])new Object[]{object, object2, object3}));
    private static final DynamicCommandExceptionType ERROR_TARGET_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"commands.item.target.no_such_slot", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_SOURCE_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(object -> Component.translatableEscape((String)"commands.item.source.no_such_slot", (Object[])new Object[]{object}));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_MODIFIER = (commandContext, suggestionsBuilder) -> SharedSuggestionProvider.listSuggestions((CommandContext)commandContext, (SuggestionsBuilder)suggestionsBuilder, (ResourceKey)Registries.ITEM_MODIFIER, (SharedSuggestionProvider.ElementSuggestionType)SharedSuggestionProvider.ElementSuggestionType.ELEMENTS);
    public static final Dynamic2CommandExceptionType ERROR_INVALID_SLOT_INDEX = new Dynamic2CommandExceptionType((ob1, ob2) -> Component.literal((String)("The given path for [" + String.valueOf(ob1) + "] container is invalid: [Path: " + String.valueOf(ob2) + "]")));

    private AccessoriesItemCommands() {
    }

    @Override
    public <T> NamedArgumentGetter<CommandSourceStack, T> getArgumentGetter(ArgumentType<T> type) {
        NamedArgumentGetter<CommandSourceStack, ?> getter = AccessoriesCommands.getArgumentGetterErased(type);
        return getter != null ? getter : CommandTreeGenerator.Branched.super.getArgumentGetter(type);
    }

    @Override
    public void generateTrees(BranchedCommandGenerator generator, CommandBuildContext context, Commands.CommandSelection environment) {
        Argument slotArg = this.required("slot", SlotArgument.slot());
        Argument<BlockPos> blockArg = this.required("pos", (ArgumentType<?>)BlockPosArgument.blockPos(), BlockPosArgument::getLoadedBlockPos);
        Argument<Object> modifierArg = this.defaulted("modifier", (ArgumentType<?>)ResourceOrIdArgument.lootModifier((CommandBuildContext)context), ResourceOrIdArgument::getLootModifier, null, SUGGEST_MODIFIER);
        Argument sourceSlotArg = this.required("sourceSlot", SlotArgument.slot());
        ((CommandTreeBuilder.BranchedCommandTreeBuilder)((CommandTreeBuilder.BranchedCommandTreeBuilder)generator.branch("item")).branch("replace", replaceBranch -> ((CommandTreeBuilder.BranchedCommandTreeBuilder)replaceBranch.branch("block", blockArg, slotArg, blockBranch -> blockBranch.branch("from", fromBranch -> fromBranch.leaves("entity", this.required("source_entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.required("source_path", AccessoriesMixedSlotArgument.slot("source_entity")), modifierArg, (ctx, targetPos, targetSlot, sourceEntity, sourceSlot, modifier) -> modifier == null ? AccessoriesItemCommands.entityToBlock((CommandSourceStack)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourceSlot, targetPos, targetSlot) : AccessoriesItemCommands.entityToBlock((CommandSourceStack)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourceSlot, targetPos, targetSlot, (Holder<LootItemFunction>)modifier))))).branch("entity", this.required("entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.required("path", AccessoriesMixedSlotArgument.slot("entity")), entityBranch -> entityBranch.leaves("with", this.required("item", (ArgumentType<?>)ItemArgument.item((CommandBuildContext)context), (ctx, name) -> ItemArgument.getItem((CommandContext)ctx, (String)name).createItemStack(1, false)), this.defaulted("count", IntegerArgumentType.integer((int)1, (int)99), 1), (ctx, entity, slot, stack, count) -> {
            stack.setCount(count.intValue());
            return AccessoriesItemCommands.setEntityItem((CommandSourceStack)ctx.getSource(), entity, (Either<SlotPath, Integer>)slot, stack);
        }).branch("from", fromBranch -> fromBranch.leaves("block", this.required("source", (ArgumentType<?>)BlockPosArgument.blockPos(), BlockPosArgument::getLoadedBlockPos), sourceSlotArg, modifierArg, (ctx, targetPos, targetSlot, sourcePos, sourceSlot, modifier) -> modifier == null ? AccessoriesItemCommands.blockToEntity((CommandSourceStack)ctx.getSource(), sourcePos, sourceSlot, targetPos, (Either<SlotPath, Integer>)targetSlot) : AccessoriesItemCommands.blockToEntity((CommandSourceStack)ctx.getSource(), sourcePos, sourceSlot, targetPos, (Either<SlotPath, Integer>)targetSlot, (Holder<LootItemFunction>)modifier)).leaves("entity", this.required("source_entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.required("source_path", AccessoriesMixedSlotArgument.slot("source_entity")), modifierArg, (ctx, targetEntity, targetPath, sourceEntity, sourcePath, modifier) -> modifier == null ? AccessoriesItemCommands.entityToEntity((CommandSourceStack)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourcePath, targetEntity, (Either<SlotPath, Integer>)targetPath) : AccessoriesItemCommands.entityToEntity((CommandSourceStack)ctx.getSource(), sourceEntity, (Either<SlotPath, Integer>)sourcePath, targetEntity, (Either<SlotPath, Integer>)targetPath, (Holder<LootItemFunction>)modifier)))))).branch("modify", modifyBranch -> modifyBranch.leaves("entity", this.required("entity", (ArgumentType<?>)EntityArgument.entity(), EntityArgument::getEntity), this.required("path", AccessoriesMixedSlotArgument.slot("entity")), modifierArg, (ctx, entity, path, modifier) -> AccessoriesItemCommands.modifyEntityItem((CommandSourceStack)ctx.getSource(), entity, (Either<SlotPath, Integer>)path, (Holder<LootItemFunction>)modifier)));
    }

    private static int blockToEntity(CommandSourceStack source, BlockPos pos, int sourceSlot, Entity target, Either<SlotPath, Integer> slot) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, target, slot, AccessoriesItemCommands.getBlockItem(source, pos, sourceSlot));
    }

    private static int blockToEntity(CommandSourceStack source, BlockPos pos, int sourceSlot, Entity target, Either<SlotPath, Integer> slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, target, slot, AccessoriesItemCommands.applyModifier(source, modifier, AccessoriesItemCommands.getBlockItem(source, pos, sourceSlot)));
    }

    private static int entityToBlock(CommandSourceStack source, Entity sourceEntity, Either<SlotPath, Integer> sourceSlot, BlockPos pos, int slot) throws CommandSyntaxException {
        return AccessoriesItemCommands.setBlockItem(source, pos, slot, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot));
    }

    private static int entityToBlock(CommandSourceStack source, Entity sourceEntity, Either<SlotPath, Integer> sourceSlot, BlockPos pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return AccessoriesItemCommands.setBlockItem(source, pos, slot, AccessoriesItemCommands.applyModifier(source, modifier, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot)));
    }

    private static int entityToEntity(CommandSourceStack source, Entity sourceEntity, Either<SlotPath, Integer> sourceSlot, Entity targetEntity, Either<SlotPath, Integer> targetSlot) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, targetEntity, targetSlot, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot));
    }

    private static int entityToEntity(CommandSourceStack source, Entity sourceEntity, Either<SlotPath, Integer> sourceSlot, Entity targetEntity, Either<SlotPath, Integer> targetSlot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return AccessoriesItemCommands.setEntityItem(source, targetEntity, targetSlot, AccessoriesItemCommands.applyModifier(source, modifier, AccessoriesItemCommands.getEntityItem(sourceEntity, sourceSlot)));
    }

    private static ItemStack applyModifier(CommandSourceStack source, Holder<LootItemFunction> modifier, ItemStack originalStack) {
        LootParams lootParams = new LootParams.Builder(source.getLevel()).withParameter(LootContextParams.ORIGIN, (Object)source.getPosition()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)source.getEntity()).create(LootContextParamSets.COMMAND);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        lootContext.pushVisitedElement(LootContext.createVisitedEntry((LootItemFunction)((LootItemFunction)modifier.value())));
        ItemStack modifiedStack = (ItemStack)((LootItemFunction)modifier.value()).apply((Object)originalStack, (Object)lootContext);
        modifiedStack.limitSize(modifiedStack.getMaxStackSize());
        return modifiedStack;
    }

    private static ItemStack getEntityItem(Entity entity, Either<SlotPath, Integer> slot) throws CommandSyntaxException {
        if (slot.right().isPresent()) {
            Integer index = (Integer)slot.right().get();
            SlotAccess slotAccess = entity.getSlot(index.intValue());
            if (slotAccess == SlotAccess.NULL) {
                throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);
            }
            return slotAccess.get().copy();
        }
        if (!(entity instanceof LivingEntity)) {
            throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.accessoriesCapability() == null) {
            throw AccessoriesCommands.ERROR_CAPABILITY_MISSING.create();
        }
        SlotPath slotPath = (SlotPath)slot.left().get();
        SlotReference reference = SlotReference.of(livingEntity, slotPath);
        AccessoriesContainer container = reference.slotContainer();
        if (container == null) {
            throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create((Object)reference.slotName());
        }
        ItemStack stack = reference.getStack();
        if (stack == null) {
            throw ERROR_INVALID_SLOT_INDEX.create((Object)slotPath.slotName(), (Object)slotPath);
        }
        return stack.copy();
    }

    private static int setEntityItem(CommandSourceStack source, Entity entity, Either<SlotPath, Integer> slot, ItemStack stack) throws CommandSyntaxException {
        if (slot.right().isPresent()) {
            Integer index = (Integer)slot.right().get();
            SlotAccess slotAccess = entity.getSlot(index.intValue());
            if (slotAccess == SlotAccess.NULL) {
                throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);
            }
            slotAccess.set(stack);
        } else {
            if (!(entity instanceof LivingEntity)) {
                throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            SlotPath slotPath = (SlotPath)slot.left().get();
            SlotReference reference = SlotReference.of(livingEntity, slotPath);
            AccessoriesContainer container = reference.slotContainer();
            if (container == null) {
                throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create((Object)reference.slotName());
            }
            if (reference.setStack(stack)) {
                throw ERROR_INVALID_SLOT_INDEX.create((Object)slotPath.slotName(), (Object)slotPath);
            }
        }
        return 1;
    }

    private static ItemStack getBlockItem(CommandSourceStack source, BlockPos pos, int slot) throws CommandSyntaxException {
        Container container = AccessoriesItemCommands.getContainer(source, pos, ERROR_SOURCE_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.getContainerSize()) {
            return container.getItem(slot).copy();
        }
        throw ERROR_SOURCE_INAPPLICABLE_SLOT.create((Object)slot);
    }

    private static int setBlockItem(CommandSourceStack source, BlockPos pos, int slot, ItemStack item) throws CommandSyntaxException {
        Container container = AccessoriesItemCommands.getContainer(source, pos, ERROR_TARGET_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.getContainerSize()) {
            container.setItem(slot, item);
            source.sendSuccess(() -> Component.translatable((String)"commands.item.block.set.success", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), item.getDisplayName()}), true);
            return 1;
        }
        throw ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)slot);
    }

    private static Container getContainer(CommandSourceStack source, BlockPos pos, Dynamic3CommandExceptionType exception) throws CommandSyntaxException {
        BlockEntity blockEntity = source.getLevel().getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            return container;
        }
        throw exception.create((Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
    }

    private static int modifyEntityItem(CommandSourceStack source, Entity target, Either<SlotPath, Integer> slot, Holder<LootItemFunction> modifer) throws CommandSyntaxException {
        ItemStack modifiedStack = AccessoriesItemCommands.applyModifier(source, modifer, AccessoriesItemCommands.getEntityItem(target, slot).copy());
        AccessoriesItemCommands.setEntityItem(source, target, slot, modifiedStack);
        source.sendSuccess(() -> Component.translatable((String)"commands.item.entity.set.success.single", (Object[])new Object[]{target.getDisplayName(), modifiedStack.getDisplayName()}), true);
        return 1;
    }
}

