/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands.api;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.wispforest.accessories.commands.api.base.Argument;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface ArgumentsWithContext<S> {
    default public <T> NamedArgumentGetter<S, T> getArgumentGetter(ArgumentType<T> type) {
        if (type instanceof NamedArgumentGetter) {
            NamedArgumentGetter getter = (NamedArgumentGetter)type;
            return getter;
        }
        throw new IllegalArgumentException("Unable to get needed getter for given argument type as it has no getter bound to it! [Type: " + String.valueOf(type) + "]");
    }

    default public <T> Argument<T> required(String name, ArgumentType<T> type) {
        return this.required(name, type, this.getArgumentGetter(type));
    }

    default public <T> Argument<T> defaulted(String name, ArgumentType<T> type, T defaultValue) {
        return this.defaulted(name, type, this.getArgumentGetter(type), defaultValue);
    }

    default public <T> Argument<T> required(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter) {
        return Argument.required(name, type, getter, null);
    }

    default public <T> Argument<T> defaulted(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter, T defaultValue) {
        return Argument.defaulted(name, type, getter, defaultValue, null);
    }

    default public <T> Argument<T> required(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter, @Nullable SuggestionProvider<?> suggestions) {
        return Argument.required(name, type, getter, suggestions);
    }

    default public <T> Argument<T> defaulted(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter, T defaultValue, @Nullable SuggestionProvider<?> suggestions) {
        return Argument.defaulted(name, type, getter, defaultValue, suggestions);
    }

    default public Argument<String> branches(String ... branches) {
        return Argument.branches(List.of(branches));
    }

    default public Argument<String> branches(List<String> branches) {
        return Argument.branches(branches);
    }

    default public <T> Argument<T> branches(List<String> branches, Function<String, T> conversionFunc) {
        return Argument.branches(branches, conversionFunc);
    }
}

