/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.commands.api.base;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.wispforest.accessories.commands.api.core.ContextAwareLiteralArgumentBuilder;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public abstract sealed class Argument<T> {
    public static <S, T> Argument<T> required(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter) {
        return Argument.required(name, type, getter, null);
    }

    public static <S, T> Argument<T> defaulted(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter, T defaultValue) {
        return Argument.defaulted(name, type, getter, defaultValue, null);
    }

    public static <S, T> Argument<T> required(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter, @Nullable SuggestionProvider<?> suggestions) {
        return ArgumentWithType.of(name, type, getter, suggestions);
    }

    public static <S, T> Argument<T> defaulted(String name, ArgumentType<?> type, NamedArgumentGetter<S, T> getter, T defaultValue, @Nullable SuggestionProvider<?> suggestions) {
        return ArgumentWithType.ofDefaulted(name, type, getter, defaultValue, suggestions);
    }

    public static Argument<String> branches(String ... branches) {
        return Argument.branches(List.of(branches));
    }

    public static Argument<String> branches(List<String> branches) {
        return Argument.branches(branches, Function.identity());
    }

    public static <T> Argument<T> branches(List<String> branches, Function<String, T> conversionFunc) {
        return new LiteralBranches<T>(branches, conversionFunc);
    }

    public static Argument<String> asKeyPath(String branch) {
        return LiteralBranch.asKeyPath(branch, Function.identity());
    }

    public abstract <S> T getArgument(CommandContext<S> var1) throws CommandSyntaxException;

    static final class ArgumentWithType<T>
    extends ArgumentBuilderConstructor<T> {
        private final String name;
        private final ArgumentType<?> type;
        private final NamedArgumentGetter<?, T> getter;
        private final boolean defaulted;
        @Nullable
        private final T defaultValue;
        @Nullable
        private final SuggestionProvider<?> suggestions;

        ArgumentWithType(String name, ArgumentType<?> type, NamedArgumentGetter<?, T> getter, boolean defaulted, @Nullable T defaultValue, @Nullable SuggestionProvider<?> suggestions) {
            this.name = name;
            this.type = type;
            this.getter = getter;
            this.defaulted = defaulted;
            this.defaultValue = defaultValue;
            this.suggestions = suggestions;
        }

        public static <T> ArgumentWithType<T> of(String name, ArgumentType<?> type, NamedArgumentGetter<?, T> getter, @Nullable SuggestionProvider<?> suggestions) {
            return new ArgumentWithType<Object>(name, type, getter, false, null, suggestions);
        }

        public static <T> ArgumentWithType<T> ofDefaulted(String name, ArgumentType<?> type, NamedArgumentGetter<?, T> getter, T defaultValue, @Nullable SuggestionProvider<?> suggestions) {
            return new ArgumentWithType<T>(name, type, getter, true, defaultValue, suggestions);
        }

        @Override
        public <S> ArgumentBuilder<S, ?> createNodeBuilder() {
            return RequiredArgumentBuilder.argument((String)this.name, this.type);
        }

        @Nullable
        public <S> SuggestionProvider<S> suggestions() {
            return this.suggestions;
        }

        @Override
        public <S> T getArgument(CommandContext<S> ctx) throws CommandSyntaxException {
            try {
                return this.getter.getArgument(ctx, this.name);
            }
            catch (IllegalArgumentException e) {
                if (this.defaulted) {
                    return this.defaultValue;
                }
                throw e;
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean defaulted() {
            return this.defaulted;
        }
    }

    static final class LiteralBranches<T>
    extends ArgumentBuilderConstructor<T>
    implements ArgumentBuilderConstructorList {
        private final List<String> branches;
        private final Function<String, T> conversionFunc;

        LiteralBranches(List<String> branches, Function<String, T> conversionFunc) {
            this.branches = branches;
            this.conversionFunc = conversionFunc;
        }

        public List<? extends ArgumentBuilderConstructor<T>> builders() {
            return this.branches.stream().map(str -> LiteralBranch.asArgument(str, this.conversionFunc)).toList();
        }

        @Override
        public <S> T getArgument(CommandContext<S> ctx) throws CommandSyntaxException {
            return this.conversionFunc.apply(ContextAwareLiteralArgumentBuilder.getBranch(ctx));
        }

        @Override
        public <S> ArgumentBuilder<S, ?> createNodeBuilder() {
            throw new IllegalArgumentException("Unable to create node builder for LiteralBranches");
        }

        @Override
        public String name() {
            throw new IllegalArgumentException("Unable to get name for LiteralBranches");
        }
    }

    static final class LiteralBranch<T>
    extends ArgumentBuilderConstructor<T> {
        private final String branch;
        private final Function<String, ArgumentBuilder<?, ?>> argumentBuilderFunction;
        private final Function<String, T> conversionFunc;

        LiteralBranch(String branch, Function<String, ArgumentBuilder<?, ?>> argumentBuilderFunction, Function<String, T> conversionFunc) {
            this.branch = branch;
            this.argumentBuilderFunction = argumentBuilderFunction;
            this.conversionFunc = conversionFunc;
        }

        public static <T> LiteralBranch<T> asArgument(String branch, Function<String, T> conversionFunc) {
            return new LiteralBranch<T>(branch, ContextAwareLiteralArgumentBuilder::literal, conversionFunc);
        }

        public static <T> LiteralBranch<T> asKeyPath(String branch, Function<String, T> conversionFunc) {
            return new LiteralBranch<T>(branch, LiteralArgumentBuilder::literal, conversionFunc);
        }

        @Override
        public <S> ArgumentBuilder<S, ?> createNodeBuilder() {
            return this.argumentBuilderFunction.apply(this.branch);
        }

        @Override
        public String name() {
            return this.branch;
        }

        @Override
        public <S> T getArgument(CommandContext<S> ctx) throws CommandSyntaxException {
            return this.conversionFunc.apply(ContextAwareLiteralArgumentBuilder.getBranch(ctx));
        }
    }

    static interface ArgumentBuilderConstructorList {
        public List<? extends ArgumentBuilderConstructor> builders();
    }

    static abstract sealed class ArgumentBuilderConstructor<T>
    extends Argument<T>
    permits ArgumentWithType, LiteralBranch, LiteralBranches {
        ArgumentBuilderConstructor() {
        }

        public abstract <S> ArgumentBuilder<S, ?> createNodeBuilder();

        public abstract String name();

        public boolean defaulted() {
            return false;
        }
    }
}

