/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.data.SlotGroupLoader;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AccessoryChangedCriterion
extends SimpleCriterionTrigger<Conditions> {
    public void trigger(ServerPlayer player, ItemStack accessory, SlotPath path, Boolean cosmetic) {
        this.trigger(player, conditions -> conditions.itemPredicates().map(predicates -> predicates.stream().allMatch(predicate -> predicate.test(accessory))).orElse(true) != false && conditions.groups().flatMap(groups -> SlotGroupLoader.INSTANCE.findGroup(false, path.slotName()).map(group -> groups.stream().noneMatch(s -> s.equals(group.name())))).orElse(true) != false && conditions.slots().map(slots -> slots.stream().noneMatch(path.slotName()::equals)).orElse(true) != false && conditions.indices().map(indices -> indices.stream().noneMatch(index -> index.intValue() == path.index())).orElse(true) != false && conditions.cosmetic().map(isCosmetic -> isCosmetic != false && cosmetic != false).orElse(true) != false);
    }

    @NotNull
    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<List<ItemPredicate>> itemPredicates, Optional<List<String>> groups, Optional<List<String>> slots, Optional<List<Integer>> indices, Optional<Boolean> cosmetic) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.listOf().optionalFieldOf("items").forGetter(Conditions::itemPredicates), (App)Codec.STRING.listOf().optionalFieldOf("groups").forGetter(Conditions::groups), (App)Codec.STRING.listOf().optionalFieldOf("slots").forGetter(Conditions::slots), (App)Codec.INT.listOf().optionalFieldOf("indices").forGetter(Conditions::indices), (App)Codec.BOOL.optionalFieldOf("cosmetic").forGetter(Conditions::cosmetic)).apply((Applicative)instance, Conditions::new));
    }
}

