/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data.api;

import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingSet;
import io.wispforest.accessories.data.api.SequencedBiMap;
import io.wispforest.accessories.data.api.SequencedBiMapImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.SequencedSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class CustomForwardingSet<T, K, V>
extends ForwardingSet<T>
implements SequencedSet<T> {
    private final SequencedBiMap<K, V> biMap;
    private final Function<SequencedBiMapImpl<K, V>, SequencedSet<T>> delegateGetter;
    private final Function<T, Boolean> removeFunc;
    private final SequencedSet<T> delegate;

    CustomForwardingSet(SequencedBiMapImpl<K, V> biMap, Function<SequencedBiMapImpl<K, V>, SequencedSet<T>> delegateGetter, Function<T, Boolean> removeFunc) {
        this.biMap = biMap;
        this.delegateGetter = delegateGetter;
        this.removeFunc = removeFunc;
        this.delegate = delegateGetter.apply(biMap);
    }

    protected SequencedSet<T> delegate() {
        return this.delegate;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator itr = super.iterator();
        return new ForwardingIterator<T>(){
            private T value;

            protected Iterator<T> delegate() {
                return itr;
            }

            public T next() {
                this.value = super.next();
                return this.value;
            }

            public void remove() {
                CustomForwardingSet.this.remove(this.value);
                this.value = null;
            }
        };
    }

    @Override
    public void clear() {
        this.biMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.biMap.isEmpty();
    }

    @Override
    public int size() {
        return this.biMap.size();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFunc.apply(object);
    }

    @Override
    public SequencedSet<T> reversed() {
        return new CustomForwardingSet<T, K, V>((SequencedBiMapImpl)this.biMap.reversed(), this.delegateGetter, this.removeFunc);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.removeIf((Predicate<? super T>)((Predicate<Object>)collection::contains));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.removeIf((Predicate<? super T>)Predicate.not(collection::contains));
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super T> filter) {
        boolean modified = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (!filter.test(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean add(T element) {
        throw new IllegalStateException("'add' is not support for this set!");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new IllegalStateException("'addAll' is not support for this set!");
    }

    @Override
    public void addFirst(T t) {
        throw new IllegalStateException("'addFirst' is not support for this set!");
    }

    @Override
    public void addLast(T t) {
        throw new IllegalStateException("'addLast' is not support for this set!");
    }
}

