/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.AdjustAttributeModifierCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AccessoryAttributeLogic {
    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, SlotReference slotReference) {
        return AccessoryAttributeLogic.getAttributeModifiers(stack, slotReference, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, SlotReference slotReference, boolean useTooltipCheck) {
        return AccessoryAttributeLogic.getAttributeModifiers(stack, slotReference.entity(), slotReference.slotName(), slotReference.index(), useTooltipCheck);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, String slotName, int slot) {
        return AccessoryAttributeLogic.getAttributeModifiers(stack, null, slotName, slot);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, @Nullable LivingEntity entity, String slotName, int slot) {
        return AccessoryAttributeLogic.getAttributeModifiers(stack, entity, slotName, slot, false);
    }

    public static AccessoryAttributeBuilder getAttributeModifiers(ItemStack stack, @Nullable LivingEntity entity, String slotName, int slot, boolean hideTooltipIfDisabled) {
        SlotReference slotReference = SlotReference.of(entity, slotName, slot);
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        AccessoryNestUtils.recursivelyConsume(stack, slotReference, (innerStack, innerRef) -> {
            AccessoryItemAttributeModifiers component = (AccessoryItemAttributeModifiers)innerStack.getOrDefault(AccessoriesDataComponents.ATTRIBUTES, (Object)AccessoryItemAttributeModifiers.EMPTY);
            if (!hideTooltipIfDisabled || component.showInTooltip()) {
                component.gatherAttributes((SlotReference)innerRef, builder);
            }
        });
        if (entity != null) {
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
            if (accessory != null) {
                accessory.getDynamicModifiers(stack, slotReference, builder);
            }
            ((AdjustAttributeModifierCallback)AdjustAttributeModifierCallback.EVENT.invoker()).adjustAttributes(stack, slotReference, builder);
        }
        return builder;
    }
}

