/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.accessories.utils.BaseContainer;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.endec.util.MapCarrier;
import io.wispforest.endec.util.MapCarrierDecodable;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.format.nbt.NbtEndec;
import it.unimi.dsi.fastutil.ints.Int2BooleanLinkedOpenHashMap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApiStatus.Internal
public class AccessoriesContainerImpl
implements AccessoriesContainer,
InstanceEndec,
ContainerListener {
    protected AccessoriesCapability capability;
    private String slotName;
    protected final Map<ResourceLocation, AttributeModifier> modifiers = new HashMap<ResourceLocation, AttributeModifier>();
    protected final Set<AttributeModifier> persistentModifiers = new HashSet<AttributeModifier>();
    protected final Set<AttributeModifier> cachedModifiers = new HashSet<AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    @Nullable
    private Integer baseSize;
    private Map<Integer, Boolean> renderOptions;
    private ExpandedContainer accessories;
    private ExpandedContainer cosmeticAccessories;
    private boolean update = false;
    private boolean resizingUpdate = false;
    private boolean trackedForUpdate = false;
    protected boolean containerListenerLock = false;
    public static final KeyedEndec<String> SLOT_NAME_KEY = Endec.STRING.keyed("slot_name", (Object)"UNKNOWN");
    public static final KeyedEndec<Integer> BASE_SIZE_KEY = Endec.INT.keyed("base_size", () -> null);
    public static final KeyedEndec<Integer> CURRENT_SIZE_KEY = Endec.INT.keyed("current_size", (Object)0);
    public static final KeyedEndec<Map<Integer, Boolean>> RENDER_OPTIONS_KEY = CodecUtils.eitherEndec((Endec)Endec.BOOLEAN.listOf(), (Endec)Endec.map((Endec)Endec.INT, (Endec)Endec.BOOLEAN)).xmap(either -> (Map)Either.unwrap((Either)either.mapLeft(booleans -> {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        for (int i = 0; i < booleans.size(); ++i) {
            Boolean bl = (Boolean)booleans.get(i);
            if (bl.booleanValue()) continue;
            map.put(i, false);
        }
        return map;
    })), Either::right).keyed("render_options", HashMap::new);
    public static final KeyedEndec<List<CompoundTag>> MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("modifiers", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> PERSISTENT_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("persistent_modifiers", ArrayList::new);
    public static final KeyedEndec<List<CompoundTag>> CACHED_MODIFIERS_KEY = NbtEndec.COMPOUND.listOf().keyed("cached_modifiers", ArrayList::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final StructEndec<ItemStackWithSlot> SLOTTED_ITEMSTACK_ENDEC = CodecUtils.toStructEndec((MapCodec)((MapCodec.MapCodecCodec)ItemStackWithSlot.CODEC).codec()).structuredCatchErrors((ctx, serializer, struct, exception) -> {
        AccessoriesContainer container = ((ContainerAttribute)ctx.getAttributeValue(ContainerAttribute.CONTAINER)).container();
        LOGGER.error("[ExpandedSimpleContainer] An error has occured while decoding stack!");
        LOGGER.error(" - Entity Effected: '{}'", (Object)container.capability().entity().toString());
        LOGGER.error(" - Container Name: '{}'", (Object)container.getSlotName());
        LOGGER.error(" - Tried to load invalid ItemStack: ", (Throwable)exception);
        return new ItemStackWithSlot(-1, ItemStack.EMPTY);
    });
    public static final KeyedEndec<List<ItemStackWithSlot>> ITEMS_KEY = SLOTTED_ITEMSTACK_ENDEC.listOf().keyed("items", ArrayList::new);
    public static final KeyedEndec<List<ItemStackWithSlot>> COSMETICS_KEY = SLOTTED_ITEMSTACK_ENDEC.listOf().keyed("cosmetics", ArrayList::new);

    public AccessoriesContainerImpl(AccessoriesCapability capability, SlotType slotType) {
        this.capability = capability;
        this.slotName = slotType.name();
        this.baseSize = slotType.amount();
        this.accessories = new ExpandedContainer(this, this.baseSize, "accessories", false);
        this.cosmeticAccessories = new ExpandedContainer(this, this.baseSize, "cosmetic_accessories", false);
        this.renderOptions = new Int2BooleanLinkedOpenHashMap(this.baseSize.intValue());
    }

    @Override
    public boolean isClientSide() {
        return this.capability().entity().level().isClientSide();
    }

    public void containerChanged(Container container) {
        if (this.containerListenerLock) {
            return;
        }
        AccessoriesHolderLookupCache cache = AccessoriesHolderImpl.getHolder(this.capability()).getLookupCache();
        if (cache != null) {
            cache.clearContainerCache(this.slotName);
        }
        if (((ExpandedContainer)container).name().contains("cosmetic")) {
            return;
        }
        this.markChanged();
        this.update();
    }

    @Nullable
    public Integer getBaseSize() {
        return this.baseSize;
    }

    @Override
    public void markChanged(boolean resizingUpdate) {
        this.update = true;
        this.resizingUpdate = resizingUpdate;
        if (this.capability.entity().level().isClientSide()) {
            return;
        }
        Map<AccessoriesContainer, Boolean> inv = AccessoriesHolderImpl.getHolder(this.capability).containersRequiringUpdates();
        Boolean entry = inv.remove(this);
        this.trackedForUpdate = entry != null;
        inv.put(this, this.trackedForUpdate && entry != false || resizingUpdate);
    }

    @Override
    public boolean hasChanged() {
        return this.update;
    }

    @Override
    public void update() {
        int currentSize;
        double size;
        boolean hasChangeOccurred;
        AccessoriesHolderImpl holder = AccessoriesHolderImpl.getHolder(this.capability());
        boolean bl = hasChangeOccurred = !this.resizingUpdate;
        if (!this.update) {
            return;
        }
        this.update = false;
        if (this.capability.entity().level().isClientSide()) {
            return;
        }
        SlotType slotType = this.slotType();
        if (this.baseSize == null) {
            this.baseSize = 0;
        }
        if (slotType != null && this.baseSize.intValue() != slotType.amount()) {
            this.baseSize = slotType.amount();
            hasChangeOccurred = true;
        }
        double baseSize = this.baseSize.intValue();
        if (ExtraSlotTypeProperties.getProperty(this.slotName, false).allowResizing()) {
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADD_VALUE)) {
                baseSize += modifier.amount();
            }
            size = baseSize;
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                size += (double)this.baseSize.intValue() * modifier.amount();
            }
            for (AttributeModifier modifier : this.getModifiersForOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                size *= modifier.amount();
            }
        } else {
            size = baseSize;
        }
        if ((currentSize = (int)Math.round(size)) != this.accessories.getContainerSize()) {
            hasChangeOccurred = true;
            ArrayList<Pair> invalidAccessories = new ArrayList<Pair>();
            ArrayList<ItemStack> invalidStacks = new ArrayList<ItemStack>();
            this.containerListenerLock = true;
            ExpandedContainer newAccessories = new ExpandedContainer(this, currentSize, "accessories");
            ExpandedContainer newCosmetics = new ExpandedContainer(this, currentSize, "cosmetic_accessories");
            newAccessories.toggleFlagablity();
            newCosmetics.toggleFlagablity();
            for (int i = 0; i < this.accessories.getContainerSize(); ++i) {
                if (i < newAccessories.getContainerSize()) {
                    newAccessories.setItem(i, this.accessories.getItem(i));
                    newCosmetics.setItem(i, this.cosmeticAccessories.getItem(i));
                    continue;
                }
                invalidAccessories.add(Pair.of((Object)i, (Object)this.accessories.getItem(i)));
                invalidStacks.add(this.cosmeticAccessories.getItem(i));
            }
            newAccessories.toggleFlagablity();
            newCosmetics.toggleFlagablity();
            this.containerListenerLock = false;
            newAccessories.copyPrev(this.accessories);
            newCosmetics.copyPrev(this.cosmeticAccessories);
            this.accessories = newAccessories;
            this.cosmeticAccessories = newCosmetics;
            this.renderOptions = this.getWithSize(currentSize, this.renderOptions);
            LivingEntity livingEntity = this.capability.entity();
            for (Pair invalidAccessory : invalidAccessories) {
                Integer index = (Integer)invalidAccessory.getFirst();
                ItemStack invalidStack = (ItemStack)invalidAccessory.getSecond();
                if (invalidStack.isEmpty()) continue;
                SlotReference slotReference = SlotReference.of(livingEntity, this.slotName, (int)index);
                AttributeUtils.removeTransientAttributeModifiers(livingEntity, AccessoryAttributeLogic.getAttributeModifiers(invalidStack, slotReference));
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(invalidStack);
                if (accessory != null) {
                    accessory.onUnequip(invalidStack, slotReference);
                }
                invalidStacks.add(invalidStack);
            }
            holder.invalidStacks.addAll(invalidStacks);
            if (this.update) {
                this.capability.updateContainers();
            }
        }
        if (!hasChangeOccurred) {
            if (!this.trackedForUpdate) {
                Map<AccessoriesContainer, Boolean> inv = holder.containersRequiringUpdates();
                inv.remove(this);
            } else {
                this.trackedForUpdate = false;
            }
        } else {
            AccessoriesHolderLookupCache cache = holder.getLookupCache();
            if (cache != null) {
                cache.clearContainerCache(this.slotName);
            }
        }
    }

    @Override
    public int getSize() {
        this.update();
        return this.accessories.getContainerSize();
    }

    @Override
    public String getSlotName() {
        return this.slotName;
    }

    @Override
    public AccessoriesCapability capability() {
        return this.capability;
    }

    @Override
    public Map<Integer, Boolean> renderOptions() {
        this.update();
        return Collections.unmodifiableMap(this.renderOptions);
    }

    @Override
    public void setShouldRender(int index, boolean value) {
        int size = this.getSize();
        if (index >= 0 && index < size) {
            this.renderOptions.put(index, value);
        }
    }

    @Override
    public ExpandedContainer getAccessories() {
        this.update();
        return this.accessories;
    }

    @Override
    public ExpandedContainer getCosmeticAccessories() {
        this.update();
        return this.cosmeticAccessories;
    }

    @Override
    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return Collections.unmodifiableMap(this.modifiers);
    }

    @Override
    public Set<AttributeModifier> getCachedModifiers() {
        return this.cachedModifiers;
    }

    @Override
    public Collection<AttributeModifier> getModifiersForOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.id(), modifier);
        this.getModifiersForOperation(modifier.operation()).add(modifier);
        this.markChanged();
    }

    @Override
    public void addPersistentModifier(AttributeModifier modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public boolean hasModifier(ResourceLocation location) {
        return this.modifiers.containsKey(location);
    }

    @Override
    public void removeModifier(ResourceLocation location) {
        AttributeModifier modifier = this.modifiers.remove(location);
        if (modifier == null) {
            return;
        }
        this.persistentModifiers.remove(modifier);
        this.getModifiersForOperation(modifier.operation()).remove(modifier);
        this.markChanged();
    }

    @Override
    public void clearModifiers() {
        this.getModifiers().keySet().iterator().forEachRemaining(this::removeModifier);
    }

    @Override
    public void removeCachedModifiers(AttributeModifier modifier) {
        this.cachedModifiers.remove(modifier);
    }

    @Override
    public void clearCachedModifiers() {
        this.cachedModifiers.forEach((? super T cachedModifier) -> this.removeModifier(cachedModifier.id()));
        this.cachedModifiers.clear();
    }

    public void copyFrom(AccessoriesContainerImpl other) {
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.values().forEach(this::addTransientModifier);
        other.persistentModifiers.forEach(this::addPersistentModifier);
        this.update();
    }

    @Override
    public void encode(MapCarrierEncodable carrier, SerializationContext ctx) {
        this.write(carrier, ctx, false);
    }

    public void write(MapCarrierEncodable carrier, SerializationContext ctx, boolean sync) {
        carrier.put(SLOT_NAME_KEY, (Object)this.slotName);
        carrier.putIfNotNull(ctx, BASE_SIZE_KEY, (Object)this.baseSize);
        carrier.put(RENDER_OPTIONS_KEY, this.renderOptions);
        if (!sync || this.accessories.wasNewlyConstructed()) {
            carrier.put(CURRENT_SIZE_KEY, (Object)this.accessories.getContainerSize());
            carrier.put(ctx, ITEMS_KEY, this.accessories.saveItemsToList());
            carrier.put(ctx, COSMETICS_KEY, this.cosmeticAccessories.saveItemsToList());
        }
        if (sync) {
            if (!this.modifiers.isEmpty()) {
                ArrayList modifiersTag = new ArrayList();
                this.modifiers.values().forEach((? super T modifier) -> modifiersTag.add((CompoundTag)AttributeModifier.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, modifier).getOrThrow()));
                carrier.put(MODIFIERS_KEY, modifiersTag);
            }
        } else {
            if (!this.persistentModifiers.isEmpty()) {
                ArrayList persistentTag = new ArrayList();
                this.persistentModifiers.forEach((? super T modifier) -> persistentTag.add((CompoundTag)AttributeModifier.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, modifier).getOrThrow()));
                carrier.put(PERSISTENT_MODIFIERS_KEY, persistentTag);
            }
            if (!this.modifiers.isEmpty()) {
                ArrayList cachedTag = new ArrayList();
                this.modifiers.values().forEach((? super T modifier) -> {
                    if (this.persistentModifiers.contains(modifier)) {
                        return;
                    }
                    cachedTag.add((CompoundTag)AttributeModifier.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, modifier).getOrThrow());
                });
                carrier.put(CACHED_MODIFIERS_KEY, cachedTag);
            }
        }
    }

    @Override
    public void decode(MapCarrierDecodable carrier, SerializationContext ctx) {
        this.read(carrier, ctx, false);
    }

    public void read(MapCarrierDecodable carrier, SerializationContext ctx, boolean sync) {
        EndecUtils.dfuKeysCarrier(carrier, Map.of("SlotName", "slot_name", "BaseSize", "base_size", "CurrentSize", "current_size", "RenderOptions", "render_options", "Modifiers", "modifiers", "PersistentModifiers", "persistent_modifiers", "CachedModifiers", "cached_modifiers", "Items", "items", "Cosmetics", "cosmetics"));
        this.slotName = (String)carrier.get(SLOT_NAME_KEY);
        this.baseSize = (Integer)carrier.get(BASE_SIZE_KEY);
        if (sync) {
            this.modifiers.clear();
            this.persistentModifiers.clear();
            this.modifiersByOperation.clear();
            if (carrier.has(MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(MODIFIERS_KEY);
                for (CompoundTag compoundTag : persistentTag) {
                    AttributeModifier modifier = (AttributeModifier)AttributeModifier.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag).getOrThrow();
                    if (modifier == null) continue;
                    this.addTransientModifier(modifier);
                }
            }
        } else {
            AttributeModifier modifier;
            if (carrier.has(PERSISTENT_MODIFIERS_KEY)) {
                persistentTag = (List)carrier.get(PERSISTENT_MODIFIERS_KEY);
                for (CompoundTag compoundTag : persistentTag) {
                    modifier = (AttributeModifier)AttributeModifier.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag).getOrThrow();
                    if (modifier == null) continue;
                    this.addPersistentModifier(modifier);
                }
            }
            if (carrier.has(CACHED_MODIFIERS_KEY)) {
                List cachedTag = (List)carrier.get(CACHED_MODIFIERS_KEY);
                for (CompoundTag compoundTag : cachedTag) {
                    modifier = (AttributeModifier)AttributeModifier.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag).getOrThrow();
                    if (modifier == null) continue;
                    this.cachedModifiers.add(modifier);
                    this.addTransientModifier(modifier);
                }
                this.update();
            }
        }
        if (carrier.has(CURRENT_SIZE_KEY)) {
            ctx = ctx.withAttributes(new SerializationAttribute.Instance[]{ContainerAttribute.CONTAINER.instance((Object)new ContainerAttribute(this))});
            Integer currentSize = (Integer)carrier.get(CURRENT_SIZE_KEY);
            Map sentOptions = (Map)carrier.get(RENDER_OPTIONS_KEY);
            this.renderOptions = this.getWithSize(currentSize, sentOptions);
            if (this.accessories.getContainerSize() != currentSize.intValue()) {
                this.accessories = new ExpandedContainer(this, currentSize, "accessories");
                this.cosmeticAccessories = new ExpandedContainer(this, currentSize, "cosmetic_accessories");
            }
            this.accessories.loadItemsFromList((Collection)carrier.get(ctx, ITEMS_KEY));
            this.cosmeticAccessories.loadItemsFromList((Collection)carrier.get(ctx, COSMETICS_KEY));
        } else {
            this.renderOptions = (Map)carrier.get(RENDER_OPTIONS_KEY);
        }
    }

    private Map<Integer, Boolean> getWithSize(int size, Map<Integer, Boolean> map) {
        Int2BooleanLinkedOpenHashMap sizedList = new Int2BooleanLinkedOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            Boolean value;
            Boolean bl = value = i < map.size() ? map.get(i) : null;
            if (value == null) continue;
            sizedList.put(i, value.booleanValue());
        }
        return sizedList;
    }

    public static BaseContainer readContainer(MapCarrier carrier, SerializationContext ctx, KeyedEndec<List<ItemStackWithSlot>> key) {
        return AccessoriesContainerImpl.readContainers(carrier, ctx, key).get(0);
    }

    @SafeVarargs
    public static List<BaseContainer> readContainers(MapCarrier carrier, SerializationContext ctx, KeyedEndec<List<ItemStackWithSlot>> ... keys) {
        ArrayList<BaseContainer> containers = new ArrayList<BaseContainer>();
        for (KeyedEndec<List<ItemStackWithSlot>> key : keys) {
            BaseContainer stacks = new BaseContainer(new ItemStack[0]);
            if (carrier.has(key)) {
                stacks.loadItemsFromList((Collection)carrier.get(ctx, key));
            }
            containers.add(stacks);
        }
        return containers;
    }

    public static BaseContainer copyContainerList(BaseContainer container) {
        return new BaseContainer((ItemStack[])container.getItems().toArray(ItemStack[]::new));
    }

    private record ContainerAttribute(AccessoriesContainer container) implements SerializationAttribute.Instance
    {
        public static final SerializationAttribute.WithValue<ContainerAttribute> CONTAINER = SerializationAttribute.withValue((String)"accessories_container");

        public SerializationAttribute attribute() {
            return CONTAINER;
        }

        public Object value() {
            return this;
        }
    }

    private static final class ListFromMap<T>
    extends AbstractList<T> {
        private final Map<Integer, T> map;

        private ListFromMap(Map<Integer, T> map) {
            this.map = map;
        }

        public Map<Integer, T> map() {
            return this.map;
        }

        @Override
        public T get(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

