/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.core;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesLoaderInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.impl.caching.AccessoriesHolderLookupCache;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.utils.BaseContainer;
import io.wispforest.accessories.utils.ImmutableContainer;
import io.wispforest.accessories.utils.ItemStackMutation;
import io.wispforest.accessories.utils.ItemStackResize;
import io.wispforest.owo.util.EventSource;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ExpandedContainer
extends BaseContainer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesContainerImpl container;
    private final String name;
    private final NonNullList<ItemStack> previousItems;
    private final Int2BooleanMap setFlags = new Int2BooleanArrayMap();
    private boolean canFlagSetCalls = true;
    private boolean newlyConstructed;
    private final Int2ObjectMap<EventSource.Subscription> currentMutationSubscriptions = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<EventSource.Subscription> currentResizeSubscriptions = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<EventSource.Subscription> currentPrevResizeSubscriptions = new Int2ObjectOpenHashMap();

    public ExpandedContainer(AccessoriesContainerImpl container, int size, String name) {
        this(container, size, name, true);
    }

    public ExpandedContainer(AccessoriesContainerImpl container, int size, String name, boolean toggleNewlyConstructed) {
        super(size);
        this.container = container;
        this.addListener(container);
        if (toggleNewlyConstructed) {
            this.newlyConstructed = true;
        }
        this.name = name;
        this.previousItems = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public String name() {
        return this.name;
    }

    public Container toImmutable() {
        return new ImmutableContainer(this.getItems());
    }

    public boolean wasNewlyConstructed() {
        boolean bl = this.newlyConstructed;
        this.newlyConstructed = false;
        return bl;
    }

    public boolean isSlotFlagged(int slot) {
        boolean bl = this.setFlags.getOrDefault(slot, false);
        if (bl) {
            this.setFlags.put(slot, false);
        }
        return bl;
    }

    void toggleFlagablity() {
        this.canFlagSetCalls = !this.canFlagSetCalls;
    }

    private void removeAllSlotSubscription(int slot) {
        this.removeMutationSubscription(slot);
        this.removeResizeSubscription(slot);
        this.removePrevResizeSubscription(slot);
    }

    private void removePrevResizeSubscription(int slot) {
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentPrevResizeSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void removeResizeSubscription(int slot) {
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentResizeSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void removeMutationSubscription(int slot) {
        EventSource.Subscription subscription = (EventSource.Subscription)this.currentMutationSubscriptions.remove(slot);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public void setPreviousItem(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.previousItems.size()) {
            this.previousItems.set(slot, (Object)stack);
            this.removePrevResizeSubscription(slot);
            if (!stack.isEmpty()) {
                ItemStack stackCopy = stack.copy();
                this.currentPrevResizeSubscriptions.put(slot, (Object)ItemStackResize.getEvent(stack).source().subscribe((stack1, prevSize) -> {
                    boolean isEmpty;
                    boolean bl = isEmpty = stack1.getCount() <= 0;
                    if (isEmpty) {
                        this.previousItems.set(slot, (Object)stackCopy);
                        this.removePrevResizeSubscription(slot);
                    }
                }));
            }
        }
    }

    public ItemStack getPreviousItem(int slot) {
        return slot >= 0 && slot < this.previousItems.size() ? (ItemStack)this.previousItems.get(slot) : ItemStack.EMPTY;
    }

    public int getMaxStackSize(ItemStack itemStack) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(itemStack);
        return Math.min(super.getMaxStackSize(itemStack), accessory.maxStackSize(itemStack));
    }

    @Override
    public ItemStack getItem(int slot) {
        if (!this.validIndex(slot)) {
            return ItemStack.EMPTY;
        }
        return super.getItem(slot);
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        if (!this.validIndex(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = super.removeItem(slot, amount);
        if (!stack.isEmpty()) {
            ItemStack prevStack;
            if (this.canFlagSetCalls) {
                this.setFlags.put(slot, true);
            }
            if ((prevStack = this.getItem(slot)).isEmpty()) {
                this.removeMutationSubscription(slot);
                this.removeResizeSubscription(slot);
            }
            this.setPreviousItem(slot, stack);
        }
        return stack;
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        if (!this.validIndex(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = super.removeItemNoUpdate(slot);
        this.removeMutationSubscription(slot);
        this.removeResizeSubscription(slot);
        return stack;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        this.removeMutationSubscription(slot);
        this.removeResizeSubscription(slot);
        super.setItem(slot, stack);
        if (!stack.isEmpty()) {
            this.currentMutationSubscriptions.put(slot, (Object)ItemStackMutation.getEvent(stack).source().subscribe((stack1, types) -> {
                AccessoriesHolderLookupCache cache;
                if (types.contains(AccessoriesDataComponents.ATTRIBUTES) || types.contains(AccessoriesDataComponents.NESTED_ACCESSORIES)) {
                    this.setChanged();
                }
                if (!this.container.capability().entity().level().isClientSide() && (cache = AccessoriesHolderImpl.getHolder(this.container.capability()).getLookupCache()) != null) {
                    cache.invalidateLookupData(this.container.getSlotName(), stack1, types);
                }
            }));
            this.currentResizeSubscriptions.put(slot, (Object)ItemStackResize.getEvent(stack).source().subscribe((stack1, prevSize) -> {
                if (stack1.isEmpty()) {
                    this.setItem(slot, ItemStack.EMPTY);
                }
            }));
        }
        if (this.canFlagSetCalls) {
            this.setFlags.put(slot, true);
        }
    }

    public boolean validIndex(int slot) {
        boolean isValid;
        boolean bl = isValid = slot >= 0 && slot < this.getContainerSize();
        if (!isValid && AccessoriesLoaderInternals.INSTANCE.isDevelopmentEnv()) {
            String nameInfo = this.name != null ? "Container: " + this.name + ", " : "";
            try {
                throw new IllegalStateException("Access to a given Inventory was found to be out of the range valid for the container! [Name: " + nameInfo + " Index: " + slot + "]");
            }
            catch (Exception e) {
                LOGGER.debug("Full Exception: ", (Throwable)e);
            }
        }
        return isValid;
    }

    @Override
    public void loadItemsFromList(Collection<ItemStackWithSlot> slottedStacks) {
        this.container.containerListenerLock = true;
        AccessoriesCapability capability = this.container.capability();
        ArrayList<ItemStack> prevStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack currentStack = this.getItem(i);
            prevStacks.add(currentStack);
            this.setItem(i, ItemStack.EMPTY);
        }
        ArrayList<ItemStack> invalidStacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> decodedStacks = new ArrayList<ItemStack>();
        for (ItemStackWithSlot slottedStack : slottedStacks) {
            ItemStack stack = slottedStack.stack();
            decodedStacks.add(stack);
            if (slottedStack.isValidInContainer(this.getContainerSize())) {
                this.setItem(slottedStack.slot(), stack);
                continue;
            }
            invalidStacks.add(stack);
        }
        this.container.containerListenerLock = false;
        if (!capability.entity().level().isClientSide()) {
            if (!prevStacks.equals(decodedStacks)) {
                this.setChanged();
            }
            AccessoriesHolderImpl.getHolder((AccessoriesCapability)capability).invalidStacks.addAll(invalidStacks);
        }
    }

    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ExpandedContainer.this.getContainerSize();
            }

            @Override
            public ItemStack next() {
                ItemStack stack = ExpandedContainer.this.getItem(this.index);
                ++this.index;
                return stack;
            }
        };
    }

    public void foreach(BiConsumer<Integer, ItemStack> consumer) {
        int i = 0;
        Iterator<ItemStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            consumer.accept(i, itemStack);
            ++i;
        }
    }

    public <T> T foreach(BiFunction<Integer, ItemStack, @Nullable T> consumer) {
        int i = 0;
        Iterator<ItemStack> iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            T result = consumer.apply(i, itemStack);
            if (result != null) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public void setFromPrev(ExpandedContainer prevContainer) {
        int i = 0;
        Iterator<ItemStack> iterator = prevContainer.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            prevContainer.removeMutationSubscription(i);
            this.setPreviousItem(i, itemStack);
            ++i;
        }
    }

    public void copyPrev(ExpandedContainer prevContainer) {
        for (int i = 0; i < prevContainer.getContainerSize(); ++i) {
            if (i >= this.getContainerSize()) continue;
            ItemStack prevItem = prevContainer.getPreviousItem(i);
            prevContainer.removeAllSlotSubscription(i);
            if (prevItem.isEmpty()) continue;
            this.setPreviousItem(i, prevItem);
        }
    }
}

