/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesClientInternals;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryMobEffectsComponent;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryNestUtils;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.events.ContainersChangeCallback;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.accessories.misc.AccessoriesGameRules;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.networking.client.SyncPlayerOptions;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.util.MapCarrierEncodable;
import io.wispforest.owo.serialization.RegistriesAttribute;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesEventHandler {
    public static boolean dataReloadOccurred = false;

    public static void onWorldTick(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AccessoriesEventHandler.revalidatePlayersOnReload(serverLevel.getServer().getPlayerList());
    }

    public static void revalidatePlayersOnReload(PlayerList playerList) {
        if (!dataReloadOccurred) {
            return;
        }
        for (ServerPlayer player : playerList.getPlayers()) {
            AccessoriesEventHandler.revalidatePlayer(player);
        }
        dataReloadOccurred = false;
    }

    public static void revalidatePlayer(ServerPlayer player) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability == null) {
            return;
        }
        Collection<SlotType> validSlotTypes = EntitySlotLoader.getEntitySlots((LivingEntity)player).values();
        AccessoriesHolderImpl holderImpl = AccessoriesHolderImpl.getHolder(capability);
        holderImpl.setValidTypes(validSlotTypes.stream().map(SlotType::name).collect(Collectors.toSet()));
        for (AccessoriesContainer container : holderImpl.getAllSlotContainers().values()) {
            SlotType slotType = container.slotType();
            if (slotType != null && validSlotTypes.contains(slotType)) {
                Integer baseSize = ((AccessoriesContainerImpl)container).getBaseSize();
                if (baseSize == null || baseSize.intValue() != slotType.amount()) {
                    container.markChanged();
                    container.update();
                }
                ExpandedContainer stacks = container.getAccessories();
                ExpandedContainer cosmeticStacks = container.getCosmeticAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    SlotReference reference = container.createReference(i);
                    AccessoriesEventHandler.handleInvalidStacks(stacks, reference, player);
                    AccessoriesEventHandler.handleInvalidStacks(cosmeticStacks, reference, player);
                }
                continue;
            }
            ExpandedContainer stacks = container.getAccessories();
            ExpandedContainer cosmeticStacks = container.getCosmeticAccessories();
            for (int i = 0; i < container.getSize(); ++i) {
                SlotReference reference = container.createReference(i);
                AccessoriesEventHandler.dropAndRemoveStack(stacks, reference, player);
                AccessoriesEventHandler.dropAndRemoveStack(cosmeticStacks, reference, player);
            }
        }
    }

    private static void handleInvalidStacks(Container container, SlotReference reference, ServerPlayer player) {
        boolean bl;
        ItemStack stack = container.getItem(reference.index());
        if (stack.isEmpty()) {
            return;
        }
        boolean bl2 = bl = !SlotPredicateRegistry.canInsertIntoSlot(stack, reference);
        if (bl) {
            AccessoriesEventHandler.dropAndRemoveStack(container, reference, player);
        }
    }

    private static void dropAndRemoveStack(Container container, SlotReference reference, ServerPlayer player) {
        ItemStack stack = container.getItem(reference.index());
        container.setItem(reference.index(), ItemStack.EMPTY);
        AccessoriesInternals.INSTANCE.giveItemToPlayer(player, stack);
    }

    public static void entityLoad(LivingEntity entity, Level level) {
        if (!level.isClientSide() || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        SyncEntireContainer.syncToAllTrackingAndSelf(serverPlayer);
    }

    public static void onTracking(LivingEntity entity, ServerPlayer serverPlayer) {
        SyncEntireContainer.syncTo(entity, packet -> AccessoriesNetworking.sendToPlayer(serverPlayer, packet));
    }

    public static void dataSync(@Nullable PlayerList list, @Nullable ServerPlayer player) {
        if (list != null && !list.getPlayers().isEmpty()) {
            AccessoriesEventHandler.revalidatePlayersOnReload(list);
            for (ServerPlayer playerEntry : list.getPlayers()) {
                AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)playerEntry);
                if (capability == null) {
                    return;
                }
                NbtMapCarrier carrier = NbtMapCarrier.of();
                AccessoriesHolderImpl.getHolder(capability).encode((MapCarrierEncodable)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)playerEntry.level().registryAccess())}));
                AccessoriesNetworking.sendToTrackingAndSelf((Entity)playerEntry, new SyncEntireContainer(capability.entity().getId(), carrier));
                AbstractContainerMenu abstractContainerMenu = playerEntry.containerMenu;
                if (!(abstractContainerMenu instanceof AccessoriesMenuBase)) continue;
                AccessoriesMenuBase base = (AccessoriesMenuBase)abstractContainerMenu;
                Accessories.openAccessoriesMenu((Player)playerEntry, base.menuVariant(), base.targetEntity());
            }
        } else if (player != null) {
            AccessoriesEventHandler.revalidatePlayer(player);
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
            if (capability == null) {
                return;
            }
            NbtMapCarrier carrier = NbtMapCarrier.of();
            AccessoriesHolderImpl.getHolder(capability).encode((MapCarrierEncodable)carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)player.level().registryAccess())}));
            AccessoriesNetworking.sendToPlayer(player, new SyncEntireContainer(capability.entity().getId(), carrier));
            AccessoriesNetworking.sendToPlayer(player, new SyncPlayerOptions(AccessoriesPlayerOptionsHolder.getOptions((Player)player)));
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof AccessoriesMenuBase) {
                AccessoriesMenuBase base = (AccessoriesMenuBase)abstractContainerMenu;
                Accessories.openAccessoriesMenu((Player)player, base.menuVariant(), base.targetEntity());
            }
        }
        AccessoriesHolderImpl.clearValidationCache(false);
    }

    public static void onLivingEntityTick(LivingEntity entity) {
        Object object;
        List<ItemStack> invalidStacks;
        AccessoriesHolderImpl holder;
        Object dirtyCosmeticStacks;
        if (entity.isRemoved()) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            HashMap<String, ItemStack> dirtyStacks = new HashMap<String, ItemStack>();
            dirtyCosmeticStacks = new HashMap();
            AccessoryAttributeBuilder removedAttributesBuilder = new AccessoryAttributeBuilder();
            AccessoryAttributeBuilder addedAttributesBuilder = new AccessoryAttributeBuilder();
            for (Map.Entry<String, AccessoriesContainer> containerEntry : AccessoriesHolderImpl.getHolder(capability).getAllSlotContainers().entrySet()) {
                AccessoriesContainer container = containerEntry.getValue();
                ExpandedContainer accessories = container.getAccessories();
                ExpandedContainer cosmetics = container.getCosmeticAccessories();
                for (int i = 0; i < accessories.getContainerSize(); ++i) {
                    ItemStack lastCosmeticStack;
                    ItemStack currentCosmeticStack;
                    SlotReference slotReference = container.createReference(i);
                    String slotId = container.getSlotName() + "/" + i;
                    ItemStack currentStack = accessories.getItem(i);
                    if (!currentStack.isEmpty()) {
                        currentStack.inventoryTick(entity.level(), (Entity)entity, null);
                        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(currentStack);
                        if (accessory != null) {
                            accessory.tick(currentStack, slotReference);
                            AccessoryNestUtils.recursivelyConsume(currentStack, stack -> {
                                AccessoryMobEffectsComponent effects = (AccessoryMobEffectsComponent)stack.get(AccessoriesDataComponents.MOB_EFFECTS);
                                if (effects != null) {
                                    effects.handleReapplyingEffects(entity, entity.level().getGameTime());
                                }
                            });
                        }
                    }
                    ItemStack lastStack = accessories.getPreviousItem(i);
                    boolean flagged = accessories.isSlotFlagged(i);
                    if (entity.level().isClientSide() || entity.isDeadOrDying()) continue;
                    if (!ItemStack.matches((ItemStack)currentStack, (ItemStack)lastStack) || flagged) {
                        if (!lastStack.isEmpty()) {
                            AccessoryAttributeBuilder removedEnchantmentBuilder = new AccessoryAttributeBuilder(slotReference);
                            EnchantmentHelper.forEachModifier((ItemStack)lastStack, (EquipmentSlot)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot(), (attributeHolder, modifier) -> {
                                String namespace = modifier.id().getNamespace();
                                ArrayList<String> splitPath = new ArrayList<String>(List.of(modifier.id().getPath().split("/")));
                                splitPath.removeLast();
                                removedEnchantmentBuilder.addStackable((Holder<Attribute>)attributeHolder, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)String.join((CharSequence)"/", splitPath)), modifier.amount(), modifier.operation()));
                            });
                            removedAttributesBuilder.addFrom(removedEnchantmentBuilder);
                            removedAttributesBuilder.addFrom(AccessoryAttributeLogic.getAttributeModifiers(lastStack, slotReference));
                            ((AccessoriesLivingEntityExtension)entity).pushEnchantmentContext(lastStack, slotReference);
                            EnchantmentHelper.stopLocationBasedEffects((ItemStack)lastStack, (LivingEntity)entity, (EquipmentSlot)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot());
                        }
                        if (!currentStack.isEmpty()) {
                            AccessoryAttributeBuilder addedEnchantmentBuilder = new AccessoryAttributeBuilder(slotReference);
                            EnchantmentHelper.forEachModifier((ItemStack)currentStack, (EquipmentSlot)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot(), (attributeHolder, modifier) -> {
                                String namespace = modifier.id().getNamespace();
                                ArrayList<String> splitPath = new ArrayList<String>(List.of(modifier.id().getPath().split("/")));
                                splitPath.removeLast();
                                addedEnchantmentBuilder.addStackable((Holder<Attribute>)attributeHolder, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)String.join((CharSequence)"/", splitPath)), modifier.amount(), modifier.operation()));
                            });
                            addedAttributesBuilder.addFrom(addedEnchantmentBuilder);
                            addedAttributesBuilder.addFrom(AccessoryAttributeLogic.getAttributeModifiers(currentStack, slotReference));
                            ((AccessoriesLivingEntityExtension)entity).pushEnchantmentContext(currentStack, slotReference);
                            EnchantmentHelper.runLocationChangedEffects((ServerLevel)((ServerLevel)entity.level()), (ItemStack)currentStack, (LivingEntity)entity, (EquipmentSlot)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot());
                        }
                        AccessoryNestUtils.recursivelyConsume(lastStack, stack -> {
                            if (stack.has(AccessoriesDataComponents.MOB_EFFECTS)) {
                                ((AccessoryMobEffectsComponent)stack.get(AccessoriesDataComponents.MOB_EFFECTS)).handleRemovingEffects(entity);
                            }
                        });
                        AccessoryNestUtils.recursivelyConsume(currentStack, stack -> {
                            if (stack.has(AccessoriesDataComponents.MOB_EFFECTS)) {
                                ((AccessoryMobEffectsComponent)stack.get(AccessoriesDataComponents.MOB_EFFECTS)).handleApplyingConstantEffects(entity);
                            }
                        });
                        boolean equipmentChange = false;
                        if (!ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)lastStack) || flagged) {
                            AccessoryRegistry.getAccessoryOrDefault(lastStack).onUnequip(lastStack, slotReference);
                            AccessoryRegistry.getAccessoryOrDefault(currentStack).onEquip(currentStack, slotReference);
                            if (entity instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)entity;
                                if (!currentStack.isEmpty()) {
                                    Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
                                }
                                if (!lastStack.isEmpty()) {
                                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
                                }
                            }
                            equipmentChange = true;
                        }
                        ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastStack, currentStack, slotReference, equipmentChange ? SlotStateChange.REPLACEMENT : SlotStateChange.MUTATION);
                        container.getAccessories().setPreviousItem(i, currentStack);
                        dirtyStacks.put(slotId, currentStack.copy());
                        AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastStack), AccessoryNestUtils.getData(currentStack));
                    }
                    if (ItemStack.matches((ItemStack)(currentCosmeticStack = cosmetics.getItem(i)), (ItemStack)(lastCosmeticStack = container.getCosmeticAccessories().getPreviousItem(i)))) continue;
                    cosmetics.setPreviousItem(i, currentCosmeticStack);
                    ((HashMap)dirtyCosmeticStacks).put(slotId, currentCosmeticStack.copy());
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (!currentStack.isEmpty()) {
                        Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, true);
                    }
                    if (lastStack.isEmpty()) continue;
                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, true);
                }
            }
            if (entity.level().isClientSide()) {
                return;
            }
            AttributeUtils.removeTransientAttributeModifiers(entity, removedAttributesBuilder);
            AttributeUtils.addTransientAttributeModifiers(entity, addedAttributesBuilder);
            Map<AccessoriesContainer, Boolean> updatedContainers = AccessoriesHolderImpl.getHolder(capability).containersRequiringUpdates();
            capability.updateContainers();
            ((ContainersChangeCallback)ContainersChangeCallback.EVENT.invoker()).onChange(entity, capability, (Map<AccessoriesContainer, Boolean>)ImmutableMap.copyOf(updatedContainers));
            if (!(dirtyStacks.isEmpty() && ((HashMap)dirtyCosmeticStacks).isEmpty() && updatedContainers.isEmpty())) {
                SyncContainerData packet = SyncContainerData.of(entity, updatedContainers.keySet(), dirtyStacks, (Map<String, ItemStack>)dirtyCosmeticStacks);
                AccessoriesNetworking.sendToTrackingAndSelf((Entity)entity, packet);
            }
            updatedContainers.clear();
        }
        if ((holder = AccessoriesInternals.INSTANCE.getHolder(entity)).loadedFromTag() && capability == null) {
            dirtyCosmeticStacks = new AccessoriesCapabilityImpl(entity);
        }
        if (!(invalidStacks = holder.invalidStacks).isEmpty() && (object = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (ItemStack invalidStack : invalidStacks) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    AccessoriesInternals.INSTANCE.giveItemToPlayer(serverPlayer, invalidStack);
                    continue;
                }
                entity.spawnAtLocation(serverLevel, invalidStack);
            }
            invalidStacks.clear();
        }
    }

    private static void recursiveStackChange(SlotReference slotReference, @Nullable AccessoryNestContainerContents lastNestData, @Nullable AccessoryNestContainerContents currentNestData) {
        HashMap currentNestChanges = currentNestData != null ? currentNestData.slotChanges() : new HashMap();
        List lastInnerStacks = lastNestData != null ? List.copyOf(lastNestData.getMap(slotReference).entrySet()) : List.of();
        List currentInnerStacks = currentNestData != null ? List.copyOf(currentNestData.getMap(slotReference).entrySet()) : List.of();
        int maxIterationLength = Math.max(lastInnerStacks.size(), currentInnerStacks.size());
        for (int i = 0; i < maxIterationLength; ++i) {
            SlotEntryReference currentRef;
            Map.Entry lastInnerEntry = i < lastInnerStacks.size() ? (Map.Entry)lastInnerStacks.get(i) : null;
            Map.Entry currentInnerEntry = i < currentInnerStacks.size() ? (Map.Entry)currentInnerStacks.get(i) : null;
            SlotStateChange changeType = currentNestChanges.getOrDefault(i, SlotStateChange.REPLACEMENT);
            if (lastInnerEntry == null && currentInnerEntry != null) {
                currentRef = (SlotEntryReference)currentInnerEntry.getKey();
                ItemStack currentInnerStack = currentRef.stack();
                AccessoriesEventHandler.onStackChange(currentRef.reference(), ItemStack.EMPTY, currentRef.stack(), changeType);
                AccessoriesEventHandler.recursiveStackChange(slotReference, null, AccessoryNestUtils.getData(currentInnerStack));
                continue;
            }
            if (currentInnerEntry == null && lastInnerEntry != null) {
                SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
                ItemStack lastInnerStack = lastRef.stack();
                AccessoriesEventHandler.onStackChange(lastRef.reference(), lastRef.stack(), ItemStack.EMPTY, changeType);
                AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), null);
                continue;
            }
            if (lastInnerEntry == null || currentInnerEntry == null) continue;
            currentRef = (SlotEntryReference)currentInnerEntry.getKey();
            SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
            SlotReference innerRef = lastRef.reference();
            ItemStack currentInnerStack = currentRef.stack();
            ItemStack lastInnerStack = lastRef.stack();
            AccessoriesEventHandler.onStackChange(innerRef, lastInnerStack, currentInnerStack, changeType);
            AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), AccessoryNestUtils.getData(currentInnerStack));
        }
        currentNestChanges.clear();
    }

    private static void onStackChange(SlotReference slotReference, ItemStack lastStack, ItemStack currentStack, SlotStateChange stateChange) {
        LivingEntity livingEntity = slotReference.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (!currentStack.isEmpty()) {
                Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
            }
            if (!lastStack.isEmpty()) {
                Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
            }
        }
        ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastStack, currentStack, slotReference, stateChange);
    }

    public static void getTooltipData(@Nullable LivingEntity entity, ItemStack stack, List<Component> tooltip, TooltipDisplay display, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory != null) {
            tooltipType = AccessoriesClientInternals.getInstance().createTooltipFlag(tooltipType);
            if (entity != null && AccessoriesCapability.get(entity) != null) {
                AccessoriesEventHandler.addEntityBasedTooltipData(entity, accessory, stack, tooltip, display, tooltipContext, tooltipType);
            }
            accessory.getExtraTooltip(stack, tooltip, tooltipContext, tooltipType);
        }
    }

    private static void addEntityBasedTooltipData(LivingEntity entity, Accessory accessory, ItemStack stack, List<Component> tooltip, TooltipDisplay display, Item.TooltipContext tooltipContext, TooltipFlag tooltipType) {
        HashSet<SlotType> validSlotTypes = new HashSet<SlotType>(SlotPredicateRegistry.getValidSlotTypes(entity, stack));
        if (validSlotTypes.isEmpty()) {
            return;
        }
        HashSet validUniqueSlots = new HashSet();
        validSlotTypes.removeIf(slotType -> {
            boolean isUnique = UniqueSlotHandling.isUniqueSlot(slotType.name());
            if (isUnique) {
                validUniqueSlots.add(slotType);
            }
            return isUnique;
        });
        Set sharedSlotTypes = SlotTypeLoader.INSTANCE.getEntries(entity.level()).values().stream().filter(slotType -> !UniqueSlotHandling.isUniqueSlot(slotType.name())).collect(Collectors.toSet());
        MutableComponent slotInfoComponent = Component.literal((String)"");
        MutableComponent slotsComponent = Component.literal((String)"");
        boolean allSlots = false;
        if (validSlotTypes.containsAll(sharedSlotTypes)) {
            slotsComponent.append((Component)Component.translatable((String)Accessories.translationKey("slot.any")));
            allSlots = true;
        } else {
            Set<SlotType> entitySlotTypes = Set.copyOf(EntitySlotLoader.getEntitySlots(entity).values());
            Sets.SetView invalidSlotsTypes = Sets.difference(entitySlotTypes, validSlotTypes);
            if (invalidSlotsTypes.size() < validSlotTypes.size()) {
                slotsComponent.append((Component)Component.translatable((String)Accessories.translationKey("slot.any")));
                slotsComponent.append((Component)Component.translatable((String)Accessories.translationKey("slot.except")).withStyle(ChatFormatting.GRAY));
                UnmodifiableIterator invalidSlotsItr = invalidSlotsTypes.iterator();
                while (invalidSlotsItr.hasNext()) {
                    type = (SlotType)invalidSlotsItr.next();
                    if (!ExtraSlotTypeProperties.getProperty(type.name(), entity.level().isClientSide()).allowTooltipInfo()) continue;
                    slotsComponent.append((Component)Component.translatable((String)type.translation()).withStyle(ChatFormatting.RED));
                    if (!invalidSlotsItr.hasNext()) continue;
                    slotsComponent.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY));
                }
            } else {
                Iterator<SlotType> validSlotsItr = validSlotTypes.iterator();
                while (validSlotsItr.hasNext()) {
                    type = validSlotsItr.next();
                    if (!ExtraSlotTypeProperties.getProperty(type.name(), entity.level().isClientSide()).allowTooltipInfo()) continue;
                    slotsComponent.append((Component)Component.translatable((String)type.translation()));
                    if (!validSlotsItr.hasNext()) continue;
                    slotsComponent.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY));
                }
            }
        }
        validSlotTypes.addAll(validUniqueSlots);
        List<SlotType> filteredValidUniqueSlots = validUniqueSlots.stream().filter(slotType -> ExtraSlotTypeProperties.getProperty(slotType.name(), true).allowTooltipInfo()).toList();
        if (!filteredValidUniqueSlots.isEmpty()) {
            Iterator<SlotType> uniqueItr = filteredValidUniqueSlots.iterator();
            while (uniqueItr.hasNext()) {
                SlotType type = uniqueItr.next();
                slotsComponent.append((Component)Component.translatable((String)type.translation()));
                if (!uniqueItr.hasNext()) continue;
                slotsComponent.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY));
            }
        }
        if (!slotsComponent.getSiblings().isEmpty()) {
            String slotTranslationKey = "slot.tooltip." + (validSlotTypes.size() > 1 && !allSlots ? "plural" : "singular");
            slotInfoComponent.append((Component)Component.translatable((String)Accessories.translationKey(slotTranslationKey)).withStyle(ChatFormatting.GRAY).append((Component)slotsComponent.withStyle(ChatFormatting.BLUE)));
            tooltip.add((Component)slotInfoComponent);
        }
        HashMap<SlotType, AccessoryAttributeBuilder> slotSpecificModifiers = new HashMap<SlotType, AccessoryAttributeBuilder>();
        AccessoryAttributeBuilder defaultModifiers = null;
        boolean allDuplicates = true;
        for (SlotType slotType2 : validSlotTypes) {
            SlotReference reference = SlotReference.of(entity, slotType2.name(), 0);
            AccessoryAttributeBuilder builder = AccessoryAttributeLogic.getAttributeModifiers(stack, reference, true);
            if (builder.isEmpty()) continue;
            slotSpecificModifiers.put(slotType2, builder);
            if (defaultModifiers == null) {
                defaultModifiers = builder;
                continue;
            }
            if (!allDuplicates) continue;
            allDuplicates = defaultModifiers.equalWithoutPaths(builder);
        }
        HashMap<SlotType, List> slotTypeToTooltipInfo = new HashMap<SlotType, List>();
        if (allDuplicates) {
            if (defaultModifiers != null && !defaultModifiers.isEmpty()) {
                ArrayList<Component> attributeTooltip = new ArrayList<Component>();
                AccessoriesEventHandler.addAttributeTooltip(entity, stack, defaultModifiers.getAttributeModifiers(false), attributeTooltip, display, tooltipContext, tooltipType);
                slotTypeToTooltipInfo.put(null, attributeTooltip);
            }
        } else {
            for (Map.Entry slotModifiers : slotSpecificModifiers.entrySet()) {
                SlotType slotType3 = (SlotType)slotModifiers.getKey();
                AccessoryAttributeBuilder modifiers = (AccessoryAttributeBuilder)slotModifiers.getValue();
                ArrayList<Component> attributeTooltip = new ArrayList<Component>();
                AccessoriesEventHandler.addAttributeTooltip(entity, stack, modifiers.getAttributeModifiers(false), attributeTooltip, display, tooltipContext, tooltipType);
                slotTypeToTooltipInfo.put(slotType3, attributeTooltip);
            }
        }
        HashMap<SlotType, List> extraAttributeTooltips = new HashMap<SlotType, List>();
        ArrayList<Component> defaultExtraAttributeTooltip = null;
        boolean allDuplicatesExtras = true;
        for (SlotType slotType4 : validSlotTypes) {
            ArrayList<Component> extraAttributeTooltip = new ArrayList<Component>();
            accessory.getAttributesTooltip(stack, slotType4, extraAttributeTooltip, tooltipContext, tooltipType);
            extraAttributeTooltips.put(slotType4, extraAttributeTooltip);
            if (defaultExtraAttributeTooltip == null) {
                defaultExtraAttributeTooltip = extraAttributeTooltip;
                continue;
            }
            if (!allDuplicatesExtras) continue;
            allDuplicatesExtras = extraAttributeTooltip.equals(defaultExtraAttributeTooltip);
        }
        if (allDuplicatesExtras) {
            if (defaultExtraAttributeTooltip != null) {
                slotTypeToTooltipInfo.computeIfAbsent(null, s -> new ArrayList()).addAll(defaultExtraAttributeTooltip);
            }
        } else {
            extraAttributeTooltips.forEach((slotType, components) -> slotTypeToTooltipInfo.computeIfAbsent((SlotType)slotType, s -> new ArrayList()).addAll(components));
        }
        if (slotTypeToTooltipInfo.containsKey(null)) {
            List anyTooltipInfo = (List)slotTypeToTooltipInfo.get(null);
            if (!anyTooltipInfo.isEmpty()) {
                tooltip.add(CommonComponents.EMPTY);
                tooltip.add((Component)Component.translatable((String)Accessories.translationKey("tooltip.attributes.any")).withStyle(ChatFormatting.GRAY));
                tooltip.addAll(anyTooltipInfo);
            }
            slotTypeToTooltipInfo.remove(null);
        }
        if (!slotTypeToTooltipInfo.isEmpty()) {
            for (Map.Entry entry : slotTypeToTooltipInfo.entrySet()) {
                List tooltipData = (List)entry.getValue();
                if (tooltipData.isEmpty()) continue;
                tooltip.add(CommonComponents.EMPTY);
                tooltip.add((Component)Component.translatable((String)Accessories.translationKey("tooltip.attributes.slot"), (Object[])new Object[]{Component.translatable((String)((SlotType)entry.getKey()).translation()).withStyle(ChatFormatting.BLUE)}).withStyle(ChatFormatting.GRAY));
                tooltip.addAll((Collection)entry.getValue());
            }
        }
    }

    private static void addAttributeTooltip(LivingEntity entity, ItemStack stack, Multimap<Holder<Attribute>, AttributeModifier> multimap, List<Component> tooltip, TooltipDisplay display, Item.TooltipContext context, TooltipFlag flag) {
        Player player;
        if (multimap.isEmpty()) {
            return;
        }
        AccessoriesInternals.INSTANCE.addAttributeTooltips(entity instanceof Player ? (player = (Player)entity) : null, stack, multimap, tooltip::add, display, context, flag);
    }

    @Nullable
    public static Collection<ItemStack> onDeath(LivingEntity entity, DamageSource source) {
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return List.of();
        }
        ArrayList<ItemStack> droppedStacks = new ArrayList<ItemStack>();
        GameRules gamerules = ((ServerLevel)entity.level()).getGameRules();
        boolean keepInv = ((GameRules.BooleanValue)gamerules.getRule(GameRules.RULE_KEEPINVENTORY)).get() || ((GameRules.BooleanValue)gamerules.getRule(AccessoriesGameRules.RULE_KEEP_ACCESSORY_INVENTORY)).get();
        for (Map.Entry<String, AccessoriesContainer> containerEntry : AccessoriesHolderImpl.getHolder(capability).getAllSlotContainers().entrySet()) {
            SlotType slotType = containerEntry.getValue().slotType();
            DropRule slotDropRule = slotType != null ? slotType.dropRule() : DropRule.DEFAULT;
            AccessoriesContainer container = containerEntry.getValue();
            ExpandedContainer stacks = container.getAccessories();
            ExpandedContainer cosmeticStacks = container.getCosmeticAccessories();
            for (int i = 0; i < container.getSize(); ++i) {
                ItemStack cosmeticStack;
                SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                ItemStack stack = AccessoriesEventHandler.dropStack(slotDropRule, entity, stacks, reference, source, keepInv);
                if (stack != null) {
                    droppedStacks.add(stack);
                }
                if ((cosmeticStack = AccessoriesEventHandler.dropStack(slotDropRule, entity, cosmeticStacks, reference, source, keepInv)) == null) continue;
                droppedStacks.add(cosmeticStack);
            }
        }
        TriState result = ((OnDeathCallback)OnDeathCallback.EVENT.invoker()).shouldDrop(TriState.DEFAULT, entity, capability, source, droppedStacks);
        if (!result.orElse(true)) {
            return null;
        }
        return droppedStacks;
    }

    @Nullable
    private static ItemStack dropStack(DropRule dropRule, LivingEntity entity, ExpandedContainer container, SlotReference reference, DamageSource source, boolean keepInvEnabled) {
        ItemStack stack = container.getItem(reference.index());
        if (stack.isEmpty()) {
            return null;
        }
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        if (accessory != null && dropRule == DropRule.DEFAULT) {
            dropRule = accessory.getDropRule(stack, reference, source);
        }
        if (accessory instanceof AccessoryNest) {
            AccessoryNest holdable = (AccessoryNest)accessory;
            List<Pair<DropRule, ItemStack>> dropRuleToStacks = holdable.getDropRules(stack, reference, source);
            for (int i = 0; i < dropRuleToStacks.size(); ++i) {
                boolean breakInnerStack;
                Pair<DropRule, ItemStack> rulePair = dropRuleToStacks.get(i);
                ItemStack innerStack = (ItemStack)rulePair.right();
                DropRule result = OnDropCallback.getAlternativeRule((DropRule)((Object)rulePair.left()), innerStack, reference, source);
                boolean bl = breakInnerStack = result == DropRule.DEFAULT && EnchantmentHelper.has((ItemStack)innerStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) || result == DropRule.DESTROY;
                if (!breakInnerStack) continue;
                holdable.setInnerStack(stack, i, ItemStack.EMPTY);
                container.setItem(reference.index(), stack);
            }
        }
        DropRule result = OnDropCallback.getAlternativeRule(dropRule, stack, reference, source);
        boolean dropStack = true;
        boolean keepingStack = false;
        if (result == DropRule.DESTROY) {
            container.setItem(reference.index(), ItemStack.EMPTY);
            dropStack = false;
        } else if (result == DropRule.KEEP) {
            dropStack = false;
            keepingStack = true;
        } else if (result == DropRule.DEFAULT) {
            if (keepInvEnabled) {
                dropStack = false;
                keepingStack = true;
            } else if (EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
                container.setItem(reference.index(), ItemStack.EMPTY);
                dropStack = false;
            }
        }
        if (keepingStack) {
            container.setPreviousItem(reference.index(), ItemStack.EMPTY);
        }
        if (!dropStack) {
            return null;
        }
        container.setItem(reference.index(), ItemStack.EMPTY);
        return stack;
    }

    public static InteractionResult attemptEquipFromUse(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
        if (capability != null && !player.isSpectator() && !stack.isEmpty()) {
            PlayerEquipControl equipControl = AccessoriesPlayerOptionsHolder.getOptions(player).getDefaultedData(PlayerOptions.EQUIP_CONTROL);
            boolean shouldAttemptEquip = false;
            if (equipControl == PlayerEquipControl.MUST_CROUCH && player.isShiftKeyDown()) {
                shouldAttemptEquip = true;
            } else if (equipControl == PlayerEquipControl.MUST_NOT_CROUCH && !player.isShiftKeyDown()) {
                shouldAttemptEquip = true;
            }
            if (shouldAttemptEquip) {
                Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
                Pair<SlotReference, EquipAction> equipReference = capability.canEquipAccessory(stack, true);
                if (equipReference != null && accessory.canEquipFromUse(stack, (SlotReference)equipReference.left())) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                    ItemStack newHandStack = stack.copy();
                    Optional<ItemStack> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                    if (possibleSwappedStack.isPresent()) {
                        ItemStack swappedStack = possibleSwappedStack.get();
                        if (newHandStack.isEmpty()) {
                            newHandStack = swappedStack;
                        } else if (ItemStack.isSameItemSameComponents((ItemStack)newHandStack, (ItemStack)swappedStack) && newHandStack.getCount() + swappedStack.getCount() <= newHandStack.getMaxStackSize()) {
                            newHandStack.grow(swappedStack.getCount());
                        } else {
                            player.addItem(swappedStack);
                        }
                    }
                    return InteractionResult.SUCCESS.heldItemTransformedTo(newHandStack);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult attemptEquipOnEntity(Player player, InteractionHand hand, Entity entity) {
        LivingEntity targetEntity;
        ItemStack stack;
        block12: {
            block11: {
                stack = player.getItemInHand(hand);
                if (!(entity instanceof LivingEntity)) break block11;
                targetEntity = (LivingEntity)entity;
                if (entity.getType().is(AccessoriesTags.EQUIPMENT_MANAGEABLE)) break block12;
            }
            return InteractionResult.PASS;
        }
        AccessoriesCapability targetCapability = AccessoriesCapability.get(targetEntity);
        boolean canModify = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null).orElse(false);
        if (canModify && targetCapability != null && !player.isSpectator() && player.isShiftKeyDown()) {
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
            Pair<SlotReference, EquipAction> equipReference = targetCapability.canEquipAccessory(stack, true);
            if (equipReference != null && accessory.canEquipFromUse(stack, (SlotReference)equipReference.left())) {
                if (!stack.isEmpty()) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                }
                ItemStack newHandStack = stack.copy();
                Optional<ItemStack> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                if (possibleSwappedStack.isPresent()) {
                    ItemStack swappedStack = possibleSwappedStack.get();
                    if (newHandStack.isEmpty()) {
                        newHandStack = swappedStack;
                    } else if (ItemStack.isSameItemSameComponents((ItemStack)newHandStack, (ItemStack)swappedStack) && newHandStack.getCount() + swappedStack.getCount() <= newHandStack.getMaxStackSize()) {
                        newHandStack.grow(swappedStack.getCount());
                    } else {
                        player.addItem(swappedStack);
                    }
                }
                return InteractionResult.SUCCESS.heldItemTransformedTo(newHandStack);
            }
        }
        return InteractionResult.PASS;
    }

    public static void setupItems(AddDataComponentCallback callback) {
        AccessoryRegistry.getAllAccessories().forEach((item, accessory) -> {
            AccessoryItemAttributeModifiers.Builder builder = AccessoryItemAttributeModifiers.builder();
            accessory.getStaticModifiers((Item)item, builder);
            if (!builder.isEmpty()) {
                callback.addTo((Item)item, AccessoriesDataComponents.ATTRIBUTES, builder.build());
            }
        });
    }

    public static interface AddDataComponentCallback {
        public <T> void addTo(Item var1, DataComponentType<T> var2, T var3);
    }
}

