/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.event;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.equip.EquipAction;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.mixin.DefaultDispenseItemBehaviorAccessor;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public final class AccessoryEquipmentDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    public static final EquipmentDispenseItemBehavior INSTANCE = new EquipmentDispenseItemBehavior();
    private final DispenseItemBehavior wrappedBehavior;

    public AccessoryEquipmentDispenseItemBehavior(DispenseItemBehavior wrappedBehavior) {
        this.wrappedBehavior = wrappedBehavior;
    }

    public ItemStack execute(BlockSource blockSource, ItemStack item) {
        if (AccessoryEquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item)) {
            return item;
        }
        DispenseItemBehavior dispenseItemBehavior = this.wrappedBehavior;
        if (dispenseItemBehavior instanceof DefaultDispenseItemBehavior) {
            DefaultDispenseItemBehavior defaultBehavior = (DefaultDispenseItemBehavior)dispenseItemBehavior;
            return ((DefaultDispenseItemBehaviorAccessor)defaultBehavior).accessories$execute(blockSource, item);
        }
        return this.wrappedBehavior.dispense(blockSource, item);
    }

    public static boolean dispenseEquipment(BlockSource blockSource, ItemStack stack) {
        BlockPos blockPos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
        List list = blockSource.level().getEntitiesOfClass(LivingEntity.class, new AABB(blockPos), livingEntityx -> AccessoryEquipmentDispenseItemBehavior.canEquipWithDispenser(livingEntityx, stack));
        if (list.isEmpty()) {
            return false;
        }
        Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
        Pair<SlotReference, EquipAction> equipReference = AccessoriesCapability.get((LivingEntity)list.getFirst()).canEquipAccessory(stack, false);
        if (!stack.isEmpty()) {
            accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
            ((EquipAction)equipReference.second()).equipStack(stack);
        }
        return true;
    }

    public static boolean canEquipWithDispenser(LivingEntity entity, ItemStack stack) {
        EntityType type;
        AccessoriesCapability targetCapability = AccessoriesCapability.get(entity);
        if (targetCapability != null && ((type = entity.getType()).is(AccessoriesTags.MODIFIABLE_ENTITY_WHITELIST) || !type.is(AccessoriesTags.MODIFIABLE_ENTITY_BLACKLIST))) {
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(stack);
            Pair<SlotReference, EquipAction> equipReference = targetCapability.canEquipAccessory(stack, false);
            return equipReference != null && accessory.canEquipFromDispenser(stack, (SlotReference)equipReference.left());
        }
        return false;
    }
}

