/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl.option;

import com.google.common.collect.Streams;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.impl.option.PlayerOption;
import io.wispforest.accessories.impl.option.PlayerOptionsAccess;
import io.wispforest.accessories.utils.InstanceEndec;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.format.edm.EdmElement;
import io.wispforest.endec.format.edm.EdmEndec;
import io.wispforest.endec.format.edm.EdmMap;
import io.wispforest.endec.util.MapCarrierDecodable;
import io.wispforest.endec.util.MapCarrierEncodable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AccessoriesPlayerOptionsHolder
implements InstanceEndec,
PlayerOptionsAccess {
    public static final Endec<@Nullable AccessoriesPlayerOptionsHolder> ENDEC = Endec.of((ctx, serializer, holder) -> {
        if (holder != null && holder.isDefaultedValues()) {
            holder = null;
        }
        serializer.writeOptional(ctx, EdmEndec.MAP, Optional.ofNullable(holder).map(obj -> {
            EdmMap map = EdmElement.consumeMap(new LinkedHashMap()).asMap();
            obj.encode((MapCarrierEncodable)map, ctx);
            return map;
        }));
    }, (ctx, deserializer) -> deserializer.readOptional(ctx, EdmEndec.MAP).map(edmMap -> {
        AccessoriesPlayerOptionsHolder holder = new AccessoriesPlayerOptionsHolder();
        holder.decode((MapCarrierDecodable)edmMap, ctx);
        return holder;
    }).orElse(null));
    private Map<PlayerOption<?>, Object> optionToValue = new LinkedHashMap();

    public static AccessoriesPlayerOptionsHolder getOptions(Player player) {
        return AccessoriesInternals.INSTANCE.getPlayerOptions(player);
    }

    @Override
    public boolean hasData(PlayerOption<?> option) {
        return this.optionToValue.containsKey(option);
    }

    @Override
    public <T> Optional<T> getData(PlayerOption<T> option) {
        return this.optionToValue.containsKey(option) ? Optional.of(this.optionToValue.get(option)) : Optional.empty();
    }

    @Override
    public <T> void setData(PlayerOption<T> option, T data) {
        Objects.requireNonNull(option, "Unable to set data as the given PlayerOption instance is null!");
        this.optionToValue.put(option, data);
    }

    @Override
    public void encode(MapCarrierEncodable carrier, SerializationContext ctx) {
        this.optionToValue.forEach((playerOption, object) -> playerOption.writeToCarrierCasted(carrier, object));
    }

    @Override
    public void decode(MapCarrierDecodable carrier, SerializationContext ctx) {
        this.optionToValue.clear();
        for (PlayerOption playerOption : PlayerOption.getAllOptions()) {
            if (!carrier.has(playerOption.keyEndec())) continue;
            this.optionToValue.put(playerOption, carrier.get(playerOption.keyEndec()));
        }
    }

    public boolean isDefaultedValues() {
        return this.optionToValue.keySet().stream().allMatch(option -> Objects.equals(this.getDefaultedData(option), option.defaultValue()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AccessoriesPlayerOptionsHolder)) {
            return false;
        }
        AccessoriesPlayerOptionsHolder otherHolder = (AccessoriesPlayerOptionsHolder)obj;
        Set allOptions = Streams.concat((Stream[])new Stream[]{this.optionToValue.keySet().stream(), otherHolder.optionToValue.keySet().stream()}).collect(Collectors.toSet());
        for (PlayerOption playerOption : allOptions) {
            if (Objects.equals(otherHolder.getDefaultedData(playerOption), this.getDefaultedData(playerOption))) continue;
            return false;
        }
        return true;
    }

    public static AccessoriesPlayerOptionsHolder createOrCopy(@Nullable AccessoriesPlayerOptionsHolder holder) {
        if (holder == null) {
            return new AccessoriesPlayerOptionsHolder();
        }
        return holder.copy();
    }

    public AccessoriesPlayerOptionsHolder copy() {
        AccessoriesPlayerOptionsHolder holder = new AccessoriesPlayerOptionsHolder();
        holder.optionToValue.putAll(this.optionToValue);
        return holder;
    }
}

