/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.compat.config.ScreenType;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum AccessoriesMenuVariant {
    PRIMARY_V2(() -> AccessoriesMenuTypes.PRIAMRY_MENU);

    public final Supplier<MenuType<? extends AccessoriesMenuBase>> supplier;

    private AccessoriesMenuVariant(Supplier<MenuType<? extends AccessoriesMenuBase>> supplier) {
        this.supplier = supplier;
    }

    @Nullable
    public static AccessoriesMenuVariant getVariant(ScreenType screenType) {
        return switch (screenType) {
            case ScreenType.PRIMARY_V2 -> PRIMARY_V2;
            default -> null;
        };
    }

    public static AccessoriesMenuVariant getVariant(MenuType<? extends AccessoriesMenuBase> menuType) {
        for (AccessoriesMenuVariant value : AccessoriesMenuVariant.values()) {
            if (!value.supplier.get().equals(menuType)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown MenuType passed to get Accessories Menu Variant! [Type: " + String.valueOf(BuiltInRegistries.MENU.getKey(menuType)) + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractContainerMenu openMenu(int i, Inventory inv, AccessoriesMenuVariant variant, @Nullable LivingEntity target, @Nullable ItemStack carriedStack) {
        switch (variant.ordinal()) {
            case 0: {
                return new AccessoriesMenu(i, inv, target, carriedStack);
            }
            default: {
                throw new IllegalArgumentException("Unknown AccessoriesMenuVariant passed to construct Menu! [Variant: " + variant.name() + "]");
            }
        }
    }
}

