/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.pond.DroppedStacksExtension;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public abstract class InventoryMixin {
    @Shadow
    @Final
    public Player player;

    @Inject(method={"clearOrCountMatchingItems(Ljava/util/function/Predicate;ILnet/minecraft/world/Container;)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", shift=At.Shift.AFTER)})
    private void clearAccessories(Predicate<ItemStack> stackPredicate, int maxCount, Container inventory, CallbackInfoReturnable<Integer> cir, @Local(ordinal=1) LocalIntRef i) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)this.player);
        if (capability == null) {
            return;
        }
        capability.getContainers().forEach((s, container) -> {
            ExpandedContainer accessories = container.getAccessories();
            i.set(i.get() + ContainerHelper.clearOrCountMatchingItems((Container)accessories, (Predicate)stackPredicate, (int)(maxCount - i.get()), (maxCount - i.get() == 0 ? 1 : 0) != 0));
            ExpandedContainer cosmetics = container.getCosmeticAccessories();
            i.set(i.get() + ContainerHelper.clearOrCountMatchingItems((Container)cosmetics, (Predicate)stackPredicate, (int)(maxCount - i.get()), (maxCount - i.get() == 0 ? 1 : 0) != 0));
        });
    }

    @ModifyReturnValue(method={"contains(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="TAIL")})
    private boolean extendContainsCheck(boolean original, @Local(argsOnly=true) ItemStack stack) {
        return original || this.checkAccessoriesContainers(stack1 -> stack1.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack));
    }

    @ModifyReturnValue(method={"contains(Lnet/minecraft/tags/TagKey;)Z"}, at={@At(value="TAIL")})
    private boolean extendContainsCheck(boolean original, @Local(argsOnly=true) TagKey<Item> tag) {
        return original || this.checkAccessoriesContainers(stack -> !stack.isEmpty() && stack.is(tag));
    }

    @ModifyReturnValue(method={"contains(Ljava/util/function/Predicate;)Z"}, at={@At(value="TAIL")})
    private boolean extendContainsCheck(boolean original, Predicate<ItemStack> predicate) {
        return original || this.checkAccessoriesContainers(predicate);
    }

    @Unique
    private boolean checkAccessoriesContainers(Predicate<ItemStack> predicate) {
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)this.player);
        if (capability == null) {
            return false;
        }
        return capability.isEquipped(predicate);
    }

    @Inject(method={"dropAll()V"}, at={@At(value="TAIL")})
    private void addAccessoriesToDropCall(CallbackInfo ci) {
        for (ItemStack itemstack : ((DroppedStacksExtension)this.player).toBeDroppedStacks()) {
            this.player.drop(itemstack, true, false);
        }
        ((DroppedStacksExtension)this.player).addToBeDroppedStacks(List.of());
    }
}

