/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.wispforest.accessories.pond.stack.ItemStackExtension;
import io.wispforest.accessories.utils.ConcurrentBarrier;
import io.wispforest.accessories.utils.EnhancedEventStream;
import io.wispforest.accessories.utils.ItemStackResize;
import io.wispforest.owo.util.EventStream;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements ItemStackExtension {
    @Shadow
    private int count;
    @Unique
    @Nullable
    private EventStream<ItemStackResize> resizeEvent = null;

    @Override
    public EventStream<ItemStackResize> accessories$getResizeEvent() {
        if (this.resizeEvent == null) {
            this.resizeEvent = EnhancedEventStream.of((invokers, barrier) -> (stack, types) -> {
                try (ConcurrentBarrier concurrentBarrier = barrier;){
                    invokers.forEach(invoker -> invoker.onResize(stack, types));
                }
            }, () -> {
                this.resizeEvent = null;
            });
        }
        return this.resizeEvent;
    }

    @WrapMethod(method={"setCount(I)V"})
    private void accessories$handleResizeEvent(int count, Operation<Void> original) {
        int prevSize = 0;
        if (this.resizeEvent != null) {
            prevSize = this.count;
        }
        original.call(new Object[]{count});
        if (this.resizeEvent != null) {
            ((ItemStackResize)this.accessories$getResizeEvent().sink()).onResize((ItemStack)this, prevSize);
        }
    }
}

