/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import io.wispforest.accessories.api.events.extra.OnTotemActivate;
import io.wispforest.accessories.api.events.extra.OnTotemConsumption;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPathWithStack;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements AccessoriesAPIAccess,
AccessoriesLivingEntityExtension {
    @Unique
    private AccessoriesCapabilityImpl accessories$capability = null;
    @Unique
    private final Map<ItemStack, SlotReference> accessories$enchantmentLocationContext = new Reference2ObjectOpenHashMap();
    @Unique
    private final Map<String, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> accessories$activeLocationDependentEnchantments = new HashMap<String, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>>();

    @Shadow
    public abstract void swing(InteractionHand var1, boolean var2);

    protected LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public AccessoriesCapability getOrCreateAccessoriesCapability() {
        if (this.accessories$capability == null) {
            this.accessories$capability = new AccessoriesCapabilityImpl((LivingEntity)this);
        }
        return this.accessories$capability;
    }

    @Override
    @Nullable
    public AccessoriesCapability accessoriesCapability() {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots((LivingEntity)this);
        if (slots.isEmpty()) {
            return null;
        }
        AccessoriesCapability capability = this.getOrCreateAccessoriesCapability();
        AccessoriesHolderImpl.getHolder(capability);
        return capability;
    }

    @Override
    public void pushEnchantmentContext(ItemStack stack, SlotReference reference) {
        this.accessories$enchantmentLocationContext.put(stack, reference);
    }

    @Override
    @Nullable
    public SlotReference popEnchantmentContext(ItemStack stack) {
        return this.accessories$enchantmentLocationContext.remove(stack);
    }

    @Override
    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantmentsFromSlotReference(SlotReference slotReference) {
        return (Map)this.accessories$activeLocationDependentEnchantments.computeIfAbsent(slotReference.createString(), equipmentSlot -> new Reference2ObjectArrayMap());
    }

    @Inject(method={"onEquippedItemBroken(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/entity/EquipmentSlot;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendAccessoriesBreakInstead(Item item, EquipmentSlot slot, CallbackInfo ci) {
        if (slot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) {
            ci.cancel();
        }
    }

    @Inject(method={"entityEventForEquipmentBreak(Lnet/minecraft/world/entity/EquipmentSlot;)B"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventMatchExceptionForAccessories(EquipmentSlot slot, CallbackInfoReturnable<Byte> cir) {
        if (slot.equals((Object)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) {
            cir.setReturnValue((Object)-1);
        }
    }

    @Override
    public void onEquipItem(SlotReference slotReference, ItemStack oldItem, ItemStack newItem) {
        Level level = this.level();
        if (!(ItemStack.isSameItemSameComponents((ItemStack)oldItem, (ItemStack)newItem) || this.firstTick || level.isClientSide() || this.isSpectator())) {
            SoundEventData sound;
            boolean isEquitableFor;
            boolean bl = isEquitableFor = newItem.isEmpty() || SlotPredicateRegistry.canInsertIntoSlot(newItem, slotReference);
            if (!this.isSilent() && !newItem.isEmpty() && (sound = AccessoryRegistry.getAccessoryOrDefault(newItem).getEquipSound(newItem, slotReference)) != null) {
                level.playSeededSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)sound.event().value(), this.getSoundSource(), sound.volume(), sound.pitch(), this.random.nextLong());
            }
            if (isEquitableFor) {
                this.gameEvent((Holder)(!newItem.isEmpty() ? GameEvent.EQUIP : GameEvent.UNEQUIP));
            }
        }
    }

    @Inject(method={"isLookingAtMe(Lnet/minecraft/world/entity/LivingEntity;DZZ[D)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void accessories$isGazeDisguised(LivingEntity livingEntity, double tolerance, boolean scaleByDistance, boolean visual, double[] yValues, CallbackInfoReturnable<Boolean> cir) {
        TriState state = ExtraEventHandler.isGazedBlocked((LivingEntity)this, livingEntity);
        if (state != TriState.DEFAULT) {
            cir.setReturnValue((Object)(!state.get() ? 1 : 0));
        }
    }

    @ModifyReturnValue(method={"canFreeze()Z"}, at={@At(value="RETURN", ordinal=1)})
    private boolean canFreezeAccessoriesCheck(boolean bl) {
        TriState state = ExtraEventHandler.canFreezeEntity((LivingEntity)this);
        return state.orElse(bl);
    }

    @Inject(method={"checkTotemDeathProtection(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="JUMP", opcode=198, ordinal=1, shift=At.Shift.BEFORE)})
    private void accessories$checkForTotems(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir, @Local(ordinal=0) LocalRef<ItemStack> itemStack, @Local(ordinal=0) LocalRef<DeathProtection> deathProtection, @Share(value="currentSlotReference") LocalRef<@Nullable SlotReference> currentSlotReference) {
        SlotPathWithStack totem;
        AccessoriesCapability capability = this.accessoriesCapability();
        SlotReference slotReference = null;
        if (capability != null && deathProtection.get() == null && (totem = capability.getFirstEquipped((Predicate)ItemStackBasedPredicate.ofComponents("totem_check", DataComponents.DEATH_PROTECTION))) != null) {
            OnTotemConsumption onTotemConsumption;
            slotReference = ((SlotEntryReference)totem).reference();
            ItemStack totemStack = ((SlotEntryReference)totem).stack();
            itemStack.set((Object)totemStack.copy());
            deathProtection.set((Object)((DeathProtection)totemStack.get(DataComponents.DEATH_PROTECTION)));
            Accessory accessory = AccessoryRegistry.getAccessoryOrDefault(totemStack);
            OnTotemConsumption consumptionAction = accessory instanceof OnTotemConsumption ? (onTotemConsumption = (OnTotemConsumption)((Object)accessory)) : OnTotemConsumption.DEFAULT_BEHAVIOR;
            totemStack = consumptionAction.onConsumption(slotReference, totemStack, damageSource);
            slotReference.setStack(totemStack);
        }
        currentSlotReference.set(slotReference);
    }

    @WrapOperation(method={"checkTotemDeathProtection(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/DeathProtection;applyEffects(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void accessories$adjustTotemEffects(DeathProtection instance, ItemStack itemStack, LivingEntity livingEntity, Operation<Void> original, @Local(argsOnly=true) DamageSource damageSource, @Share(value="currentSlotReference") LocalRef<@Nullable SlotReference> currentSlotReference) {
        OnTotemActivate onTotemActivate;
        Accessory accessory;
        OnTotemActivate activationAction;
        SlotReference slotReference = (SlotReference)currentSlotReference.get();
        if (slotReference != null && (instance = (activationAction = (accessory = AccessoryRegistry.getAccessoryOrDefault(itemStack)) instanceof OnTotemActivate ? (onTotemActivate = (OnTotemActivate)((Object)accessory)) : OnTotemActivate.DEFAULT_BEHAVIOR).onActivation(instance, slotReference, itemStack, damageSource)) == null) {
            return;
        }
        original.call(new Object[]{instance, itemStack, livingEntity});
    }

    @WrapOperation(method={"updateFallFlying()V"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;toList()Ljava/util/List;")})
    private List<EquipmentSlot> accessories$addEquipmentCheck(Stream<EquipmentSlot> instance, Operation<List<EquipmentSlot>> original, @Share(value="slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        SlotEntryReference glider;
        List<SlotEntryReference> gliders;
        AccessoriesCapability capability = this.accessoriesCapability();
        slotReference.set(null);
        if (capability != null && !(gliders = capability.getEquipped(ItemStackBasedPredicate.ofComponents(DataComponents.GLIDER))).isEmpty() && LivingEntity.canGlideUsing((ItemStack)(glider = (SlotEntryReference)Util.getRandom(gliders, (RandomSource)this.random)).stack(), (EquipmentSlot)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) {
            slotReference.set((Object)glider.reference());
            instance = Stream.concat(instance, Stream.of(AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()));
        }
        return (List)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"updateFallFlying()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack accessories$adjustGottenStack(LivingEntity instance, EquipmentSlot equipmentSlot, Operation<ItemStack> original, @Share(value="slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        if (equipmentSlot != AccessoriesInternals.INSTANCE.getInternalEquipmentSlot()) {
            return (ItemStack)original.call(new Object[]{instance, equipmentSlot});
        }
        ItemStack stack = ((SlotReference)slotReference.get()).getStack();
        return stack != null ? stack : ItemStack.EMPTY;
    }

    @WrapOperation(method={"updateFallFlying()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;)V")})
    private void accessories$adjustHurtAndBreak(ItemStack instance, int amount, LivingEntity entity, EquipmentSlot slot, Operation<Void> original, @Share(value="slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        SlotReference ref = (SlotReference)slotReference.get();
        if (ref == null) {
            original.call(new Object[]{instance, amount, entity, slot});
        } else {
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerPlayer serverPlayer;
                ServerLevel serverLevel = (ServerLevel)level;
                instance.hurtAndBreak(amount, serverLevel, entity instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)entity) : null, item -> ref.breakStack());
            }
        }
    }

    @Inject(method={"canGlide()Z"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/EquipmentSlot;VALUES:Ljava/util/List;")}, cancellable=true)
    private void accessories$checkAccessoriesGliders(CallbackInfoReturnable<Boolean> cir) {
        AccessoriesCapability capability = this.accessoriesCapability();
        if (capability == null) {
            return;
        }
        List<SlotEntryReference> gliders = capability.getEquipped(ItemStackBasedPredicate.ofComponents(DataComponents.GLIDER));
        if (gliders.isEmpty()) {
            return;
        }
        for (SlotEntryReference glider : gliders) {
            if (!LivingEntity.canGlideUsing((ItemStack)glider.stack(), (EquipmentSlot)AccessoriesInternals.INSTANCE.getInternalEquipmentSlot())) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @WrapOperation(method={"canGlideUsing(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/equipment/Equippable;slot()Lnet/minecraft/world/entity/EquipmentSlot;")})
    private static EquipmentSlot accessories$changeEquipmentSlot(Equippable instance, Operation<EquipmentSlot> original, @Local(argsOnly=true) EquipmentSlot equipmentSlot) {
        return equipmentSlot == AccessoriesInternals.INSTANCE.getInternalEquipmentSlot() ? AccessoriesInternals.INSTANCE.getInternalEquipmentSlot() : (EquipmentSlot)original.call(new Object[]{instance});
    }
}

