/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.neoforge;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.data.api.IdentifiedResourceReloadListener;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.accessories.neoforge.AccessoriesForge;
import io.wispforest.accessories.neoforge.mixin.ContextAwareReloadListenerAccessor;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.event.GatherSkippedAttributeTooltipsEvent;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class AccessoriesNeoforgeInternals
extends AccessoriesInternals {
    public static final Map<PackType, Set<IdentifiedResourceReloadListener>> TO_BE_LOADED = new HashMap<PackType, Set<IdentifiedResourceReloadListener>>();

    @Override
    public AccessoriesHolderImpl getHolder(LivingEntity livingEntity) {
        return (AccessoriesHolderImpl)livingEntity.getData(AccessoriesForge.HOLDER_ATTACHMENT_TYPE);
    }

    @Override
    public void modifyHolder(LivingEntity livingEntity, UnaryOperator<AccessoriesHolderImpl> modifier) {
        AccessoriesHolderImpl holder = this.getHolder(livingEntity);
        holder = (AccessoriesHolderImpl)modifier.apply(holder);
        livingEntity.setData(AccessoriesForge.HOLDER_ATTACHMENT_TYPE, (Object)holder);
    }

    @Override
    public AccessoriesPlayerOptionsHolder getPlayerOptions(Player player) {
        return (AccessoriesPlayerOptionsHolder)player.getData(AccessoriesForge.PLAYER_OPTIONS_ATTACHMENT_TYPE);
    }

    @Override
    public void modifyPlayerOptions(Player player, UnaryOperator<AccessoriesPlayerOptionsHolder> modifier) {
        AccessoriesPlayerOptionsHolder options = this.getPlayerOptions(player);
        options = (AccessoriesPlayerOptionsHolder)modifier.apply(options);
        player.setData(AccessoriesForge.PLAYER_OPTIONS_ATTACHMENT_TYPE, (Object)options);
    }

    @Override
    public void giveItemToPlayer(ServerPlayer player, ItemStack stack) {
        player.getInventory().placeItemBackInInventory(stack);
    }

    @Override
    public boolean isValidOnConditions(JsonObject object, String dataType, ResourceLocation key, SimplePreparableReloadListener listener, @Nullable RegistryOps.RegistryInfoLookup registryInfo) {
        return ICondition.conditionsMatched(((ContextAwareReloadListenerAccessor)listener).accessories$makeConditionalOps(), (Object)object);
    }

    @Override
    public <T extends AbstractContainerMenu, D> MenuType<T> registerMenuType(ResourceLocation location, Endec<D> endec, TriFunction<Integer, Inventory, D, T> func) {
        return (MenuType)Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)location, (Object)IMenuTypeExtension.create((i, arg, arg2) -> (AbstractContainerMenu)func.apply((Object)i, (Object)arg, endec.decodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)arg2.registryAccess())}), ByteBufDeserializer::of, (Object)arg2))));
    }

    @Override
    public void openAccessoriesMenu(Player player, final AccessoriesMenuVariant variant, final @Nullable LivingEntity targetEntity, final @Nullable ItemStack carriedStack) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.empty();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player arg2) {
                return AccessoriesMenuVariant.openMenu(i, inventory, variant, targetEntity, carriedStack);
            }

            public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buf) {
                AccessoriesMenuData.ENDEC.encode(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)buf.registryAccess())}), (Serializer)ByteBufSerializer.of((ByteBuf)buf), (Object)AccessoriesMenuData.of(targetEntity, (AccessoriesMenuBase)menu));
            }
        });
    }

    @Override
    public void addAttributeTooltips(@Nullable Player player, ItemStack stack, Multimap<Holder<Attribute>, AttributeModifier> multimap, Consumer<Component> tooltipAddCallback, TooltipDisplay display, Item.TooltipContext context, TooltipFlag flag) {
        AttributeTooltipContext neoTooltipCtx = AttributeTooltipContext.of((Player)player, (Item.TooltipContext)context, (TooltipDisplay)display, (TooltipFlag)flag);
        GatherSkippedAttributeTooltipsEvent event = (GatherSkippedAttributeTooltipsEvent)NeoForge.EVENT_BUS.post((Event)new GatherSkippedAttributeTooltipsEvent(stack, neoTooltipCtx));
        if (event.isSkippingAll()) {
            return;
        }
        HashMultimap modifiers = HashMultimap.create(multimap);
        modifiers.values().removeIf(m -> event.isSkipped(m.id()));
        if (modifiers.isEmpty()) {
            return;
        }
        AttributeUtil.applyTextFor((ItemStack)stack, tooltipAddCallback, (Multimap)modifiers, (AttributeTooltipContext)neoTooltipCtx);
    }

    @Override
    public void registerLoader(PackType type, IdentifiedResourceReloadListener loader) {
        TO_BE_LOADED.computeIfAbsent(type, type1 -> new LinkedHashSet()).add(loader);
    }

    @Override
    public <T> String getTagTranslation(TagKey<T> tagKey) {
        return Tags.getTagTranslationKey(tagKey);
    }
}

