/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.neoforge.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.AccessoriesPipelines;
import io.wispforest.accessories.client.AccessoriesRenderLayer;
import io.wispforest.accessories.data.api.SyncedDataHelperManager;
import io.wispforest.accessories.impl.event.AccessoriesEventHandler;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.neoforge.AccessoriesNeoforgeInternals;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TooltipDisplay;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@Mod(value="accessories", dist={Dist.CLIENT})
public class AccessoriesClientForge {
    public AccessoriesClientForge(IEventBus eventBus) {
        eventBus.addListener(this::registerMenuType);
        eventBus.addListener(this::onInitializeClient);
        eventBus.addListener(this::initKeybindings);
        eventBus.addListener(this::addRenderLayer);
        eventBus.addListener(this::registerReloadListeners);
        NeoForge.EVENT_BUS.addListener(this::onJoin);
        eventBus.addListener(event -> AccessoriesPipelines.registerPipelines(arg_0 -> ((RegisterRenderPipelinesEvent)event).registerPipeline(arg_0)));
        AccessoriesClient.initConfigStuff();
    }

    public void registerReloadListeners(AddClientReloadListenersEvent event) {
        Set loaders = AccessoriesNeoforgeInternals.TO_BE_LOADED.getOrDefault(PackType.CLIENT_RESOURCES, new LinkedHashSet());
        loaders.forEach(endecDataLoader -> event.addListener(endecDataLoader.getId(), (PreparableReloadListener)endecDataLoader));
        loaders.forEach(endecDataLoader -> {
            for (ResourceLocation dependencyId : endecDataLoader.getDependencyIds()) {
                event.addDependency(dependencyId, endecDataLoader.getId());
            }
        });
    }

    public void registerMenuType(RegisterMenuScreensEvent event) {
        AccessoriesMenuTypes.registerClientMenuConstructors((arg_0, arg_1) -> ((RegisterMenuScreensEvent)event).register(arg_0, arg_1));
    }

    public void onJoin(ClientPlayerNetworkEvent.LoggingIn loggingInEvent) {
        AccessoriesClient.initalConfigDataSync();
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(AccessoriesClientForge::clientTick);
        NeoForge.EVENT_BUS.addListener(AccessoriesClientForge::itemTooltipCallback);
        AccessoriesClient.init();
        AccessoriesNetworking.initClient();
        SyncedDataHelperManager.initClient(AccessoriesNetworking.CHANNEL);
    }

    public void initKeybindings(RegisterKeyMappingsEvent event) {
        event.register(AccessoriesClient.OPEN_SCREEN);
    }

    public static void clientTick(ClientTickEvent.Pre event) {
        if (AccessoriesClient.OPEN_SCREEN.consumeClick()) {
            Minecraft client = Minecraft.getInstance();
            LocalPlayer player = client.player;
            if (Accessories.config().screenOptions.prioritizeCreativeScreen() && player != null && player.isCreative()) {
                if (client.gameMode.isServerControlledInventory()) {
                    player.sendOpenInventory();
                } else {
                    client.getTutorial().onOpenInventory();
                    client.setScreen((Screen)new InventoryScreen((Player)player));
                }
                return;
            }
            AccessoriesClient.openScreenFromKey();
        }
    }

    public static void itemTooltipCallback(ItemTooltipEvent event) {
        Player player = event.getEntity();
        List stackTooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        TooltipDisplay tooltipDisplay = (TooltipDisplay)stack.getOrDefault(DataComponents.TOOLTIP_DISPLAY, (Object)TooltipDisplay.DEFAULT);
        ArrayList<Component> tooltipData = new ArrayList<Component>();
        AccessoriesEventHandler.getTooltipData((LivingEntity)player, stack, tooltipData, tooltipDisplay, event.getContext(), event.getFlags());
        if (!tooltipData.isEmpty()) {
            stackTooltip.addAll(1, tooltipData);
        }
    }

    public void addRenderLayer(EntityRenderersEvent.AddLayers event) {
        for (EntityType entityType : event.getEntityTypes()) {
            try {
                LivingEntityRenderer livingEntityRenderer;
                EntityRenderer renderer2 = event.getRenderer(entityType);
                if (!(renderer2 instanceof LivingEntityRenderer) || !((livingEntityRenderer = (LivingEntityRenderer)renderer2).getModel() instanceof HumanoidModel)) continue;
                livingEntityRenderer.addLayer(new AccessoriesRenderLayer(livingEntityRenderer));
            }
            catch (ClassCastException classCastException) {}
        }
        event.getSkins().stream().flatMap(type -> Stream.of(event.getPlayerRenderer(type), event.getMannequinRenderer(type))).filter(Objects::nonNull).forEach(renderer -> renderer.addLayer(new AccessoriesRenderLayer(renderer)));
    }
}

