/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.mixin.EntityTrackerAccessor;
import io.wispforest.accessories.mixin.ServerChunkLoadingManagerAccessor;
import io.wispforest.accessories.networking.client.AccessoryBreak;
import io.wispforest.accessories.networking.client.InvalidateEntityCache;
import io.wispforest.accessories.networking.client.ScreenVariantPing;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.networking.client.SyncPlayerOptions;
import io.wispforest.accessories.networking.client.SyncServerOverrideOption;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ContainerClose;
import io.wispforest.accessories.networking.server.NukeAccessories;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.accessories.networking.server.SyncCosmeticToggle;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.ServerAccess;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkSource;

public class AccessoriesNetworking {
    public static final OwoNetChannel CHANNEL = OwoNetChannel.create((ResourceLocation)Accessories.of("main"));

    public static void init() {
        CHANNEL.registerServerbound(ScreenOpen.class, ScreenOpen.ENDEC, AccessoriesNetworking.serverHandler(ScreenOpen::handlePacket));
        CHANNEL.registerServerbound(NukeAccessories.class, NukeAccessories.ENDEC, AccessoriesNetworking.serverHandler(NukeAccessories::handlePacket));
        CHANNEL.registerServerbound(SyncCosmeticToggle.class, SyncCosmeticToggle.ENDEC, AccessoriesNetworking.serverHandler(SyncCosmeticToggle::handlePacket));
        CHANNEL.registerServerbound(SyncOptionChange.class, SyncOptionChange.ENDEC, AccessoriesNetworking.serverHandler(SyncOptionChange::handlePacket));
        CHANNEL.registerServerbound(ContainerClose.class, ContainerClose.ENDEC, AccessoriesNetworking.serverHandler(ContainerClose::handlePacket));
        CHANNEL.registerClientboundDeferred(SyncEntireContainer.class, SyncEntireContainer.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncContainerData.class, SyncContainerData.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncPlayerOptions.class, SyncPlayerOptions.ENDEC);
        CHANNEL.registerClientboundDeferred(AccessoryBreak.class, AccessoryBreak.ENDEC);
        CHANNEL.registerClientboundDeferred(InvalidateEntityCache.class, InvalidateEntityCache.ENDEC);
        CHANNEL.registerClientboundDeferred(ScreenVariantPing.class, ScreenVariantPing.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncOptionChange.class, SyncOptionChange.ENDEC);
        CHANNEL.registerClientboundDeferred(SyncServerOverrideOption.class, SyncServerOverrideOption.ENDEC);
    }

    public static void initClient() {
        CHANNEL.registerClientbound(SyncEntireContainer.class, SyncEntireContainer.ENDEC, AccessoriesNetworking.clientHandler(SyncEntireContainer::handlePacket));
        CHANNEL.registerClientbound(SyncContainerData.class, SyncContainerData.ENDEC, AccessoriesNetworking.clientHandler(SyncContainerData::handlePacket));
        CHANNEL.registerClientbound(SyncPlayerOptions.class, SyncPlayerOptions.ENDEC, AccessoriesNetworking.clientHandler(SyncPlayerOptions::handlePacket));
        CHANNEL.registerClientbound(AccessoryBreak.class, AccessoryBreak.ENDEC, AccessoriesNetworking.clientHandler(AccessoryBreak::handlePacket));
        CHANNEL.registerClientbound(InvalidateEntityCache.class, InvalidateEntityCache.ENDEC, AccessoriesNetworking.clientHandler(InvalidateEntityCache::handlePacket));
        CHANNEL.registerClientbound(ScreenVariantPing.class, ScreenVariantPing.ENDEC, AccessoriesNetworking.clientHandler(ScreenVariantPing::handlePacket));
        CHANNEL.registerClientbound(SyncOptionChange.class, SyncOptionChange.ENDEC, AccessoriesNetworking.clientHandler(SyncOptionChange::handlePacket));
        CHANNEL.registerClientbound(SyncServerOverrideOption.class, SyncServerOverrideOption.ENDEC, AccessoriesNetworking.clientHandler(SyncServerOverrideOption::handlePacket));
    }

    public static <R extends Record> OwoNetChannel.ChannelHandler<R, ClientAccess> clientHandler(BiConsumer<R, Player> consumer) {
        return (r, access) -> consumer.accept((Object)r, (Player)access.player());
    }

    public static <R extends Record> OwoNetChannel.ChannelHandler<R, ServerAccess> serverHandler(BiConsumer<R, Player> consumer) {
        return (r, access) -> consumer.accept((Object)r, (Player)access.player());
    }

    public static <R extends Record> void sendToServer(R packet) {
        CHANNEL.clientHandle().send(packet);
    }

    public static <R extends Record> void sendToPlayer(ServerPlayer player, R packet) {
        CHANNEL.serverHandle((Player)player).send(packet);
    }

    public static <R extends Record> void sendToAllPlayers(MinecraftServer server, R packet) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            AccessoriesNetworking.sendToPlayer(player, packet);
        }
    }

    public static <R extends Record> void sendToTrackingAndSelf(Entity entity, R packet) {
        ArrayList<ServerPlayer> targets = new ArrayList<ServerPlayer>();
        ChunkSource chunkSource = entity.level().getChunkSource();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            ChunkMap chunkLoadingManager = chunkCache.chunkMap;
            EntityTrackerAccessor tracker = (EntityTrackerAccessor)((ServerChunkLoadingManagerAccessor)chunkLoadingManager).accessories$getEntityMap().get(entity.getId());
            if (tracker != null) {
                targets.addAll(tracker.accessories$getSeenBy().stream().map(ServerPlayerConnection::getPlayer).collect(Collectors.toUnmodifiableSet()));
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            targets.add(serverPlayer);
        }
        CHANNEL.serverHandle(targets).send(packet);
    }
}

