/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.server;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record SyncCosmeticToggle(@Nullable Integer entityId, String slotName, int slotIndex) {
    public static final StructEndec<SyncCosmeticToggle> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.nullableOf().fieldOf("entityId", SyncCosmeticToggle::entityId), (StructField)Endec.STRING.fieldOf("slotName", SyncCosmeticToggle::slotName), (StructField)Endec.VAR_INT.fieldOf("slotIndex", SyncCosmeticToggle::slotIndex), SyncCosmeticToggle::new);

    public static SyncCosmeticToggle of(@Nullable LivingEntity livingEntity, SlotType slotType, int slotIndex) {
        return new SyncCosmeticToggle(livingEntity != null ? Integer.valueOf(livingEntity.getId()) : null, slotType.name(), slotIndex);
    }

    public static void handlePacket(SyncCosmeticToggle packet, Player player) {
        AccessoriesCapability capability;
        if (player.level().isClientSide()) {
            return;
        }
        Player targetEntity = player;
        if (packet.entityId() != null) {
            Entity entity = player.level().getEntity(packet.entityId().intValue());
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            targetEntity = livingEntity;
            TriState result = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications((LivingEntity)targetEntity, player, null);
            if (!result.orElse(false)) {
                return;
            }
        }
        if ((capability = targetEntity.accessoriesCapability()) == null) {
            return;
        }
        SlotType slotType = SlotTypeLoader.getSlotType(player.level(), packet.slotName());
        if (slotType == null) {
            return;
        }
        AccessoriesContainer container = capability.getContainer(slotType);
        container.setShouldRender(packet.slotIndex(), !container.shouldRender(packet.slotIndex()));
        container.markChanged(false);
    }
}

