/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.pond;

import io.wispforest.accessories.menu.ArmorSlotTypes;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface CosmeticArmorLookupTogglable {
    public static <T> T runWithLookupToggle(Entity entity, Supplier<T> runnable) {
        boolean bl = entity instanceof CosmeticArmorLookupTogglable;
        if (bl) {
            ((CosmeticArmorLookupTogglable)entity).setLookupToggle(true);
        }
        T t = runnable.get();
        if (bl) {
            ((CosmeticArmorLookupTogglable)entity).setLookupToggle(false);
        }
        return t;
    }

    public static void runWithLookupToggle(Entity entity, Runnable runnable) {
        boolean bl = entity instanceof CosmeticArmorLookupTogglable;
        if (bl) {
            ((CosmeticArmorLookupTogglable)entity).setLookupToggle(true);
        }
        runnable.run();
        if (bl) {
            ((CosmeticArmorLookupTogglable)entity).setLookupToggle(false);
        }
    }

    default public void setLookupToggle(boolean value) {
        throw new IllegalStateException("Interface injected method not implemented!");
    }

    default public boolean getLookupToggle() {
        throw new IllegalStateException("Interface injected method not implemented!");
    }

    public static void getAlternativeStack(LivingEntity livingEntity, EquipmentSlot equipmentSlot, Consumer<ItemStack> consumer) {
        if (!((CosmeticArmorLookupTogglable)livingEntity).getLookupToggle()) {
            return;
        }
        ItemStack cosmetic = ArmorSlotTypes.getAlternativeStack(livingEntity, equipmentSlot);
        if (cosmetic == null) {
            return;
        }
        consumer.accept(cosmetic);
    }
}

