/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.pond;

import net.minecraft.Util;
import net.minecraft.world.item.TooltipFlag;

public interface TooltipFlagExtension {
    default public boolean hasControlDown() {
        return false;
    }

    default public boolean hasShiftDown() {
        return false;
    }

    default public boolean hasAltDown() {
        return false;
    }

    default public int getModifiers() {
        return 0;
    }

    default public TooltipFlag getInnerFlag() {
        return TooltipFlag.NORMAL;
    }

    public static TooltipFlag createFlag(final TooltipFlag flag, final int modifiers) {
        return new TooltipFlag(){
            static final boolean IS_OSX = Util.getPlatform() == Util.OS.OSX;
            static final int EDIT_SHORTCUT_KEY_MODIFIER = IS_OSX ? 8 : 2;

            public boolean isAdvanced() {
                return flag.isAdvanced();
            }

            public boolean isCreative() {
                return flag.isCreative();
            }

            public boolean hasAltDown() {
                return (this.getModifiers() & 4) != 0;
            }

            public boolean hasShiftDown() {
                return (this.getModifiers() & 1) != 0;
            }

            public boolean hasControlDown() {
                return (this.getModifiers() & EDIT_SHORTCUT_KEY_MODIFIER) != 0;
            }

            public int getModifiers() {
                return modifiers;
            }

            public TooltipFlag getInnerFlag() {
                return TooltipFlag.NORMAL;
            }
        };
    }
}

