/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class BaseContainer
implements Container,
StackedContentsCompatible {
    private final int size;
    private final NonNullList<ItemStack> items;
    @Nullable
    private EventStream<ContainerListener> onContainerChange = null;

    public BaseContainer(int size) {
        this.size = size;
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    public BaseContainer(ItemStack ... items) {
        this.size = items.length;
        this.items = NonNullList.of((Object)ItemStack.EMPTY, (Object[])items);
    }

    public EventSource.Subscription addListener(ContainerListener listener) {
        if (this.onContainerChange == null) {
            this.onContainerChange = new EventStream(invokers -> container -> invokers.forEach(listenerEntry -> listenerEntry.containerChanged(container)));
        }
        return this.onContainerChange.source().subscribe((Object)listener);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.EMPTY;
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        this.clearContent();
        return list;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemType(Item item, int amount) {
        ItemStack itemStack = new ItemStack((ItemLike)item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            ItemStack itemStack2 = this.getItem(i);
            if (!itemStack2.getItem().equals(item)) continue;
            int j = amount - itemStack.getCount();
            ItemStack itemStack3 = itemStack2.split(j);
            itemStack.grow(itemStack3.getCount());
            if (itemStack.getCount() == amount) break;
        }
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack addItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = stack.copy();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.isEmpty() ? ItemStack.EMPTY : itemStack;
    }

    public boolean canAddItem(ItemStack stack) {
        boolean bl = false;
        for (ItemStack itemStack : this.items) {
            if (!itemStack.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack) || itemStack.getCount() >= itemStack.getMaxStackSize())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(slot, (Object)ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setChanged() {
        if (this.onContainerChange != null) {
            ((ContainerListener)this.onContainerChange.sink()).containerChanged((Container)this);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        for (ItemStack itemStack : this.items) {
            stackedItemContents.accountStack(itemStack);
        }
    }

    public String toString() {
        return this.items.stream().filter(itemStack -> !itemStack.isEmpty()).toList().toString();
    }

    private void moveItemToEmptySlots(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemStack = this.getItem(i);
            if (!itemStack.isEmpty()) continue;
            this.setItem(i, stack.copyAndClear());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack stack) {
        for (int i = 0; i < this.size; ++i) {
            ItemStack itemStack = this.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.isEmpty()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack stack, ItemStack other) {
        int i = this.getMaxStackSize(other);
        int j = Math.min(stack.getCount(), i - other.getCount());
        if (j > 0) {
            other.grow(j);
            stack.shrink(j);
            this.setChanged();
        }
    }

    public final void saveAllItems(ValueOutput valueOutput) {
        ValueOutput.TypedOutputList typedOutputList = valueOutput.list("Items", ItemStackWithSlot.CODEC);
        this.saveItemsToList((ValueOutput.TypedOutputList<ItemStackWithSlot>)typedOutputList);
    }

    public final void loadAllItems(ValueInput valueInput) {
        this.loadItemsFromList((ValueInput.TypedInputList<ItemStackWithSlot>)valueInput.listOrEmpty("Items", ItemStackWithSlot.CODEC));
    }

    public void saveItemsToList(ValueOutput.TypedOutputList<ItemStackWithSlot> valueOutput) {
        this.saveItemsToList().forEach(arg_0 -> valueOutput.add(arg_0));
    }

    public void loadItemsFromList(ValueInput.TypedInputList<ItemStackWithSlot> valueInput) {
        this.loadItemsFromList(valueInput.stream().toList());
    }

    public List<ItemStackWithSlot> saveItemsToList() {
        ArrayList<ItemStackWithSlot> slottedStacks = new ArrayList<ItemStackWithSlot>();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.isEmpty()) continue;
            slottedStacks.add(new ItemStackWithSlot(i, itemStack));
        }
        return slottedStacks;
    }

    public void loadItemsFromList(Collection<ItemStackWithSlot> slottedStacks) {
        for (ItemStackWithSlot slottedStack : slottedStacks) {
            if (!slottedStack.isValidInContainer(this.size)) continue;
            this.items.set(slottedStack.slot(), (Object)slottedStack.stack());
        }
    }

    public static interface ErrorableGetter<T> {
        public T getEntry(Consumer<String> var1);
    }
}

