/*
 * Decompiled with CFR 0.152.
 */
package com.madgique.ae2patterncounter.parts;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.render.BlockEntityRenderHelper;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FluidPatternCounterPart
extends AbstractMonitorPart
implements IGridTickable {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("ae2patterncounter", "part/fluid_pattern_counter_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("ae2patterncounter", "part/fluid_pattern_counter_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    private int cachedPatternCount = 0;
    private boolean hasInitialSync = false;

    public FluidPatternCounterPart(IPartItem<?> partItem) {
        super(partItem, true);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected void updateReportingValue(IGrid grid) {
        this.updatePatternCount(grid);
    }

    private void updatePatternCount(IGrid grid) {
        if (this.getLevel() == null) {
            return;
        }
        if (this.getLevel().m_5776_()) {
            return;
        }
        try {
            Collection patterns;
            ICraftingService craftingService = grid.getCraftingService();
            if (craftingService == null) {
                this.cachedPatternCount = 0;
                this.getHost().markForUpdate();
                return;
            }
            int count = 0;
            Set craftableItems = craftingService.getCraftables(AEItemKey.filter());
            Set craftableFluids = craftingService.getCraftables(AEFluidKey.filter());
            for (AEKey craftableItem : craftableItems) {
                patterns = craftingService.getCraftingFor(craftableItem);
                for (IPatternDetails pattern : patterns) {
                    if (!this.hasFluidInPattern(pattern)) continue;
                    ++count;
                }
            }
            for (AEKey craftableFluid : craftableFluids) {
                patterns = craftingService.getCraftingFor(craftableFluid);
                count += patterns.size();
            }
            if (this.cachedPatternCount != count) {
                this.cachedPatternCount = count;
                this.getHost().markForUpdate();
            }
        }
        catch (Exception e) {
            this.cachedPatternCount = 0;
            this.getHost().markForUpdate();
        }
    }

    private boolean hasFluidInPattern(IPatternDetails pattern) {
        for (GenericStack genericStack : pattern.getOutputs()) {
            if (genericStack == null || !(genericStack.what() instanceof AEFluidKey)) continue;
            return true;
        }
        for (GenericStack genericStack : pattern.getInputs()) {
            for (GenericStack possibleInput : genericStack.getPossibleInputs()) {
                if (possibleInput == null || !(possibleInput.what() instanceof AEFluidKey)) continue;
                return true;
            }
        }
        return false;
    }

    public int getPatternCount() {
        return this.cachedPatternCount;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        return false;
    }

    public boolean onPartShiftActivate(Player player, InteractionHand hand, Vec3 pos) {
        return false;
    }

    public AEKey getDisplayed() {
        return null;
    }

    public IPartModel getStaticModels() {
        if (this.isPowered()) {
            return this.isActive() ? MODELS_HAS_CHANNEL : MODELS_ON;
        }
        return MODELS_OFF;
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.cachedPatternCount = data.m_128451_("patternCount");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128405_("patternCount", this.cachedPatternCount);
    }

    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeInt(this.cachedPatternCount);
    }

    public boolean readFromStream(FriendlyByteBuf data) {
        super.readFromStream(data);
        int newCount = data.readInt();
        boolean changed = this.cachedPatternCount != newCount;
        this.cachedPatternCount = newCount;
        return changed;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(20, 100, false, false);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        IGrid grid = node.getGrid();
        if (grid != null) {
            this.updatePatternCount(grid);
            if (!this.hasInitialSync) {
                this.hasInitialSync = true;
                this.getHost().markForUpdate();
            }
        }
        return TickRateModulation.SLOWER;
    }

    public boolean requireDynamicRender() {
        return true;
    }

    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        int color;
        String text;
        poseStack.m_85836_();
        BlockOrientation orientation = BlockOrientation.get((Direction)this.getSide(), (int)this.getSpin());
        poseStack.m_85837_(0.5, 0.5, 0.5);
        BlockEntityRenderHelper.rotateToFace((PoseStack)poseStack, (BlockOrientation)orientation);
        poseStack.m_85837_(0.0, 0.05, 0.52);
        float scale = 0.01f;
        poseStack.m_85841_(scale, -scale, scale);
        Font font = Minecraft.m_91087_().f_91062_;
        if (!this.isActive()) {
            text = "OFFLINE";
            long time = System.currentTimeMillis();
            float blinkFactor = (float)(Math.sin((double)time / 500.0) * 0.25 + 0.75);
            int alpha = (int)(blinkFactor * 255.0f);
            color = alpha << 24 | 0xFF0000;
        } else {
            text = String.valueOf(this.cachedPatternCount);
            color = -1;
        }
        int textWidth = font.m_92895_(text);
        float x = (float)(-textWidth) / 2.0f;
        Objects.requireNonNull(font);
        float y = (float)(-9) / 2.0f;
        font.m_271703_(text, x, y, color, false, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
    }
}

