/*
 * Decompiled with CFR 0.152.
 */
package de.jonas;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.class_1657;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;

public class SpiralParticleManager {
    private static final List<PixelData> DRAGON_HEAD_PIXELS = new ArrayList<PixelData>();
    private static int imageWidth = 0;
    private static int imageHeight = 0;
    private static final Map<UUID, ParticleAnimation> activeAnimations;

    public static void startAnimation(class_1657 player) {
        if (!activeAnimations.containsKey(player.method_5667())) {
            activeAnimations.put(player.method_5667(), new ParticleAnimation());
        }
    }

    public static void onServerTick(MinecraftServer server) {
        activeAnimations.forEach((uuid, animation) -> {
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player == null || animation.isFinished()) {
                activeAnimations.remove(uuid);
            } else {
                animation.tick((class_1657)player);
            }
        });
    }

    static {
        System.out.println("[GOD MOD] Attempting to load dragon head particle image...");
        try {
            class_2960 imageIdentifier = new class_2960("bestmodever", "textures/particles/ender_dragon_head.png");
            InputStream inputStream = MinecraftServer.class.getClassLoader().getResourceAsStream("data/" + imageIdentifier.method_12836() + "/" + imageIdentifier.method_12832());
            if (inputStream == null) {
                System.err.println("[GOD MOD] FATAL ERROR: Could not find dragon head image at " + String.valueOf(imageIdentifier));
            } else {
                BufferedImage image = ImageIO.read(inputStream);
                imageWidth = image.getWidth();
                imageHeight = image.getHeight();
                for (int y = 0; y < imageHeight; ++y) {
                    for (int x = 0; x < imageWidth; ++x) {
                        int rgba = image.getRGB(x, y);
                        int alpha = rgba >> 24 & 0xFF;
                        if (alpha <= 10) continue;
                        int red = rgba >> 16 & 0xFF;
                        int green = rgba >> 8 & 0xFF;
                        int blue = rgba & 0xFF;
                        Vector3f color = new Vector3f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
                        DRAGON_HEAD_PIXELS.add(new PixelData(x, y, color));
                    }
                }
                System.out.println("[GOD MOD] Successfully loaded " + DRAGON_HEAD_PIXELS.size() + " pixels for dragon head effect.");
            }
        }
        catch (Exception e) {
            System.err.println("[GOD MOD] FATAL ERROR: Failed to read dragon head image!");
            e.printStackTrace();
        }
        activeAnimations = new ConcurrentHashMap<UUID, ParticleAnimation>();
    }

    private static class ParticleAnimation {
        private int ticksLived = 0;
        private boolean burstFired = false;
        private final int spiralDuration = 80;
        private final int headPersistDuration = 100;
        private final int particlesPerTick = 8;
        private final double spiralRadius = 1.5;
        private static final double PARTICLE_SCALE = 0.25;

        private ParticleAnimation() {
        }

        public void tick(class_1657 player) {
            ++this.ticksLived;
            class_3218 world = (class_3218)player.method_37908();
            if (this.ticksLived <= 80) {
                double playerHeight = player.method_17682();
                for (int i = 0; i < 8; ++i) {
                    double progress = (double)(this.ticksLived * 8 + i) / 640.0;
                    double y = player.method_23318() + playerHeight * progress;
                    double angle = progress * Math.PI * 10.0;
                    double x = player.method_23317() + 1.5 * Math.cos(angle);
                    double z = player.method_23321() + 1.5 * Math.sin(angle);
                    world.method_14199((class_2394)class_2398.field_11215, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            } else if (this.ticksLived <= 180) {
                if (!this.burstFired) {
                    class_243 headPos = player.method_19538().method_1031(0.0, (double)player.method_18381(player.method_18376()), 0.0);
                    world.method_14199((class_2394)class_2398.field_23190, headPos.field_1352, headPos.field_1351, headPos.field_1350, 200, 0.5, 0.5, 0.5, 0.5);
                    world.method_8396(null, player.method_24515(), class_3417.field_14671, class_3419.field_15248, 1.0f, 1.0f);
                    this.burstFired = true;
                }
                this.spawnDragonHeadFromImage(player, world);
            }
        }

        private void spawnDragonHeadFromImage(class_1657 player, class_3218 world) {
            if (DRAGON_HEAD_PIXELS.isEmpty()) {
                return;
            }
            float yaw = player.method_36454();
            class_243 forward = class_243.method_1030((float)0.0f, (float)yaw);
            class_243 right = class_243.method_1030((float)0.0f, (float)(yaw - 90.0f));
            class_243 centerOffset = right.method_1021((double)(-imageWidth) / 2.0 * 0.25).method_1031(0.0, (double)imageHeight / 2.0 * 0.25, 0.0);
            class_243 basePos = player.method_19538().method_1019(forward.method_1021(-5.0)).method_1031(0.0, 2.5, 0.0).method_1019(centerOffset);
            for (PixelData pixel : DRAGON_HEAD_PIXELS) {
                class_243 offset = right.method_1021((double)pixel.x() * 0.25).method_1031(0.0, (double)(-pixel.y()) * 0.25, 0.0);
                class_243 particlePos = basePos.method_1019(offset);
                class_2390 effect = new class_2390(pixel.color(), 1.0f);
                world.method_14199((class_2394)effect, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        public boolean isFinished() {
            return this.ticksLived > 180;
        }
    }

    private record PixelData(int x, int y, Vector3f color) {
    }
}

