/*
 * Decompiled with CFR 0.152.
 */
package de.jonas.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.jonas.BestModEver;
import de.jonas.LocationData;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class BaseManager {
    private static Map<UUID, LocationData> playerBases = new HashMap<UUID, LocationData>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("bestmodever_bases.json");

    public static void setBase(class_3222 player) {
        class_2338 pos = player.method_24515();
        String worldId = player.method_37908().method_27983().method_29177().toString();
        LocationData data = new LocationData((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, worldId);
        playerBases.put(player.method_5667(), data);
    }

    public static LocationData getBase(UUID playerUuid) {
        return playerBases.get(playerUuid);
    }

    public static void saveBases() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
            GSON.toJson(playerBases, (Appendable)writer);
            BestModEver.LOGGER.info("Successfully saved " + playerBases.size() + " player bases.");
        }
        catch (IOException e) {
            BestModEver.LOGGER.error("Failed to save player bases!", (Throwable)e);
        }
    }

    public static void loadBases() {
        if (!CONFIG_FILE.toFile().exists()) {
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
            Type type = new TypeToken<HashMap<UUID, LocationData>>(){}.getType();
            playerBases = (Map)GSON.fromJson((Reader)reader, type);
            if (playerBases == null) {
                playerBases = new HashMap<UUID, LocationData>();
            }
            BestModEver.LOGGER.info("Successfully loaded " + playerBases.size() + " player bases.");
        }
        catch (IOException e) {
            BestModEver.LOGGER.error("Failed to load player bases!", (Throwable)e);
        }
    }
}

