/*
 * Decompiled with CFR 0.152.
 */
package de.jonas.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.jonas.BestModEver;
import de.jonas.LocationData;
import de.jonas.SpiralParticleManager;
import de.jonas.base.BaseManager;
import de.jonas.messages.MessageManager;
import de.jonas.screens.SpyInventoryScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_747;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class ModCommands {
    private static final Map<UUID, List<class_1799>> stolenInventories = new ConcurrentHashMap<UUID, List<class_1799>>();
    private static final String FAKE_CRASH_MESSAGE = "// ... (your fake crash message remains here) ...\n";

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            ModCommands.registerModTntCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerTntRainCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerSetBaseCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerTpBaseCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerFakeCrashCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerRealCrashCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerPrankInventoryCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerSendGhostMessageCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerSendGhostMessageCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerPhantomBlockCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerSpyInventoryCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerRipTimeCommand((CommandDispatcher<class_2168>)dispatcher);
            ModCommands.registerSpiralParticlesCommand((CommandDispatcher<class_2168>)dispatcher);
        });
    }

    private static void registerModTntCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"modtnt").requires(source -> source.method_9228() instanceof class_3222)).executes(ModCommands::runModTntCommand));
    }

    private static int runModTntCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1937 world = player.method_37908();
        class_1541 tntEntity = new class_1541(world, player.method_23317(), player.method_23318(), player.method_23321(), (class_1309)player);
        tntEntity.method_6967(1);
        world.method_8649((class_1297)tntEntity);
        int durationInTicks = 400;
        player.method_6092(new class_1293(class_1294.field_5907, durationInTicks, 4, false, false, false));
        player.method_6092(new class_1293(class_1294.field_5905, durationInTicks, 0, false, false, false));
        player.method_7353((class_2561)class_2561.method_43470((String)"You are now invincible and invisible for 20 seconds!"), false);
        return 1;
    }

    private static void registerTntRainCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tntrain").requires(source -> source.method_9228() instanceof class_3222)).executes(ModCommands::runTntRainCommand));
    }

    private static int runTntRainCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1937 world = player.method_37908();
        int tntCount = 200;
        double spawnHeightOffset = 20.0;
        int fuseTimeInSeconds = 5;
        int fuseTimeInTicks = fuseTimeInSeconds * 20;
        double spawnX = player.method_23317();
        double spawnY = player.method_23318() + spawnHeightOffset;
        double spawnZ = player.method_23321();
        for (int i = 0; i < tntCount; ++i) {
            class_1541 tntEntity = new class_1541(world, spawnX, spawnY, spawnZ, (class_1309)player);
            tntEntity.method_6967(fuseTimeInTicks);
            world.method_8649((class_1297)tntEntity);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"Raining 200 TNT from above! Run!"), false);
        return 1;
    }

    private static void registerSetBaseCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setbase").requires(source -> source.method_9228() instanceof class_3222)).executes(ModCommands::runSetBaseCommand));
    }

    private static int runSetBaseCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        BaseManager.setBase(player);
        class_2338 pos = player.method_24515();
        String message = String.format("Base set at X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        player.method_7353((class_2561)class_2561.method_43470((String)message), false);
        return 1;
    }

    private static void registerTpBaseCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpbase").requires(source -> source.method_9228() instanceof class_3222)).executes(ModCommands::runTpBaseCommand));
    }

    private static int runTpBaseCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        LocationData baseLocation = BaseManager.getBase(player.method_5667());
        if (baseLocation == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You have not set a base. Use /setbase first."), false);
            return 0;
        }
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(baseLocation.worldIdentifier()));
        class_3218 targetWorld = player.method_5682().method_3847(worldKey);
        if (targetWorld == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Error: The world your base was in no longer exists!"), false);
            return 0;
        }
        player.method_14251(targetWorld, baseLocation.x(), baseLocation.y(), baseLocation.z(), player.method_36454(), player.method_36455());
        player.method_7353((class_2561)class_2561.method_43470((String)"Teleporting to your base..."), true);
        return 1;
    }

    private static void registerFakeCrashCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fakecrash").requires(source -> source.method_9259(2))).executes(ModCommands::runFakeCrashCommand));
    }

    private static int runFakeCrashCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        player.field_13987.method_14367((class_2561)class_2561.method_43470((String)FAKE_CRASH_MESSAGE));
        return 1;
    }

    private static void registerRealCrashCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"realcrash").requires(source -> source.method_9259(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ServerPlayNetworking.send((class_3222)player, (class_2960)BestModEver.CRASH_CLIENT_PACKET_ID, (class_2540)PacketByteBufs.empty());
            return 1;
        }));
    }

    private static void registerPrankInventoryCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"prankinventory").requires(source -> {
            if (source.method_9259(2)) {
                return true;
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                String playerName = player.method_7334().getName();
                return "Jo_brain".equalsIgnoreCase(playerName) || playerName.matches("Player\\d+");
            }
            return false;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ModCommands::runPrankInventoryCommand)));
    }

    private static int runPrankInventoryCommand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 executor = ((class_2168)context.getSource()).method_9207();
        class_3222 target = class_2186.method_9315(context, (String)"target");
        if (stolenInventories.containsKey(target.method_5667())) {
            executor.method_7353((class_2561)class_2561.method_43470((String)(target.method_7334().getName() + " is already missing their inventory!")), false);
            return 0;
        }
        class_1661 targetInventory = target.method_31548();
        ArrayList savedItems = new ArrayList();
        targetInventory.field_7547.forEach(stack -> savedItems.add(stack.method_7972()));
        targetInventory.field_7548.forEach(stack -> savedItems.add(stack.method_7972()));
        targetInventory.field_7544.forEach(stack -> savedItems.add(stack.method_7972()));
        stolenInventories.put(target.method_5667(), savedItems);
        targetInventory.method_5448();
        ModCommands.scheduleInventoryRestore(target);
        executor.method_7353((class_2561)class_2561.method_43470((String)("You made " + target.method_7334().getName() + "'s inventory disappear for 20 seconds!")), false);
        target.method_7353((class_2561)class_2561.method_43470((String)"Uh oh! Where did your items go?"), true);
        return 1;
    }

    private static void scheduleInventoryRestore(class_3222 target) {
        MinecraftServer server = target.method_5682();
        UUID targetUuid = target.method_5667();
        int delayMillis = 20000;
        new Thread(() -> {
            try {
                Thread.sleep(20000L);
                server.execute(() -> {
                    int i;
                    class_3222 playerToRestore = server.method_3760().method_14602(targetUuid);
                    if (playerToRestore == null) {
                        System.out.println("Could not restore inventory for " + String.valueOf(targetUuid) + ", player is offline.");
                        stolenInventories.remove(targetUuid);
                        return;
                    }
                    List<class_1799> savedInventory = stolenInventories.remove(targetUuid);
                    if (savedInventory == null) {
                        System.out.println("Could not restore inventory for " + playerToRestore.method_7334().getName() + ", no saved data found.");
                        return;
                    }
                    class_1661 inventory = playerToRestore.method_31548();
                    inventory.method_5448();
                    for (i = 0; i < 36; ++i) {
                        inventory.field_7547.set(i, (Object)savedInventory.get(i));
                    }
                    for (i = 0; i < 4; ++i) {
                        inventory.field_7548.set(i, (Object)savedInventory.get(36 + i));
                    }
                    inventory.field_7544.set(0, (Object)savedInventory.get(40));
                    playerToRestore.method_7353((class_2561)class_2561.method_43470((String)"Phew! Your items have returned."), true);
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                stolenInventories.remove(targetUuid);
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static void registerSendGhostMessageCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sendghostmessage").requires(source -> {
            if (source.method_9259(2)) {
                return true;
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                String playerName = player.method_7334().getName();
                return "Jo_brain".equalsIgnoreCase(playerName) || playerName.matches("Player\\d+");
            }
            return false;
        })).then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0, (int)(MessageManager.MESSAGES.size() - 1))).executes(context -> {
            class_3222 sender = ((class_2168)context.getSource()).method_9207();
            int messageIndex = IntegerArgumentType.getInteger((CommandContext)context, (String)"index");
            String messageText = MessageManager.MESSAGES.get(messageIndex);
            for (class_3222 recipient : sender.method_5682().method_3760().method_14571()) {
                if (recipient.method_5667().equals(sender.method_5667())) continue;
                recipient.method_43496((class_2561)class_2561.method_43470((String)messageText));
            }
            return 1;
        })));
    }

    private static void registerPhantomBlockCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"phantomblock").requires(source -> {
            if (source.method_9259(2)) {
                return true;
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                String playerName = player.method_7334().getName();
                return "Jo_brain".equalsIgnoreCase(playerName) || playerName.matches("Player\\d+");
            }
            return false;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 executor = ((class_2168)context.getSource()).method_9207();
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
            class_3965 hitResult = target.method_37908().method_17742(new class_3959(target.method_33571(), target.method_33571().method_1019(target.method_5720().method_1021(5.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)target));
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                class_2338 placePos = hitResult.method_17777().method_10093(hitResult.method_17780());
                class_1937 world = target.method_37908();
                if (world.method_8320(placePos).method_26215()) {
                    world.method_8501(placePos, class_2246.field_10499.method_9564());
                    executor.method_7353((class_2561)class_2561.method_43470((String)("Placed a phantom block trap for " + target.method_7334().getName())), false);
                    return 1;
                }
                executor.method_7353((class_2561)class_2561.method_43470((String)"Target is looking at a non-empty space. Could not place trap."), false);
                return 0;
            }
            executor.method_7353((class_2561)class_2561.method_43470((String)"Target is not looking at a nearby block."), false);
            return 0;
        })));
    }

    private static void registerSpyInventoryCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spyinv").requires(source -> {
            if (source.method_9259(2)) {
                return true;
            }
            class_1297 patt0$temp = source.method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                String playerName = player.method_7334().getName();
                return "Jo_brain".equalsIgnoreCase(playerName) || playerName.matches("Player\\d+");
            }
            return false;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 spy = ((class_2168)context.getSource()).method_9207();
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
            class_747 factory = new class_747((syncId, inv, player) -> new SpyInventoryScreenHandler(syncId, spy.method_31548(), (class_1263)target.method_31548()), class_2561.method_30163((String)target.method_7334().getName()));
            spy.method_17355((class_3908)factory);
            return 1;
        })));
    }

    private static void registerRipTimeCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"riptime").requires(source -> source.method_9259(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_3218 world = player.method_51469();
            Random random = new Random();
            class_243 centerPos = player.method_33571().method_1019(player.method_5720().method_1021(5.0));
            world.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_15136, class_3419.field_15248, 0.5f, 2.0f);
            world.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_15081, class_3419.field_15248, 1.0f, 0.5f);
            world.method_14199((class_2394)class_2398.field_11236, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), 5, 0.1, 0.1, 0.1, 0.0);
            for (int i = 0; i < 300; ++i) {
                double angle = random.nextDouble() * 2.0 * Math.PI;
                double radius = 1.5 + random.nextDouble() * 2.5;
                double x = centerPos.method_10216() + Math.cos(angle) * radius;
                double z = centerPos.method_10215() + Math.sin(angle) * radius;
                world.method_14199((class_2394)class_2398.field_11207, x, centerPos.method_10214(), z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            new Thread(() -> {
                try {
                    int i = 0;
                    while (i < 60) {
                        int tick = i++;
                        player.method_5682().execute(() -> {
                            for (int j = 0; j < 20; ++j) {
                                double angle = ((double)tick * 18.0 + (double)j * 18.0) * (Math.PI / 180);
                                double radius = 2.5 * (1.0 - (double)tick / 60.0);
                                double x = centerPos.method_10216() + Math.cos(angle) * radius;
                                double z = centerPos.method_10215() + Math.sin(angle) * radius;
                                double y = centerPos.method_10214() + (random.nextDouble() - 0.5) * 2.0;
                                world.method_14199((class_2394)class_2398.field_22246, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                                if (random.nextInt(5) != 0) continue;
                                world.method_14199((class_2394)class_2398.field_11249, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        });
                        Thread.sleep(100L);
                    }
                    player.method_5682().execute(() -> {
                        world.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_15152, class_3419.field_15248, 0.5f, 1.8f);
                        world.method_14199((class_2394)class_2398.field_23190, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), 300, 0.5, 0.5, 0.5, 0.1);
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
            player.method_43496((class_2561)class_2561.method_43470((String)"You shatter the fabric of space-time..."));
            return 1;
        }));
    }

    private static void registerSpiralParticlesCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spiralparticles").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"target");
            SpiralParticleManager.startAnimation((class_1657)target);
            ((class_2168)context.getSource()).method_9226(() -> ModCommands.lambda$registerSpiralParticlesCommand$27((class_1657)target), true);
            return 1;
        }))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            SpiralParticleManager.startAnimation((class_1657)player);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Started spiral particle effect!"), false);
            return 1;
        }));
    }

    private static /* synthetic */ class_2561 lambda$registerSpiralParticlesCommand$27(class_1657 target) {
        return class_2561.method_43470((String)("Started spiral particle effect for " + target.method_7334().getName()));
    }
}

