/*
 * Decompiled with CFR 0.152.
 */
package de.jonas.portals;

import de.jonas.blocks.ModBlocks;
import de.jonas.blocks.VoidScapePortalBlock;
import de.jonas.dimensions.ModDimensions;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class PortalManager {
    private static final class_2248 FRAME_BLOCK = class_2246.field_22423;

    public static boolean tryLightPortal(class_1937 world, class_2338 pos) {
        Optional<PortalFrame> frame = PortalManager.findFrame(world, pos, class_2350.class_2351.field_11051).or(() -> PortalManager.findFrame(world, pos, class_2350.class_2351.field_11048));
        if (frame.isPresent()) {
            PortalManager.fillPortal(world, frame.get());
            world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, world.method_8409().method_43057() * 0.4f + 0.8f);
            return true;
        }
        return false;
    }

    private static Optional<PortalFrame> findFrame(class_1937 world, class_2338 pos, class_2350.class_2351 axis) {
        class_2350 dir = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
        class_2338.class_2339 currentPos = pos.method_25503();
        while (world.method_8320(currentPos.method_10074()).method_27852(FRAME_BLOCK)) {
            currentPos.method_10098(class_2350.field_11033);
        }
        while (world.method_8320(currentPos.method_10093(dir)).method_27852(FRAME_BLOCK)) {
            currentPos.method_10098(dir);
        }
        int width = 0;
        class_2338.class_2339 tempPos = currentPos.method_25503();
        while (world.method_8320(tempPos.method_10093(dir.method_10153())).method_27852(FRAME_BLOCK)) {
            tempPos.method_10098(dir.method_10153());
            ++width;
        }
        int height = 0;
        tempPos = currentPos.method_25503();
        while (world.method_8320(tempPos.method_10084()).method_27852(FRAME_BLOCK)) {
            tempPos.method_10098(class_2350.field_11036);
            ++height;
        }
        if (width >= 2 && height >= 3) {
            return Optional.of(new PortalFrame(currentPos.method_10062(), width, height, axis));
        }
        return Optional.empty();
    }

    private static void fillPortal(class_1937 world, PortalFrame frame) {
        class_2350 dir = frame.axis == class_2350.class_2351.field_11048 ? class_2350.field_11034 : class_2350.field_11043;
        for (int h = 1; h < frame.height; ++h) {
            for (int w = 1; w < frame.width; ++w) {
                world.method_8501(frame.bottomLeft.method_10069(0, h, 0).method_10079(dir, w), (class_2680)ModBlocks.VOID_SCAPE_PORTAL.method_9564().method_11657(VoidScapePortalBlock.AXIS, (Comparable)frame.axis));
            }
        }
    }

    public static void tryTeleport(class_3222 player, class_2338 portalPos) {
        class_3218 destinationWorld;
        if (player.method_51848() > 0) {
            return;
        }
        class_5321 currentDim = player.method_37908().method_27983();
        double coordinateScale = currentDim.equals(ModDimensions.VOID_SCAPE_WORLD_KEY) ? 8.0 : 0.125;
        class_3218 class_32182 = destinationWorld = currentDim.equals(ModDimensions.VOID_SCAPE_WORLD_KEY) ? player.method_5682().method_3847(class_1937.field_25179) : player.method_5682().method_3847(ModDimensions.VOID_SCAPE_WORLD_KEY);
        if (destinationWorld == null) {
            return;
        }
        class_2338 destinationPos = PortalManager.findOrCreateDestinationPortal(destinationWorld, portalPos, coordinateScale);
        player.method_14251(destinationWorld, (double)destinationPos.method_10263() + 0.5, (double)destinationPos.method_10264(), (double)destinationPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
        player.method_51850(300);
    }

    private static class_2338 findOrCreateDestinationPortal(class_3218 world, class_2338 startPos, double scale) {
        class_2338 scaledPos = new class_2338((int)((double)startPos.method_10263() * scale), startPos.method_10264(), (int)((double)startPos.method_10260() * scale));
        return PortalManager.findExistingPortalColumn(world, scaledPos, 16).orElseGet(() -> {
            class_2338 safePos = PortalManager.findSafePortalPos((class_1937)world, scaledPos);
            PortalManager.createPortalFrame((class_1937)world, safePos);
            return safePos;
        });
    }

    private static Optional<class_2338> findExistingPortalColumn(class_3218 world, class_2338 center, int searchRadius) {
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(-searchRadius, 0, -searchRadius), (class_2338)center.method_10069(searchRadius, 0, searchRadius))) {
            for (int y = world.method_31607(); y < world.method_31600(); ++y) {
                class_2338 currentPos = new class_2338(pos.method_10263(), y, pos.method_10260());
                if (!world.method_8320(currentPos).method_27852(ModBlocks.VOID_SCAPE_PORTAL)) continue;
                while (y > world.method_31607() && world.method_8320(currentPos.method_10074()).method_27852(ModBlocks.VOID_SCAPE_PORTAL)) {
                    currentPos = currentPos.method_10074();
                    --y;
                }
                return Optional.of(currentPos);
            }
        }
        return Optional.empty();
    }

    private static class_2338 findSafePortalPos(class_1937 world, class_2338 pos) {
        class_2338.class_2339 currentPos = pos.method_25503();
        while (currentPos.method_10264() > world.method_31607() && world.method_8320(currentPos.method_10074()).method_26215()) {
            currentPos.method_10098(class_2350.field_11033);
        }
        while (!(currentPos.method_10264() >= world.method_31600() - 2 || world.method_8320((class_2338)currentPos).method_26215() && world.method_8320(currentPos.method_10084()).method_26215())) {
            currentPos.method_10098(class_2350.field_11036);
        }
        return currentPos.method_10062();
    }

    private static void createPortalFrame(class_1937 world, class_2338 pos) {
        for (int y = -1; y <= 3; ++y) {
            for (int x = -1; x <= 2; ++x) {
                class_2338 p = pos.method_10069(x, y, 0);
                if (x == -1 || x == 2 || y == -1 || y == 3) {
                    world.method_8501(p, FRAME_BLOCK.method_9564());
                    continue;
                }
                world.method_8501(p, ModBlocks.VOID_SCAPE_PORTAL.method_9564());
            }
        }
    }

    private record PortalFrame(class_2338 bottomLeft, int width, int height, class_2350.class_2351 axis) {
    }
}

