/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai;

import java.util.Random;
import net.mebahel.antiquebeasts.entity.custom.ChimeraEntity;
import net.mebahel.antiquebeasts.entity.projectiles.ChimeraProjectileEntity;
import net.mebahel.antiquebeasts.entity.projectiles.VenomEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3857;

public class ChimeraFlameThrowerGoal
extends class_1352 {
    private final ChimeraEntity chimera;
    private static final int MAX_COOLDOWN = 161;

    public ChimeraFlameThrowerGoal(ChimeraEntity chimera) {
        this.chimera = chimera;
    }

    public boolean method_6264() {
        return this.chimera.method_5968() != null;
    }

    public boolean method_6266() {
        return this.chimera.method_5968() != null;
    }

    public void method_6269() {
        this.chimera.setFireBreathingCooldown(161.0f);
    }

    public void method_6270() {
        this.chimera.setFireBreathing(false);
        this.chimera.setFireBreathingCooldown(161.0f);
    }

    public boolean method_38846() {
        return true;
    }

    private void chooseRandomAttack() {
        Random random = new Random();
        int attackChoice = random.nextInt(3);
        if (attackChoice == 0) {
            this.chimera.setAttackName("snake_shoot");
        } else {
            this.chimera.setAttackName("lion_shoot");
        }
    }

    private void launchProjectile(class_1937 world, class_1309 target, class_1676 projectile, double xOffset, double zOffset, double yHeight, float distanceMultiplier, float speedMultiplier) {
        double xProjectile = this.chimera.method_23317() + xOffset;
        double zProjectile = this.chimera.method_23321() + zOffset;
        double yProjectile = this.chimera.method_23323(0.8) + yHeight;
        double targetY = target.method_23320() - (double)1.1f;
        double dX = target.method_23317() - xProjectile;
        double dY = targetY - yProjectile;
        double dZ = target.method_23321() - zProjectile;
        double distanceFactor = Math.sqrt(dX * dX + dZ * dZ) * (double)0.2f;
        projectile.method_7485(dX, dY + distanceFactor * (double)distanceMultiplier, dZ, speedMultiplier, 1.0f);
        projectile.method_5814(xProjectile, yProjectile, zProjectile);
        world.method_8649((class_1297)projectile);
    }

    public void method_6268() {
        class_1309 target = this.chimera.method_5968();
        if (target != null && this.chimera.method_6057((class_1297)target)) {
            class_1937 world = this.chimera.method_37908();
            this.chimera.setFireBreathingCooldown(Math.max(this.chimera.getFireBreathingCooldown() - 1.0f, 0.0f));
            if (this.chimera.getFireBreathingCooldown() == 160.0f) {
                this.chooseRandomAttack();
            }
            if (this.chimera.getFireBreathingCooldown() == 14.0f || this.chimera.getFireBreathingCooldown() == 10.0f || this.chimera.getFireBreathingCooldown() == 6.0f) {
                class_243 lookVec = this.chimera.method_5828(1.0f).method_1029().method_1021(2.0);
                String attackName = this.chimera.getAttackName();
                class_3857 projectile = null;
                switch (attackName) {
                    case "lion_shoot": {
                        projectile = new ChimeraProjectileEntity(world, (class_1309)this.chimera, 7.0f);
                        this.launchProjectile(world, target, (class_1676)projectile, lookVec.field_1352, lookVec.field_1350, 0.0, this.getDistanceMultiplier(), this.getSpeedMultiplier());
                        break;
                    }
                    case "snake_shoot": {
                        if (this.chimera.getFireBreathingCooldown() != 10.0f) break;
                        projectile = new VenomEntity(world, (class_1309)this.chimera, 6.0f);
                        this.launchProjectile(world, target, (class_1676)projectile, 0.0, 0.0, 1.0, this.getDistanceMultiplier(), this.getSpeedMultiplier());
                    }
                }
            }
            this.manageFireBreathing();
        } else {
            this.resetFireBreathing();
        }
    }

    private float getDistanceMultiplier() {
        float distance = this.chimera.method_5739((class_1297)this.chimera.method_5968());
        if (distance > 25.0f) {
            return 1.5f;
        }
        if (distance >= 12.0f && distance <= 17.0f) {
            return 1.3f;
        }
        return 1.0f;
    }

    private float getSpeedMultiplier() {
        float distance = this.chimera.method_5739((class_1297)this.chimera.method_5968());
        if (distance > 25.0f) {
            return 0.8f;
        }
        if (distance >= 12.0f && distance <= 17.0f) {
            return 0.7f;
        }
        return 0.6f;
    }

    private void manageFireBreathing() {
        if (this.chimera.getFireBreathingCooldown() == 20.0f) {
            this.chimera.setFireBreathing(true);
        } else if (this.chimera.getFireBreathingCooldown() == 0.0f) {
            this.resetFireBreathing();
        } else if (this.chimera.getFireBreathingCooldown() < 161.0f && this.chimera.getFireBreathingCooldown() > 20.0f) {
            this.chimera.setFireBreathing(false);
        }
    }

    private void resetFireBreathing() {
        this.chimera.setFireBreathingCooldown(161.0f);
        this.chimera.setFireBreathing(false);
    }
}

