/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.client.custom.draugr_archer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrArcherEntity;
import net.mebahel.antiquebeasts.entity.variant.DraugrArcherVariant;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class DraugrArcherModel
extends GeoModel<DraugrArcherEntity> {
    public static final Map<DraugrArcherVariant, class_2960> LOCATION_BY_VARIANT = (Map)class_156.method_654((Object)Maps.newEnumMap(DraugrArcherVariant.class), map -> {
        map.put(DraugrArcherVariant.TEMPERATE, new class_2960("antiquebeasts", "textures/entity/draugr_archer/draugr_archer_temperate.png"));
        map.put(DraugrArcherVariant.COLD, new class_2960("antiquebeasts", "textures/entity/draugr_archer/draugr_archer_cold.png"));
        map.put(DraugrArcherVariant.HOT, new class_2960("antiquebeasts", "textures/entity/draugr_archer/draugr_archer_hot.png"));
    });

    public class_2960 getModelResource(DraugrArcherEntity object) {
        return new class_2960("antiquebeasts", "geo/draugr_archer.geo.json");
    }

    public class_2960 getTextureResource(DraugrArcherEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getArcherVariant());
    }

    public class_2960 getAnimationResource(DraugrArcherEntity animatable) {
        return new class_2960("antiquebeasts", "animations/draugr.animation.json");
    }

    public void setCustomAnimations(DraugrArcherEntity entity, long uniqueID, AnimationState<DraugrArcherEntity> customPredicate) {
        CoreGeoBone head = this.getBone("Head").orElse(null);
        EntityModelData extraData = (EntityModelData)customPredicate.getData(DataTickets.ENTITY_MODEL_DATA);
        float yawAngle = 0.125f * extraData.netHeadYaw() * ((float)Math.PI / 180);
        float pitchAngle = 0.125f * extraData.headPitch() * ((float)Math.PI / 180);
        if (Math.abs(yawAngle) > 0.6f) {
            yawAngle = 0.0f;
        }
        if (head != null) {
            head.setRotY(7.0f * yawAngle);
            head.setRotX(7.0f * pitchAngle);
        }
    }
}

