/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.egyptian;

import java.util.Objects;
import net.mebahel.antiquebeasts.entity.ai.MummyShootingGoal;
import net.mebahel.antiquebeasts.entity.ai.MummySummonGoal;
import net.mebahel.antiquebeasts.entity.ai.egyptian.EgyptianMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.util.GroupRevengeGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.EgyptiantVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class MummyEntity
extends EgyptianEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final class_2940<Integer> SPAWN_CD = class_2945.method_12791(MummyEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SPAWN = class_2945.method_12791(MummyEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(MummyEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> COOLDOWN = class_2945.method_12791(MummyEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SHOOTING = class_2945.method_12791(MummyEntity.class, (class_2941)class_2943.field_13323);

    public MummyEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    public int getCooldown() {
        return (Integer)this.field_6011.method_12789(COOLDOWN);
    }

    public void setCooldown(int cooldown) {
        this.field_6011.method_12778(COOLDOWN, (Object)cooldown);
    }

    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public int getSpawnCooldown() {
        return (Integer)this.field_6011.method_12789(SPAWN_CD);
    }

    public void setSpawnCooldown(int cooldown) {
        this.field_6011.method_12778(SPAWN_CD, (Object)cooldown);
    }

    public boolean getSpawn() {
        return (Boolean)this.field_6011.method_12789(SPAWN);
    }

    public void setSpawn(boolean bool) {
        this.field_6011.method_12778(SPAWN, (Object)bool);
    }

    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(COOLDOWN, (Object)0);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(IS_IN_CARAVAN, (Object)false);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"attack");
        this.field_6011.method_12784(SPAWN_CD, (Object)120);
        this.field_6011.method_12784(SPAWN, (Object)false);
        this.field_6011.method_12784(HAS_SPAWNED, (Object)false);
        this.field_6011.method_12784(PATROL_UUID, (Object)"");
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.55f).method_26868(class_5134.field_23716, 36.0 + (double)ModBonusHealthConfig.mummyBonusHealth).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23718, (double)0.2f).method_26868(class_5134.field_23722, 0.5);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new MummySummonGoal(this, 0.51f));
        this.field_6201.method_6277(3, (class_1352)new MummyShootingGoal(this, 0.51f));
        this.field_6201.method_6277(4, (class_1352)new EgyptianMeleeAttackGoal(this, 0.51f, 6.0, 1, 10));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, (double)0.45f, 1.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new GroupRevengeGoal((class_1314)this, EgyptianEntity.class).method_6318(new Class[]{EgyptianEntity.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DraugrEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    private PlayState predicate(AnimationState animationState) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (animationState.isMoving()) {
            animationState.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then(this.getAttackName(), Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState raisePredicate(AnimationState state) {
        if (this.getSpawn() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("raise", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    private PlayState spawnPredicate(AnimationState state) {
        if (!this.getHasSpawned()) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE));
            if (state.getController().getAnimationState() != AnimationController.State.STOPPED) {
                this.spawnHoveringParticles();
            } else {
                this.setHasSpawned(true);
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState shootingPredicate(AnimationState state) {
        if (this.isShooting() && !this.isSwinging() && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, this::attackPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.SWING, this.method_5634(), 0.5f, 1.5f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawning", 0, this::spawnPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SPAWN, this.method_5634(), 0.65f, 1.0f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "raise", 0, this::raisePredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_RAISE, this.method_5634(), 0.65f, 1.0f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "shooting", 0, this::shootingPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SHOOT, this.method_5634(), 0.65f, 1.0f);
            }
        })});
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.shouldDespawnInPeaceful()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (this.field_6012 < 40 || this.getSpawn() || this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.0);
        } else if (Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6194() == 0.0 && !this.getSpawn() && !this.isShooting()) {
            Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)0.57f);
        }
    }

    protected class_3414 method_6011(class_1282 source) {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.MUMMY_HURT_1;
        }
        return ModSounds.MUMMY_HURT_2;
    }

    protected class_3414 method_6002() {
        return ModSounds.MUMMY_DEATH;
    }

    protected class_3414 method_5994() {
        this.rand = Math.random();
        if (this.rand < 0.5) {
            return ModSounds.MUMMY_AMBIENT_1;
        }
        return ModSounds.MUMMY_AMBIENT_2;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        EgyptiantVariant variant = (EgyptiantVariant)((Object)class_156.method_27173((Object[])EgyptiantVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return entityData;
    }

    public EgyptiantVariant getVariant() {
        return EgyptiantVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(EgyptiantVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_42338)) {
            amount *= 2.0f;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasSpawned", true);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHasSpawned(nbt.method_10577("HasSpawned"));
    }

    private void spawnHoveringParticles() {
        double posX = this.method_23317();
        double posY = this.method_23318() - 0.1;
        double posZ = this.method_23321();
        class_2338 blockPos = new class_2338((int)posX, (int)(this.method_23318() - 0.5), (int)posZ);
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_26215()) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
                double velocityY = 0.1;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), posX + offsetX, posY, posZ + offsetZ, 0.0, velocityY, 0.0);
            }
        }
    }

    public static boolean canMobSpawnWithRate(class_1299<? extends class_1429> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        boolean isSandyGround;
        if (spawnReason == class_3730.field_16469 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16462 || spawnReason == class_3730.field_16467) {
            return true;
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockBelow = world.method_8320(blockPos);
        boolean bl = isSandyGround = blockBelow.method_27852(class_2246.field_10102) || blockBelow.method_27852(class_2246.field_10534);
        if (!isSandyGround) {
            return false;
        }
        int randomValue = random.method_43048(10);
        return randomValue < ModSpawnRateConfig.mummySpawnRate;
    }
}

