/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.custom.other;

import net.mebahel.antiquebeasts.block.entity.BlockScanEntity;
import net.mebahel.antiquebeasts.entity.ModEntities;
import net.mebahel.antiquebeasts.entity.ai.CustomRevengeGoal;
import net.mebahel.antiquebeasts.entity.ai.other.DraugrOverlordMeleeAttackGoal;
import net.mebahel.antiquebeasts.entity.ai.other.DraugrOverlordSpecialAttackGoal;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.GreekEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.NorseEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.variant.DraugrOverlordVariant;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class DraugrOverlordEntity
extends DraugrEntity
implements GeoEntity {
    private final class_3213 bossBar;
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int attackTick = 0;
    public static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SWINGING = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<String> ATTACK_NAME = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> HAS_SPAWNED = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> SPECIAL_COOLDOWN = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> SPECIAL = class_2945.method_12791(DraugrOverlordEntity.class, (class_2941)class_2943.field_13323);

    public DraugrOverlordEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6191 = -this.method_5970();
        this.bossBar = new class_3213(class_2561.method_30163((String)"Draugr Overlord"), class_1259.class_1260.field_5784, class_1259.class_1261.field_5791);
        this.bossBar.method_5408(1.0f);
        this.method_5971();
    }

    public int incrementAttackTick() {
        return ++this.attackTick;
    }

    public void resetAttackTick() {
        this.attackTick = 0;
    }

    public boolean getSpecial() {
        return (Boolean)this.field_6011.method_12789(SPECIAL);
    }

    public void setSpecial(boolean bool) {
        this.field_6011.method_12778(SPECIAL, (Object)bool);
    }

    public int getSpecialCooldown() {
        return (Integer)this.field_6011.method_12789(SPECIAL_COOLDOWN);
    }

    public void setSpecialCooldown(int value) {
        this.field_6011.method_12778(SPECIAL_COOLDOWN, (Object)value);
    }

    @Override
    public boolean getHasSpawned() {
        return (Boolean)this.field_6011.method_12789(HAS_SPAWNED);
    }

    @Override
    public void setHasSpawned(boolean bool) {
        this.field_6011.method_12778(HAS_SPAWNED, (Object)bool);
    }

    @Override
    public void setSwinging(boolean swinging) {
        this.field_6011.method_12778(SWINGING, (Object)swinging);
    }

    @Override
    public boolean isSwinging() {
        return (Boolean)this.field_6011.method_12789(SWINGING);
    }

    @Override
    public void setAttackName(String attackName) {
        this.field_6011.method_12778(ATTACK_NAME, (Object)attackName);
    }

    @Override
    public String getAttackName() {
        return (String)this.field_6011.method_12789(ATTACK_NAME);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SWINGING, (Object)false);
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
        this.field_6011.method_12784(ATTACK_NAME, (Object)"sl_attack_rush");
        this.field_6011.method_12784(HAS_SPAWNED, (Object)true);
        this.field_6011.method_12784(SPECIAL, (Object)false);
        this.field_6011.method_12784(SPECIAL_COOLDOWN, (Object)70);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DraugrOverlordSpecialAttackGoal(this));
        this.field_6201.method_6277(3, (class_1352)new DraugrOverlordMeleeAttackGoal(this, 0.95f));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, (double)0.85f, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new CustomRevengeGoal((class_1314)this, DraugrEntity.class));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, DwemerEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, GreekEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, EgyptianEntity.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, NorseEntity.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1588.method_26828().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23716, 400.0 + (double)ModBonusHealthConfig.draugrBonusHealth).method_26868(class_5134.field_23724, 14.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23718, 0.75).method_26868(class_5134.field_23722, 0.5);
    }

    private PlayState predicate(AnimationState state) {
        if (!this.getHasSpawned()) {
            return PlayState.STOP;
        }
        if (state.isMoving() && !this.getSpecial() && !this.isSwinging()) {
            this.spawnSwordDraggingParticles();
            state.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!(state.isMoving() || this.method_6510() || this.getSpecial())) {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 0, state -> PlayState.CONTINUE).triggerableAnim("sl_attack_rush", RawAnimation.begin().then("sl_attack_rush", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_double1", RawAnimation.begin().then("sl_attack_double1", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_double2", RawAnimation.begin().then("sl_attack_double2", Animation.LoopType.PLAY_ONCE)).triggerableAnim("sl_attack_triple", RawAnimation.begin().then("sl_attack_triple", Animation.LoopType.PLAY_ONCE))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawning", 0, this::spawnPredicate).setSoundKeyframeHandler(state -> {
            class_1657 player = ClientUtils.getClientPlayer();
            if (player != null) {
                this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.MUMMY_SPAWN, this.method_5634(), 0.65f, 1.0f);
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "specialController", 0, state -> PlayState.CONTINUE).triggerableAnim("sl_attack_quake", RawAnimation.begin().then("sl_attack_quake", Animation.LoopType.PLAY_ONCE))});
    }

    public DraugrOverlordVariant getOverlordVariant() {
        return DraugrOverlordVariant.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant() {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(DraugrOverlordVariant.GREATSWORD.getId() & 0xFF));
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setVariant();
        return entityData;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return super.method_5643(source, amount * 2.0f);
        }
        if (source.method_49708(class_8111.field_42354)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.updateBossBar();
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        if (this.method_29504() || this.method_31481()) {
            this.bossBar.method_14094();
        }
    }

    private void updateBossBar() {
        class_238 detectionBox = new class_238(this.method_24515()).method_1014(18.0);
        for (class_1657 player : this.method_37908().method_18456()) {
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            if (detectionBox.method_1006(player.method_19538())) {
                if (this.bossBar.method_14092().contains(serverPlayer)) continue;
                this.bossBar.method_14088(serverPlayer);
                continue;
            }
            if (!this.bossBar.method_14092().contains(serverPlayer)) continue;
            this.bossBar.method_14089(serverPlayer);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    private <T extends GeoAnimatable> PlayState spawnPredicate(AnimationState<T> state) {
        if (!this.getHasSpawned()) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE));
            if (state.getController().getAnimationState() != AnimationController.State.STOPPED) {
                this.spawnHoveringParticles();
            } else {
                this.setHasSpawned(true);
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    void spawnHoveringParticles() {
        double posX = this.method_23317();
        double posY = this.method_23318() - 0.1;
        double posZ = this.method_23321();
        class_2338 blockPos = new class_2338((int)posX, (int)(this.method_23318() - 0.5), (int)posZ);
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (!blockState.method_26215()) {
            for (int i = 0; i < 3; ++i) {
                double offsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
                double offsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
                double velocityY = 0.1;
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), posX + offsetX, posY, posZ + offsetZ, 0.0, velocityY, 0.0);
            }
        }
    }

    public void spawnSwordDraggingParticles() {
        double yawRad = Math.toRadians(-this.field_6283);
        double cosYaw = Math.cos(yawRad);
        double sinYaw = Math.sin(yawRad);
        double offsetBackX = -sinYaw;
        double offsetBackZ = -cosYaw;
        double offsetRightX = -cosYaw;
        double offsetRightZ = sinYaw;
        double particleX = this.method_23317() + offsetBackX + offsetRightX;
        double particleZ = this.method_23321() + offsetBackZ + offsetRightZ;
        double particleY = this.method_23318();
        class_2338 blockPos = new class_2338((int)particleX, (int)(particleY - 1.0), (int)particleZ);
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        if (blockState.method_26215()) {
            return;
        }
        for (int i = 0; i < 1; ++i) {
            double randomOffsetX = (this.field_5974.method_43058() - 0.5) * 0.1;
            double randomOffsetZ = (this.field_5974.method_43058() - 0.5) * 0.1;
            this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), particleX + randomOffsetX, particleY, particleZ + randomOffsetZ, 0.0, 0.05, 0.0);
        }
    }

    public static void AreaCrackedGround(class_1309 mob, class_1937 world, class_2338 centerPos, int radius) {
        class_2338 startPos = centerPos.method_10074();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                class_2338 targetPos = startPos.method_10069(x, -1, z);
                if (!(startPos.method_10262((class_2382)targetPos) <= (double)(radius * radius))) continue;
                class_2680 blockState = world.method_8320(targetPos);
                class_2338 spawnPos = targetPos.method_10084();
                DraugrOverlordEntity.spawnBlockScanEntity(world, spawnPos, blockState, mob.method_6051());
            }
        }
    }

    public static void spawnBlockScanEntity(class_1937 world, class_2338 pos, class_2680 blockState, class_5819 random) {
        BlockScanEntity blockScanEntity = new BlockScanEntity(ModEntities.BLOCK_SCAN_ENTITY, world);
        float randomYOffset = random.method_43057() * 0.2f + 0.2f;
        blockScanEntity.method_5814(pos.method_10263(), (double)pos.method_10264() - 0.5 + (double)randomYOffset, pos.method_10260());
        blockScanEntity.setBlockState(blockState);
        float randomPitch = random.method_43057() * 40.0f - 20.0f;
        float randomYaw = random.method_43057() * 40.0f - 20.0f;
        blockScanEntity.method_36457(randomPitch);
        blockScanEntity.method_36456(randomYaw);
        world.method_8649((class_1297)blockScanEntity);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(ModSounds.DRAUGR_WALK_1, 0.65f, 0.7f);
    }
}

