/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mebahel.antiquebeasts.AntiqueBeasts;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.item.custom.ModItems;
import net.mebahel.antiquebeasts.util.raid.DraugrRaidTest;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ThurisazRune
extends class_1792 {
    private static final String KILL_COUNT_KEY = "DraugrKills";
    private static final int MAX_KILL = 20;
    private static final String ACTIVATABLE_KEY = "Activatable";

    public ThurisazRune(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int killCount = ThurisazRune.getKillCount(stack);
        boolean activatable = ThurisazRune.isActivatable(stack);
        tooltip.add((class_2561)class_2561.method_43471((String)"\u00a76Draugrs killed :").method_10852((class_2561)class_2561.method_43470((String)(" " + killCount + " / 20"))));
        if (activatable) {
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7aReady to activate!").method_27692(class_124.field_1060));
        }
    }

    public static int getKillCount(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        return nbt.method_10545(KILL_COUNT_KEY) ? nbt.method_10550(KILL_COUNT_KEY) : 0;
    }

    public static void incrementKillCount(class_1799 stack, class_1657 player) {
        class_2487 nbt = stack.method_7948();
        int currentCount = ThurisazRune.getKillCount(stack);
        if (currentCount < 20) {
            nbt.method_10569(KILL_COUNT_KEY, ++currentCount);
            if (currentCount == 20) {
                nbt.method_10556(ACTIVATABLE_KEY, true);
            }
            stack.method_7980(nbt);
            player.method_31548().method_5431();
            player.field_7512.method_7623();
        }
    }

    public static boolean isActivatable(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        return nbt.method_10545(ACTIVATABLE_KEY) && nbt.method_10577(ACTIVATABLE_KEY);
    }

    public static void onDraugrKilled(class_1657 player, class_1309 killedEntity) {
        if (killedEntity instanceof DraugrEntity) {
            class_1799 offHandItem;
            ArrayList<class_1799> validRunes = new ArrayList<class_1799>();
            class_1799 mainHandItem = player.method_6047();
            if (ThurisazRune.isValidRune(mainHandItem)) {
                validRunes.add(mainHandItem);
            }
            if (ThurisazRune.isValidRune(offHandItem = player.method_6079())) {
                validRunes.add(offHandItem);
            }
            for (class_1799 stack : player.method_31548().field_7547) {
                if (!ThurisazRune.isValidRune(stack)) continue;
                validRunes.add(stack);
            }
            if (!validRunes.isEmpty()) {
                Random random = new Random();
                class_1799 selectedRune = (class_1799)validRunes.get(random.nextInt(validRunes.size()));
                ThurisazRune.incrementKillCount(selectedRune, player);
            }
        }
    }

    private static boolean isValidRune(class_1799 stack) {
        return !stack.method_7960() && stack.method_7909() == ModItems.THURISAZ_RUNE && ThurisazRune.getKillCount(stack) < 20;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (ThurisazRune.isActivatable(stack)) {
            if (world.method_8311(player.method_24515())) {
                this.startRaid(player);
                stack.method_7956(1, (class_1309)player, entity -> entity.method_20236(hand));
                return class_1271.method_22427((Object)stack);
            }
            if (!world.field_9236) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You must be on the surface to activate this rune!").method_27692(class_124.field_1061), true);
            }
            return class_1271.method_22431((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    private void startRaid(class_1657 player) {
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (AntiqueBeasts.ongoingRaids.isEmpty()) {
                System.out.println("No ongoing raids. Proceeding to create a new raid.");
            } else {
                AntiqueBeasts.ongoingRaids.removeIf(raid -> !raid.isRaidInProgress() || raid.isRaidCompleted());
                System.out.println("Cleaned up completed or inactive raids from ongoingRaids.");
            }
            boolean anyRaidInProgress = AntiqueBeasts.ongoingRaids.stream().anyMatch(DraugrRaidTest::isRaidInProgress);
            if (anyRaidInProgress) {
                player.method_7353((class_2561)class_2561.method_43470((String)"A raid is already in progress! Please wait for it to finish.").method_27694(style -> style.method_10977(class_124.field_1061)), false);
                return;
            }
            DraugrRaidTest raid2 = new DraugrRaidTest(player, serverWorld);
            player.method_7353((class_2561)class_2561.method_43470((String)"You've awoken an ancient evil...").method_27692(class_124.field_1061), true);
            raid2.startRaid();
            raid2.saveRaid();
        }
    }
}

