/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.util.books;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_159;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class AddBookToLootTableUtil {
    private final Map<String, BookLootData> books = new HashMap<String, BookLootData>();

    public void addBookFromString(String bookId, String title, String author, String content, List<class_2960> targetLootTables) {
        List<String> pages = this.splitIntoPages(content, 256);
        this.addBook(bookId, title, author, pages, targetLootTables);
    }

    public void addBook(String bookId, String title, String author, List<String> pages, List<class_2960> targetLootTables) {
        class_2487 bookNbt = new class_2487();
        bookNbt.method_10582("title", title);
        bookNbt.method_10582("author", author);
        bookNbt.method_10566("pages", (class_2520)this.createBookPages(pages));
        this.books.put(bookId, new BookLootData(bookNbt, targetLootTables));
    }

    private class_2499 createBookPages(List<String> pages) {
        class_2499 pagesList = new class_2499();
        for (String text : pages) {
            pagesList.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_30163((String)text))));
        }
        return pagesList;
    }

    private List<String> splitIntoPages(String text, int maxPageLength) {
        ArrayList<String> pages = new ArrayList<String>();
        int start = 0;
        while (start < text.length()) {
            int end = Math.min(start + maxPageLength, text.length());
            pages.add(text.substring(start, end));
            start = end;
        }
        return pages;
    }

    public void registerModifyLootTable() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            List<BookLootData> matchingBooks = this.books.values().stream().filter(book -> book.targetLootTables.contains(id)).toList();
            if (matchingBooks.isEmpty()) {
                return;
            }
            class_55.class_56 poolBuilder = class_55.method_347();
            poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8620).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)0.0f))).method_437(3 + matchingBooks.size() * 3));
            for (BookLootData book2 : matchingBooks) {
                poolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8360).method_438((class_117.class_118)class_159.method_677((class_2487)book2.nbt)).method_437(1));
            }
            tableBuilder.method_336(poolBuilder);
        });
    }

    private record BookLootData(class_2487 nbt, List<class_2960> targetLootTables) {
    }
}

