/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.mebahel.antiquebeasts.block.ModBlockEntities;
import net.mebahel.antiquebeasts.block.ModBlocks;
import net.mebahel.antiquebeasts.block.screenhandlers.ModScreenHandlers;
import net.mebahel.antiquebeasts.entity.ModEntities;
import net.mebahel.antiquebeasts.entity.custom.ChimeraEntity;
import net.mebahel.antiquebeasts.entity.custom.CyclopsEntity;
import net.mebahel.antiquebeasts.entity.custom.FrostCyclopsEntity;
import net.mebahel.antiquebeasts.entity.custom.HadesChosenEntity;
import net.mebahel.antiquebeasts.entity.custom.HadesShadeEntity;
import net.mebahel.antiquebeasts.entity.custom.PegasusEntity;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerCenturionEntity;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerSpiderEntity;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerSpiderGuardianEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.AxemanEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.CamelryEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianCaravanEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.ElephantRiderEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.MummyBossEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.MummyEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.ServantEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.WadjetEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.CentaurEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.ChampionHopliteEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.EliteHopliteEntity;
import net.mebahel.antiquebeasts.entity.custom.greek.HeroHopliteEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.EinherjarEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.HersirEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.HuskarlEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.ThrowingAxeManEntity;
import net.mebahel.antiquebeasts.entity.custom.norse.ValkyrieEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrArcherEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrOverlordEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrScourgeEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrWightEntity;
import net.mebahel.antiquebeasts.entity.custom.other.HarpyEntity;
import net.mebahel.antiquebeasts.entity.custom.other.SkeletonWarriorEntity;
import net.mebahel.antiquebeasts.entity.custom.other.SkeletonWarriorHeadEntity;
import net.mebahel.antiquebeasts.item.TickScheduler;
import net.mebahel.antiquebeasts.item.custom.ModArmors;
import net.mebahel.antiquebeasts.item.custom.ModItemGroups;
import net.mebahel.antiquebeasts.item.custom.ModItems;
import net.mebahel.antiquebeasts.item.custom.ModSpawnEggs;
import net.mebahel.antiquebeasts.particle.ModParticles;
import net.mebahel.antiquebeasts.potion.ModPotions;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.MyProcessors;
import net.mebahel.antiquebeasts.util.PatrolManager;
import net.mebahel.antiquebeasts.util.WaterRemovalScheduler;
import net.mebahel.antiquebeasts.util.books.AddBookToLootTableUtil;
import net.mebahel.antiquebeasts.util.books.LootTableGroups;
import net.mebahel.antiquebeasts.util.config.ModArmorValueConfig;
import net.mebahel.antiquebeasts.util.config.ModBonusHealthConfig;
import net.mebahel.antiquebeasts.util.config.ModConfig;
import net.mebahel.antiquebeasts.util.config.ModSpawnRateConfig;
import net.mebahel.antiquebeasts.util.packet.ModNetworking;
import net.mebahel.antiquebeasts.util.raid.AntiquebeastsDifficultyState;
import net.mebahel.antiquebeasts.util.raid.DraugrRaidTest;
import net.mebahel.antiquebeasts.util.raid.PersistentRaidData;
import net.mebahel.antiquebeasts.util.raid.RaidManager;
import net.mebahel.antiquebeasts.world.gen.ModWorldGen;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiqueBeasts
implements ModInitializer {
    public static final String MOD_ID = "antiquebeasts";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"antiquebeasts");
    private static final TickScheduler tickScheduler = new TickScheduler();
    private static final AntiquebeastsDifficultyState antiquebeastsDifficultyState = new AntiquebeastsDifficultyState(1);
    private static final WaterRemovalScheduler waterRemovalScheduler = new WaterRemovalScheduler();
    private static final Map<class_3218, ServerTickEvents.EndTick> registeredListeners = new HashMap<class_3218, ServerTickEvents.EndTick>();
    private static final Map<class_3218, ServerPlayConnectionEvents.Join> registeredJoinEventListeners = new HashMap<class_3218, ServerPlayConnectionEvents.Join>();
    public static final Map<class_3218, Integer> worldDifficultyLevels = new HashMap<class_3218, Integer>();
    public static final List<DraugrRaidTest> ongoingRaids = new ArrayList<DraugrRaidTest>();
    private boolean playerHasArrived = false;
    private boolean shouldEnableLoad = true;
    private static final int ACHIEVEMENT_CHECK_INTERVAL = 20;
    private int achievementTickCounter = 0;
    private final Set<UUID> playersWithAchievement = new HashSet<UUID>();
    public static final class_2960 ADVANCEMENT_ID = new class_2960("antiquebeasts", "see_mummy_boss");

    public void onInitialize() {
        File configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), MOD_ID);
        ModConfig.loadConfig(configDir);
        ModArmorValueConfig.loadConfig(configDir);
        ModSpawnRateConfig.loadConfig(configDir);
        ModBonusHealthConfig.loadConfig(configDir);
        ModItemGroups.registerItemGroups();
        FabricDefaultAttributeRegistry.register(ModEntities.DWEMER_CENTURION, (class_5132.class_5133)DwemerCenturionEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DWEMER_SPIDER, (class_5132.class_5133)DwemerSpiderEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DWEMER_SPIDER_GUARDIAN, (class_5132.class_5133)DwemerSpiderGuardianEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_OVERLORD, (class_5132.class_5133)DraugrOverlordEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SKELETON_WARRIOR_HEAD, (class_5132.class_5133)SkeletonWarriorHeadEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SKELETON_WARRIOR, (class_5132.class_5133)SkeletonWarriorEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_SCOURGE, (class_5132.class_5133)DraugrScourgeEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_WIGHT, (class_5132.class_5133)DraugrWightEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR_ARCHER, (class_5132.class_5133)DraugrArcherEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.MUMMY_BOSS, (class_5132.class_5133)MummyBossEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HARPY, (class_5132.class_5133)HarpyEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRAUGR, (class_5132.class_5133)DraugrEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.CENTAUR, (class_5132.class_5133)CentaurEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.EGYPTIAN_CARAVAN, (class_5132.class_5133)EgyptianCaravanEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.PEGASUS, (class_5132.class_5133)PegasusEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.CHIMERA, (class_5132.class_5133)ChimeraEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.ELEPHANT_RIDER, (class_5132.class_5133)ElephantRiderEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SERVANT, (class_5132.class_5133)ServantEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.MUMMY, (class_5132.class_5133)MummyEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.CAMELRY, (class_5132.class_5133)CamelryEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.AXEMAN, (class_5132.class_5133)AxemanEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.WADJET, (class_5132.class_5133)WadjetEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.CYCLOPS, (class_5132.class_5133)CyclopsEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.FROST_CYCLOPS, (class_5132.class_5133)FrostCyclopsEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.CHAMPION_HOPLITE, (class_5132.class_5133)ChampionHopliteEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.ELITE_HOPLITE, (class_5132.class_5133)EliteHopliteEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HERO_HOPLITE, (class_5132.class_5133)HeroHopliteEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HADES_CHOSEN, (class_5132.class_5133)HadesChosenEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HADES_SHADE, (class_5132.class_5133)HadesShadeEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HERSIR, (class_5132.class_5133)HersirEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HUSKARL, (class_5132.class_5133)HuskarlEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.THROWING_AXEMAN, (class_5132.class_5133)ThrowingAxeManEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.EINHERJAR, (class_5132.class_5133)EinherjarEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.VALKYRIE, (class_5132.class_5133)ValkyrieEntity.setAttributes());
        ModArmors.registerModArmors();
        ModSounds.registerSounds();
        ModBlocks.registerModBlocks();
        ModBlockEntities.registerModBlockEntities();
        ModWorldGen.generateWorldGen();
        ModItems.registerModItems();
        ModSpawnEggs.registerModItems();
        ModParticles.registerParticles();
        ModPotions.registerPotionRecipe();
        PatrolManager.register();
        ModScreenHandlers.registerScreenHandlers();
        MyProcessors.init();
        RaidManager.registerEvents();
        ModNetworking.registerReceivers();
        AddBookToLootTableUtil bookUtil = new AddBookToLootTableUtil();
        bookUtil.addBookFromString("villager_entry_2", "More like Zeusless", "Unknown Witness", "Those ploughing hoplites, will they not leave us be? We're but a small village, they have the luxury of those grand eyesores they call home. I suppose that's not enough for those whoresons, attacking us, wanting our land too. If Zeus truly is for the people then why must he let this happen? \"I gave you people your golems, what more do you want?\" I don't know Zeus, maybe some thick walls where it's nice and safe from monsters like your dearly beloved hoplites get. Maybe tell them to stop trying to take our land for once. I say, Zeus could probably fart on us and he'd expect us to kneel and praise him for that too. I've had enough of this farcical display. The only good those hoplites are for is when the draugr and zombies bother them instead of us. Come morn, I'm moving away from this village in search for another. Damn Zeus and damn those bloody hoplites, may they never know peace in their miserable lives.", LootTableGroups.VILLAGE_ALL.get());
        bookUtil.addBookFromString("villager_entry_1", "A Mysterious Event", "Unknown Witness", "Mary won't believe me, but I know what I saw was no jest. Some knight, with some sort of stone or rune, casting a spell to what appeared to be summoning waves of those vile draugr creatures. I made sure not to get too close, I only witnessed it from afar, but I definitely witnessed truth before my eyes, not some mere hoax or illusion. Luckily, whoever this brave soul was, he was able to slay all the draugr, then received what I can only describe as some sort of green, wide storage container, similar to a chest. I didn't get close enough to ascertain for certain, as reason told me I shan't get too close, lest I wished my early death. But whatever it was, it seemed to hold all sorts of treasures. Perhaps tomorrow I shall go back to the spot and see what remains. My mind tells me I shan't see anything there anymore, not even that brave knight who took off into the night once his deed was fulfilled, but who knows, perhaps Odin will bless me and has left a few valuable trinkets for me and Mary to ogle. I'll set foot there once again tomorrow, I'm certain of that at least... ", LootTableGroups.VILLAGE_ALL.get());
        bookUtil.addBookFromString("hoplite_new_recruit_entry_1", "Rumbling Temple", "Hoplite New Recrute", "What the gods is that noise down below? I may be new to the ranks but I feel as though I have a right to know what pest keeps me up at nights in the temple. Sokratis tells me it is not for me to know, but he can't punish me for having a hint of curiosity - the bloody thing keeps me awake at night! I took one look down into the deeper parts of our temple and saw nothing friendly down there. The others tell me to stay away and truth be told I'd be a fool to not listen, but Zeus bless any poor soul unfortunate enough to be forced down there. Only the sounds of monsters and waning cries for help echo through those walls.", List.of(new class_2960(MOD_ID, "chests/greek/temple_commun")));
        bookUtil.registerModifyLootTable();
        ServerWorldEvents.LOAD.register((server, world) -> {
            waterRemovalScheduler.addWorld(world);
            antiquebeastsDifficultyState.registerDifficultyState(world);
            ServerPlayConnectionEvents.Join joinEventListener = (handler, sender, server2) -> {
                if (world.method_27983().equals(class_1937.field_25179)) {
                    this.playerHasArrived = true;
                }
            };
            registeredJoinEventListeners.put(world, joinEventListener);
            ServerTickEvents.EndTick listener = serverTick -> {
                if (serverTick.method_3847(class_1937.field_25179) == world) {
                    if (this.playerHasArrived && this.shouldEnableLoad) {
                        tickScheduler.schedule(world, 20, w -> PersistentRaidData.get(world));
                        this.shouldEnableLoad = false;
                        this.playerHasArrived = false;
                    }
                    waterRemovalScheduler.tick();
                }
                this.checkMummyBossAchievement(world);
                antiquebeastsDifficultyState.updateDifficultyState(world);
                tickScheduler.tick();
            };
            ServerPlayConnectionEvents.JOIN.register((Object)joinEventListener);
            ServerTickEvents.END_SERVER_TICK.register((Object)listener);
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            waterRemovalScheduler.removeWorld(world);
            registeredListeners.remove(world);
            registeredJoinEventListeners.remove(world);
        });
    }

    private void checkMummyBossAchievement(class_3218 world) {
        if (++this.achievementTickCounter % 20 != 0) {
            return;
        }
        if (world.method_18456().isEmpty()) {
            return;
        }
        List mummyBosses = world.method_18198(ModEntities.MUMMY_BOSS, entity -> true);
        if (mummyBosses.isEmpty()) {
            return;
        }
        for (class_3222 player : world.method_18456()) {
            boolean isNearby;
            if (this.playersWithAchievement.contains(player.method_5667()) || !(isNearby = mummyBosses.stream().anyMatch(mummy -> player.method_5649(mummy.method_23317(), mummy.method_23318(), mummy.method_23321()) <= 225.0))) continue;
            this.triggerAdvancement(player);
            this.playersWithAchievement.add(player.method_5667());
        }
    }

    public static TickScheduler getTickScheduler() {
        return tickScheduler;
    }

    public static WaterRemovalScheduler getWaterRemovalScheduler() {
        return waterRemovalScheduler;
    }

    private void triggerAdvancement(class_3222 player) {
        class_167 progress;
        class_161 advancement = player.method_5682().method_3851().method_12896(ADVANCEMENT_ID);
        if (advancement != null && !(progress = player.method_14236().method_12882(advancement)).method_740()) {
            player.method_14236().method_12878(advancement, "see_mummy_boss");
        }
    }
}

