/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.dwarven.dwarven_centurion;

import java.util.EnumSet;
import java.util.Objects;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerCenturionEntity;
import net.mebahel.antiquebeasts.entity.custom.dwemer.DwemerEntity;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import software.bernie.geckolib.util.ClientUtils;

public class DwarvenCenturionMeleeAttackGoal
extends class_1352 {
    protected final DwemerCenturionEntity mob;
    private final double speed;
    private String attackName;
    private int max_cooldown;
    private final int attackDistance;
    public int cooldown;
    double rand;

    public DwarvenCenturionMeleeAttackGoal(DwemerCenturionEntity mob, double speed, int max_cooldown, int attackDistance) {
        this.mob = mob;
        this.speed = speed;
        this.max_cooldown = max_cooldown;
        this.attackDistance = attackDistance;
        this.cooldown = this.max_cooldown + 1;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.attackName = this.mob.getAttackName();
    }

    public boolean method_6264() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() && !this.mob.isShooting();
    }

    public boolean method_6266() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() && !this.mob.isShooting();
    }

    public void method_6269() {
        this.rand = Math.random();
        if (this.rand <= 0.6 && this.rand > 0.3) {
            this.attackName = "attack";
            this.max_cooldown = 24;
        } else if (this.rand <= 0.3) {
            this.attackName = "attack2";
            this.max_cooldown = 39;
        } else {
            this.attackName = "power_attack";
            this.max_cooldown = 30;
        }
        this.mob.method_19540(true);
    }

    public void method_6270() {
        this.mob.method_19540(false);
        this.mob.setSwinging(false);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity != null && livingEntity.method_5805()) {
            this.mob.method_5988().method_6226((class_1297)livingEntity, 15.0f, 15.0f);
            if (Objects.equals(this.attackName, "attack")) {
                this.attack(livingEntity);
            } else if (Objects.equals(this.attackName, "attack2")) {
                this.attack2(livingEntity);
            } else {
                this.powerAttack(livingEntity);
            }
            this.mob.setAttackName(this.attackName);
        }
    }

    protected void attack(class_1309 target) {
        double squaredDistance = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        double d = this.getSquaredMaxAttackDistance();
        this.cooldown = Math.max(this.cooldown - 1, 0);
        class_11 path = this.mob.method_5942().method_6349((class_1297)target, this.attackDistance);
        this.mob.method_5942().method_6334(path, this.speed);
        if (this.cooldown == 0) {
            this.rand = Math.random();
            if (this.rand <= 0.6 && this.rand > 0.3) {
                this.attackName = "attack";
                this.max_cooldown = 24;
            } else if (this.rand <= 0.3) {
                this.attackName = "attack2";
                this.max_cooldown = 39;
            } else {
                this.attackName = "power_attack";
                this.max_cooldown = 30;
            }
            this.cooldown = this.max_cooldown + 8;
            this.mob.setSwinging(false);
        }
        if (squaredDistance <= d && this.cooldown == this.max_cooldown) {
            this.mob.setSwinging(true);
        } else if (squaredDistance <= d + 1.0 && this.cooldown == 10 && this.mob.isSwinging()) {
            this.mob.method_6121((class_1297)target);
            this.dealAreaDamage(target, 4.0f);
        } else if (squaredDistance <= d && this.cooldown == this.max_cooldown - 4) {
            class_1657 player;
            if (this.mob.method_37908().method_8608() && (player = ClientUtils.getClientPlayer()) != null && Objects.equals(this.attackName, "attack")) {
                this.mob.method_37908().method_43128(player, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), ModSounds.DWARVEN_CENTURION_ATTACK_1, this.mob.method_5634(), 0.5f, 1.0f);
            }
        } else if (squaredDistance > d + 1.0) {
            this.cooldown = this.max_cooldown + 6;
            this.mob.setSwinging(false);
        }
    }

    protected void attack2(class_1309 target) {
        double squaredDistance = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        double d = this.getSquaredMaxAttackDistance();
        this.cooldown = Math.max(this.cooldown - 1, 0);
        this.mob.method_5942().method_6335((class_1297)target, this.speed);
        if (this.cooldown == 0) {
            this.rand = Math.random();
            if (this.rand <= 0.6 && this.rand > 0.3) {
                this.attackName = "attack";
                this.max_cooldown = 24;
            } else if (this.rand <= 0.3) {
                this.attackName = "attack2";
                this.max_cooldown = 39;
            } else {
                this.attackName = "power_attack";
                this.max_cooldown = 30;
            }
            this.cooldown = this.max_cooldown + 8;
            this.mob.setSwinging(false);
        }
        if (squaredDistance <= d && this.cooldown == this.max_cooldown) {
            this.mob.setSwinging(true);
        } else if (squaredDistance <= d + 1.0 && (this.cooldown == 22 || this.cooldown == 9) && this.mob.isSwinging()) {
            this.mob.method_6121((class_1297)target);
            this.dealAreaDamage(target, 4.0f);
        } else if (squaredDistance <= d && this.cooldown == this.max_cooldown - 4) {
            class_1657 player;
            if (this.mob.method_37908().method_8608() && (player = ClientUtils.getClientPlayer()) != null && Objects.equals(this.attackName, "attack2")) {
                this.mob.method_37908().method_43128(player, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), ModSounds.DWARVEN_CENTURION_ATTACK_2, this.mob.method_5634(), 0.5f, 1.0f);
            }
        } else if (squaredDistance > d + 1.0) {
            this.cooldown = this.max_cooldown + 6;
            this.mob.setSwinging(false);
        }
    }

    protected void powerAttack(class_1309 target) {
        double squaredDistance = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        double d = this.getSquaredMaxAttackDistance();
        this.cooldown = Math.max(this.cooldown - 1, 0);
        class_11 path = this.mob.method_5942().method_6349((class_1297)target, this.attackDistance);
        this.mob.method_5942().method_6334(path, this.speed);
        if (this.cooldown == 0) {
            this.rand = Math.random();
            if (this.rand <= 0.6 && this.rand > 0.3) {
                this.attackName = "attack";
                this.max_cooldown = 24;
            } else if (this.rand <= 0.3) {
                this.attackName = "attack2";
                this.max_cooldown = 39;
            } else {
                this.attackName = "power_attack";
                this.max_cooldown = 30;
            }
            this.cooldown = this.max_cooldown + 8;
            this.mob.setSwinging(false);
        }
        if (squaredDistance <= d && this.cooldown == this.max_cooldown) {
            this.mob.setSwinging(true);
        } else if (squaredDistance <= d + 1.0 && this.cooldown == 10 && this.mob.isSwinging()) {
            this.mob.method_6121((class_1297)target);
            this.dealAreaDamage(target, 8.0f);
            this.breakShield(target);
        } else if (squaredDistance <= d && this.cooldown == this.max_cooldown - 8) {
            class_1657 player;
            if (this.mob.method_37908().method_8608() && (player = ClientUtils.getClientPlayer()) != null && Objects.equals(this.attackName, "power_attack")) {
                this.mob.method_37908().method_43128(player, this.mob.method_23317(), this.mob.method_23318(), this.mob.method_23321(), ModSounds.DWARVEN_CENTURION_POWER_ATTACK, this.mob.method_5634(), 0.5f, 1.0f);
            }
        } else if (squaredDistance > d + 1.0) {
            this.cooldown = this.max_cooldown + 6;
            this.mob.setSwinging(false);
        }
    }

    private void breakShield(class_1309 target) {
        class_1799 activeItem;
        class_1657 player;
        if (target instanceof class_1657 && (player = (class_1657)target).method_6039() && (activeItem = player.method_6030()).method_7909() instanceof class_1819) {
            player.method_7357().method_7906(activeItem.method_7909(), 100);
            player.method_37908().method_8421((class_1297)player, (byte)30);
            player.method_6021();
        }
    }

    protected double getSquaredMaxAttackDistance() {
        return 11.0;
    }

    private void dealAreaDamage(class_1309 primaryTarget, float areaDamage) {
        this.mob.method_37908().method_8333((class_1297)this.mob, primaryTarget.method_5829().method_1014(1.0), e -> {
            class_1309 entity;
            return e instanceof class_1309 && !((entity = (class_1309)e) instanceof DwemerEntity) && entity != primaryTarget && entity.method_5805() && this.mob.method_6057((class_1297)entity);
        }).forEach(entity -> {
            entity.field_6008 = 0;
            entity.method_5643(this.mob.method_48923().method_48812((class_1309)this.mob), areaDamage);
        });
    }
}

