/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.mummy_boss;

import java.util.EnumSet;
import java.util.List;
import net.mebahel.antiquebeasts.entity.custom.egyptian.EgyptianCaravanEntity;
import net.mebahel.antiquebeasts.entity.custom.egyptian.MummyBossEntity;
import net.mebahel.antiquebeasts.entity.custom.patrol.ModPatrolEntity;
import net.mebahel.antiquebeasts.item.CustomShieldItem;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class MummyBossMeleeAttackGoal
extends class_1352 {
    protected final MummyBossEntity mob;
    private final double speed;
    private final double attackRange;
    private final int attackDistance;
    private final int attackMoment;
    private static final int MAX_COOLDOWN = 21;
    public int cooldown;
    private long lastUpdateTime;
    double rand;

    public MummyBossMeleeAttackGoal(MummyBossEntity mob, double speed, double attackRange, int attackDistance, int attackMoment) {
        this.mob = mob;
        this.speed = speed;
        this.attackRange = attackRange;
        this.attackDistance = attackDistance;
        this.attackMoment = attackMoment;
        this.cooldown = 29;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        long l = this.mob.method_37908().method_8510();
        if (this.mob.getSpawn()) {
            return false;
        }
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805()) {
            return false;
        }
        class_11 path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
        if (path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance() >= this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
    }

    public boolean method_6266() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805() || this.mob.getSpawn() || this.mob.getSpawnCooldown() < 40 || this.mob.getCooldown() < 40 || !this.mob.inTransitionPhase;
    }

    public void method_6269() {
        this.mob.method_19540(true);
        MummyBossEntity patrolEntity = this.mob;
        class_1309 target = this.mob.method_5968();
        List patrolMembers = patrolEntity.method_37908().method_8390(ModPatrolEntity.class, patrolEntity.method_5829().method_1014(32.0), e -> e.isPartOfSamePatrol(patrolEntity) && e.isPatrolling());
        for (ModPatrolEntity member : patrolMembers) {
            if (member instanceof EgyptianCaravanEntity || !member.isPatrolling()) continue;
            member.setPatrolling(false);
            member.method_5980(target);
        }
    }

    public void method_6270() {
        this.mob.method_19540(false);
        this.mob.setSwinging(false);
        MummyBossEntity patrolEntity = this.mob;
        if (patrolEntity.wasInitiallyInPatrol()) {
            patrolEntity.checkAndResumePatrolling();
        }
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity != null && livingEntity.method_5805()) {
            this.mob.method_5988().method_6226((class_1297)livingEntity, 15.0f, 15.0f);
            this.attack(livingEntity);
        } else {
            this.method_6270();
        }
    }

    protected void attack(class_1309 target) {
        double squaredDistance = this.mob.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
        double d = this.getSquaredMaxAttackDistance();
        this.cooldown = Math.max(this.cooldown - 1, 0);
        if (this.mob.secondPhase) {
            this.mob.method_5942().method_6335((class_1297)target, this.speed / 1.5);
        } else {
            this.mob.method_5942().method_6335((class_1297)target, this.speed);
        }
        if (this.cooldown == 0) {
            this.cooldown = 23;
            this.mob.setSwinging(false);
        } else if (squaredDistance <= d && this.cooldown == 20) {
            this.mob.setSwinging(true);
        } else if (squaredDistance <= d + 1.0 && this.cooldown == 10 && this.mob.isSwinging()) {
            if (this.mob.secondPhase || this.mob.thirdPhase) {
                this.performAreaAttack();
            } else {
                this.mob.method_6121((class_1297)target);
            }
        }
    }

    private void performAreaAttack() {
        double attackRange = 4.0;
        double attackAngle = Math.toRadians(90.0);
        class_243 bossPos = this.mob.method_19538();
        class_243 bossLookVec = this.mob.method_5828(1.0f);
        class_238 attackBox = this.mob.method_5829().method_1009(attackRange, 1.0, attackRange);
        List entities = this.mob.method_37908().method_8390(class_1309.class, attackBox, entity -> entity != this.mob);
        for (class_1309 entity2 : entities) {
            class_243 toEntityVec = entity2.method_19538().method_1020(bossPos).method_1029();
            double angle = bossLookVec.method_1026(toEntityVec);
            if (!(angle > Math.cos(attackAngle / 2.0))) continue;
            this.breakShield(entity2);
            entity2.method_5643(this.mob.method_37908().method_48963().method_48812((class_1309)this.mob), 10.0f);
        }
    }

    private void breakShield(class_1309 target) {
        class_1799 activeItem;
        class_1657 player;
        if (target instanceof class_1657 && (player = (class_1657)target).method_6039() && (activeItem = player.method_6030()).method_7909() instanceof class_1819) {
            activeItem.method_7956(1, (class_1309)player, p -> p.method_20236(player.method_6058()));
            if (!(activeItem.method_7909() instanceof CustomShieldItem)) {
                player.method_7284(true);
            }
        }
    }

    protected double getSquaredMaxAttackDistance() {
        return 10.0;
    }
}

