/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.entity.ai.other;

import java.util.EnumSet;
import net.mebahel.antiquebeasts.entity.custom.other.HarpyEntity;
import net.mebahel.antiquebeasts.entity.projectiles.HarpyFeatherEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class HarpyRangedAttackGoal
extends class_1352 {
    private final HarpyEntity harpy;
    private final double speed;
    private final double circleRadius;
    private final class_1937 world;
    private double circlingAngle;
    private final int minAltitude;
    private final int maxAltitude;
    private class_243 circlingPosition;

    public HarpyRangedAttackGoal(HarpyEntity harpy, double speed, double circleRadius, int attackInterval, int minAltitude, int maxAltitude) {
        this.harpy = harpy;
        this.speed = speed;
        this.circleRadius = circleRadius;
        this.minAltitude = minAltitude;
        this.maxAltitude = maxAltitude;
        this.world = harpy.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.circlingAngle = 0.0;
    }

    public boolean method_6264() {
        class_1309 potentialTarget = this.harpy.method_5968();
        return potentialTarget != null && potentialTarget.method_5805();
    }

    public void method_6269() {
        this.harpy.setFireBreathingCooldown(51.0f);
        this.circlingPosition = null;
        this.circlingAngle = 0.0;
    }

    public boolean method_6266() {
        class_1657 playerEntity;
        class_1309 livingEntity = this.harpy.method_5968();
        if (livingEntity instanceof class_1657 && ((playerEntity = (class_1657)livingEntity).method_7337() || playerEntity.method_7325())) {
            return false;
        }
        return livingEntity != null && livingEntity.method_5805();
    }

    public void method_6270() {
        this.harpy.setFireBreathing(false);
        this.harpy.setFireBreathingCooldown(51.0f);
        this.circlingPosition = null;
    }

    public void method_6268() {
        class_1309 target = this.harpy.method_5968();
        if (target != null) {
            double distanceToTarget = this.harpy.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
            this.circlingAngle += 0.05;
            double offsetX = Math.cos(this.circlingAngle) * this.circleRadius;
            double offsetZ = Math.sin(this.circlingAngle) * this.circleRadius;
            double heightOffset = this.calculateHeightOffset(target);
            this.circlingPosition = new class_243(target.method_23317() + offsetX, target.method_23318() + heightOffset, target.method_23321() + offsetZ);
            class_243 direction = this.circlingPosition.method_1020(this.harpy.method_19538()).method_1029();
            this.harpy.method_18799(direction.method_1021(this.speed));
            if (this.harpy.isFireBreathing()) {
                this.harpy.method_18799(class_243.field_1353);
            }
            this.rotateTowardsTarget(target);
            this.avoidObstacles();
            if (this.harpy.method_6057((class_1297)target)) {
                this.harpy.setFireBreathingCooldown(Math.max(this.harpy.getFireBreathingCooldown() - 1.0f, 0.0f));
                if (this.harpy.getFireBreathingCooldown() == 5.0f) {
                    this.shootArrow(target);
                } else if (this.harpy.getFireBreathingCooldown() == 10.0f) {
                    this.harpy.setFireBreathing(true);
                } else if (this.harpy.getFireBreathingCooldown() == 0.0f) {
                    this.harpy.setFireBreathingCooldown(50.0f);
                    this.harpy.setFireBreathing(false);
                }
            } else {
                this.harpy.setFireBreathing(false);
                this.harpy.setFireBreathingCooldown(51.0f);
            }
        }
    }

    private void rotateTowardsTarget(class_1309 target) {
        class_243 targetPos = target.method_19538();
        class_243 harpyPos = this.harpy.method_19538();
        double dx = targetPos.field_1352 - harpyPos.field_1352;
        double dz = targetPos.field_1350 - harpyPos.field_1350;
        double targetYaw = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
        this.harpy.method_36456(this.lerpRotation(this.harpy.method_36454(), (float)targetYaw, 30.0f));
    }

    private float lerpRotation(float currentYaw, float targetYaw, float maxTurnSpeed) {
        float deltaYaw = class_3532.method_15393((float)(targetYaw - currentYaw));
        return currentYaw + class_3532.method_15363((float)deltaYaw, (float)(-maxTurnSpeed), (float)maxTurnSpeed);
    }

    private void avoidObstacles() {
        class_243 currentPos = this.harpy.method_19538();
        class_2338 blockPosAhead = class_2338.method_49638((class_2374)currentPos.method_1019(this.harpy.method_18798().method_1029().method_1021(2.0)));
        if (!this.world.method_22347(blockPosAhead)) {
            this.harpy.method_18799(this.harpy.method_18798().method_1031(0.0, 0.5, 0.0));
        }
    }

    private double calculateHeightOffset(class_1309 target) {
        double currentAltitude = this.harpy.method_23318();
        double targetAltitude = target.method_23318();
        double targetHeight = targetAltitude + (double)this.minAltitude + Math.random() * (double)(this.maxAltitude - this.minAltitude);
        return targetHeight - currentAltitude;
    }

    private void shootArrow(class_1309 target) {
        class_243 harpyPos = this.harpy.method_19538();
        class_243 targetPos = target.method_19538();
        this.shootSingleArrow(target, harpyPos, targetPos, 0.0);
        int extraPlumes = 1 + this.world.field_9229.method_43048(2);
        for (int i = 0; i < extraPlumes; ++i) {
            double angleOffset = i == 0 ? -10 : 10;
            this.shootSingleArrow(target, harpyPos, targetPos, angleOffset);
        }
    }

    private void shootSingleArrow(class_1309 target, class_243 harpyPos, class_243 targetPos, double angleOffset) {
        HarpyFeatherEntity arrow = new HarpyFeatherEntity(this.world, (class_1309)this.harpy, 6.0f);
        double dx = targetPos.field_1352 - harpyPos.field_1352;
        double dy = targetPos.field_1351 + (double)target.method_5751() - (harpyPos.field_1351 + 1.5);
        double dz = targetPos.field_1350 - harpyPos.field_1350;
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float velocity = 1.35f;
        float gravity = 0.05f;
        double angleInRadians = Math.toRadians(angleOffset);
        double adjustedDx = Math.cos(angleInRadians) * dx - Math.sin(angleInRadians) * dz;
        double adjustedDz = Math.sin(angleInRadians) * dx + Math.cos(angleInRadians) * dz;
        arrow.method_7485(adjustedDx, dy + (double)gravity * distanceXZ / (double)velocity, adjustedDz, velocity, 1.0f);
        arrow.method_5814(harpyPos.method_10216(), harpyPos.method_10214() + 1.5, harpyPos.method_10215());
        this.world.method_8649((class_1297)arrow);
    }
}

