/*
 * Decompiled with CFR 0.152.
 */
package net.mebahel.antiquebeasts.util.raid;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.mebahel.antiquebeasts.AntiqueBeasts;
import net.mebahel.antiquebeasts.block.ModBlocks;
import net.mebahel.antiquebeasts.block.entity.DraugrChestBlockEntity;
import net.mebahel.antiquebeasts.entity.custom.other.DraugrEntity;
import net.mebahel.antiquebeasts.sound.ModSounds;
import net.mebahel.antiquebeasts.util.raid.DraugrRaidHelper;
import net.mebahel.antiquebeasts.util.raid.PersistentRaidData;
import net.mebahel.antiquebeasts.util.raid.RaidState;
import net.mebahel.antiquebeasts.util.raid.RaidStateManager;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class DraugrRaidTest {
    private boolean rewardChestSpawned = false;
    private class_2338 chestPos;
    private class_3218 world;
    int currentWave = 1;
    int draugrKilledInWave = 0;
    private static final int MAX_WAVES = 3;
    private static int NUMBER_OF_WAVES = 3;
    class_2338 centralPos;
    private class_1657 targetPlayer;
    float initialMaxHealth;
    public boolean raidInProgress;
    boolean waveEntitiesSpawned;
    private class_3213 raidBossBar;
    List<DraugrEntity> activeMobs;
    public List<UUID> raidEntityUuid;
    public UUID raidUuid = UUID.randomUUID();
    UUID targetPlayerUuid;
    boolean raidCompleted = false;

    public DraugrRaidTest(class_1657 player, class_3218 world) {
        this.raidEntityUuid = new ArrayList<UUID>();
        this.world = world;
        this.targetPlayer = player;
        this.currentWave = 0;
        this.targetPlayerUuid = player.method_5667();
        this.waveEntitiesSpawned = false;
        this.activeMobs = new ArrayList<DraugrEntity>();
        this.raidBossBar = new class_3213((class_2561)class_2561.method_43471((String)"Draugr Raid - Wave..."), class_1259.class_1260.field_5786, class_1259.class_1261.field_5791);
        this.raidInProgress = false;
        this.raidBossBar.method_14088((class_3222)this.targetPlayer);
        this.raidBossBar.method_5413((class_2561)class_2561.method_43471((String)("Draugr Raid - Wave " + this.currentWave)));
        this.registerEvents();
    }

    public boolean isRaidInProgress() {
        return this.raidInProgress;
    }

    public boolean isRaidCompleted() {
        return this.raidCompleted;
    }

    public void setTargetPlayer(class_1657 player) {
        this.targetPlayer = player;
    }

    public void startRaid() {
        this.raidInProgress = true;
        if (AntiqueBeasts.worldDifficultyLevels.getOrDefault(this.world, 1) == 2) {
            NUMBER_OF_WAVES = 4;
        }
        this.spawnNextWave();
    }

    void registerEvents() {
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, source) -> {
            DraugrEntity draugr;
            if (entity instanceof DraugrEntity && (draugr = (DraugrEntity)entity).isPartOfRaid()) {
                this.setWorld((class_3218)entity.method_37908());
                this.activeMobs.removeIf(draugrEntity -> !draugrEntity.method_5805());
                this.updateRaidHealthBar();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(serverTick -> {
            class_3218 serverWorld = serverTick.method_30002();
            if (serverWorld.method_8407().method_5461() == 0) {
                DraugrRaidTest.stopAllRaids();
                return;
            }
            if (!this.raidInProgress || this.raidCompleted) {
                return;
            }
            if (AntiqueBeasts.ongoingRaids.stream().noneMatch(raid -> raid.raidUuid.equals(this.raidUuid))) {
                AntiqueBeasts.ongoingRaids.add(this);
            }
            if (this.raidBossBar.method_14092().isEmpty()) {
                this.updateBossBarForPlayers(serverWorld);
            }
            this.updateBossBarProximity(serverWorld);
        });
    }

    private static void stopAllRaids() {
        for (DraugrRaidTest raid : new ArrayList<DraugrRaidTest>(AntiqueBeasts.ongoingRaids)) {
            raid.endRaid();
        }
        AntiqueBeasts.ongoingRaids.clear();
    }

    private void updateBossBarForPlayers(class_3218 world) {
        List playersInWorld = world.method_18456();
        for (class_3222 player : playersInWorld) {
            if (this.raidBossBar.method_14092().contains(player)) continue;
            this.raidBossBar.method_14088(player);
        }
    }

    private void updateBossBarProximity(class_3218 world) {
        List playersInWorld = world.method_18456();
        ArrayList playersInBossBar = new ArrayList(this.raidBossBar.method_14092());
        this.activeMobs.clear();
        float totalHealth = 0.0f;
        for (UUID uuid : this.raidEntityUuid) {
            DraugrEntity draugr = this.findDraugrByUUID(world, uuid);
            if (draugr == null || !draugr.method_5805()) continue;
            this.activeMobs.add(draugr);
            totalHealth += draugr.method_6032();
        }
        this.raidBossBar.method_5408(totalHealth / this.initialMaxHealth);
        this.raidBossBar.method_5413((class_2561)class_2561.method_43471((String)("Draugr Raid - Wave " + this.currentWave)));
        for (class_3222 player : playersInWorld) {
            boolean isWithinRange = false;
            for (UUID entityUuid : this.raidEntityUuid) {
                double distanceSquared;
                DraugrEntity draugr = this.findDraugrByUUID(world, entityUuid);
                if (draugr == null || !draugr.method_5805() || !((distanceSquared = player.method_5649(draugr.method_23317(), draugr.method_23318(), draugr.method_23321())) <= 1600.0)) continue;
                isWithinRange = true;
                break;
            }
            if (isWithinRange) {
                if (!this.raidBossBar.method_14092().contains(player)) {
                    this.raidBossBar.method_14088(player);
                }
            } else if (this.raidBossBar.method_14092().contains(player)) {
                this.raidBossBar.method_14089(player);
            }
            playersInBossBar.remove(player);
        }
        for (class_3222 playerToRemove : playersInBossBar) {
            this.raidBossBar.method_14089(playerToRemove);
        }
    }

    public void setWorld(class_3218 world) {
        this.world = world;
    }

    public UUID getTargetPlayerUuid() {
        return this.targetPlayerUuid;
    }

    public DraugrEntity findDraugrByUUID(class_3218 world, UUID uuid) {
        class_1297 entity = world.method_14190(uuid);
        if (entity instanceof DraugrEntity) {
            return (DraugrEntity)entity;
        }
        return null;
    }

    private void spawnNextWave() {
        if (this.currentWave >= NUMBER_OF_WAVES) {
            this.endRaid();
            return;
        }
        this.waveEntitiesSpawned = false;
        ++this.currentWave;
        this.raidBossBar.method_5413((class_2561)class_2561.method_43471((String)("Draugr Raid - Wave " + this.currentWave)));
        Random random = new Random();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = 15.0 + random.nextDouble() * 10.0;
        this.centralPos = new class_2338((int)(this.targetPlayer.method_23317() + Math.cos(angle) * distance), (int)this.targetPlayer.method_23318(), (int)(this.targetPlayer.method_23321() + Math.sin(angle) * distance));
        AntiqueBeasts.getTickScheduler().schedule(this.world, 20, this::spawnLightning);
        AntiqueBeasts.getTickScheduler().schedule(this.world, 30, this::spawnWaveMobs);
    }

    public void updateRaidHealthBar() {
        if (!this.waveEntitiesSpawned || this.raidBossBar == null) {
            return;
        }
        float totalHealth = 0.0f;
        this.activeMobs.clear();
        for (UUID uuid : this.raidEntityUuid) {
            DraugrEntity draugr = this.findDraugrByUUID(this.world, uuid);
            if (draugr == null || !draugr.method_5805()) continue;
            this.activeMobs.add(draugr);
            totalHealth += draugr.method_6032();
        }
        if (totalHealth > 0.0f) {
            this.raidBossBar.method_5408(totalHealth / this.initialMaxHealth);
            this.raidBossBar.method_5413((class_2561)class_2561.method_43471((String)("Draugr Raid - Wave " + this.currentWave)));
        } else {
            this.raidBossBar.method_5408(0.0f);
            if (this.currentWave >= 3) {
                if (!this.rewardChestSpawned) {
                    this.spawnRewardChest();
                    this.rewardChestSpawned = true;
                }
                this.endRaid();
            } else {
                this.waveEntitiesSpawned = false;
                this.spawnNextWave();
            }
        }
    }

    public void endRaid() {
        this.raidBossBar.method_14089((class_3222)this.targetPlayer);
        this.raidBossBar.method_14091(false);
        this.raidCompleted = true;
        this.raidInProgress = false;
        this.removeRaid();
        AntiqueBeasts.ongoingRaids.remove(this);
    }

    public void saveRaid() {
        PersistentRaidData data = PersistentRaidData.get(this.world);
        if (data != null) {
            data.addRaidByUuid(this.raidUuid, this);
            data.method_80();
        }
    }

    public void removeRaid() {
        PersistentRaidData data = PersistentRaidData.get(this.world);
        if (data != null) {
            data.removeRaidByRaid(this);
            data.method_80();
        }
    }

    public class_2487 writeNbt(class_2487 nbt) {
        if (this.raidCompleted) {
            return new class_2487();
        }
        nbt.method_10569("currentWave", this.currentWave);
        nbt.method_10548("initialMaxHealth", this.initialMaxHealth);
        nbt.method_10569("draugrKilledInWave", this.draugrKilledInWave);
        nbt.method_10582("raidUuid", this.raidUuid.toString());
        nbt.method_25927("targetPlayerUuid", this.targetPlayer.method_5667());
        nbt.method_10556("raidCompleted", this.raidCompleted);
        nbt.method_10556("raidInProgress", this.raidInProgress);
        nbt.method_10556("waveEntitiesSpawned", this.waveEntitiesSpawned);
        nbt.method_10556("rewardChestSpawned", this.rewardChestSpawned);
        if (this.centralPos != null) {
            nbt.method_10569("centralPosX", this.centralPos.method_10263());
            nbt.method_10569("centralPosY", this.centralPos.method_10264());
            nbt.method_10569("centralPosZ", this.centralPos.method_10260());
        }
        class_2499 uuidList = new class_2499();
        for (UUID uuid : this.raidEntityUuid) {
            class_2487 uuidCompound = new class_2487();
            uuidCompound.method_25927("UUID", uuid);
            uuidList.add((Object)uuidCompound);
        }
        nbt.method_10566("raidEntityUuid", (class_2520)uuidList);
        class_2499 activeMobsList = new class_2499();
        for (DraugrEntity draugr : this.activeMobs) {
            if (draugr == null) continue;
            class_2487 draugrCompound = new class_2487();
            draugr.method_5786(draugrCompound);
            activeMobsList.add((Object)draugrCompound);
        }
        nbt.method_10566("activeMobs", (class_2520)activeMobsList);
        return nbt;
    }

    public static DraugrRaidTest fromNbt(class_2487 nbt, class_3218 world) {
        UUID playerUuid = nbt.method_25926("targetPlayerUuid");
        class_1657 player = world.method_18470(playerUuid);
        if (player == null) {
            player = (class_1657)world.method_18456().get(0);
        }
        DraugrRaidTest raid = new DraugrRaidTest(player, world);
        raid.raidUuid = UUID.fromString(nbt.method_10558("raidUuid"));
        raid.currentWave = nbt.method_10550("currentWave");
        raid.draugrKilledInWave = nbt.method_10550("draugrKilledInWave");
        raid.raidInProgress = nbt.method_10577("raidInProgress");
        raid.raidCompleted = nbt.method_10577("raidCompleted");
        raid.initialMaxHealth = nbt.method_10583("initialMaxHealth");
        raid.waveEntitiesSpawned = nbt.method_10577("waveEntitiesSpawned");
        raid.rewardChestSpawned = nbt.method_10577("rewardChestSpawned");
        if (nbt.method_10545("centralPosX") && nbt.method_10545("centralPosY") && nbt.method_10545("centralPosZ")) {
            raid.centralPos = new class_2338(nbt.method_10550("centralPosX"), nbt.method_10550("centralPosY"), nbt.method_10550("centralPosZ"));
        }
        class_2499 uuidList = nbt.method_10554("raidEntityUuid", 10);
        for (int i = 0; i < uuidList.size(); ++i) {
            class_2487 uuidCompound = uuidList.method_10602(i);
            raid.raidEntityUuid.add(uuidCompound.method_25926("UUID"));
        }
        for (UUID uuid : raid.raidEntityUuid) {
            DraugrEntity draugr = raid.findDraugrByUUID(world, uuid);
            if (draugr == null || raid.activeMobs.contains((Object)draugr)) continue;
            raid.activeMobs.add(draugr);
        }
        return raid;
    }

    public class_3218 getWorld() {
        return this.world;
    }

    private void spawnRewardChest() {
        if (!this.world.field_9236) {
            class_2338 playerPos = this.targetPlayer.method_24515();
            class_2350 playerFacing = this.targetPlayer.method_5735();
            this.chestPos = playerPos.method_10081(playerFacing.method_10163().method_35862(2));
            while (this.world.method_22347(this.chestPos.method_10074()) && this.chestPos.method_10264() > 0) {
                this.chestPos = this.chestPos.method_10074();
            }
            this.world.method_8501(this.chestPos, ModBlocks.DRAUGR_CHEST.method_9564());
            class_2586 blockEntity = this.world.method_8321(this.chestPos);
            if (blockEntity instanceof DraugrChestBlockEntity) {
                DraugrChestBlockEntity draugrChest = (DraugrChestBlockEntity)blockEntity;
                draugrChest.method_11285(new class_2960("antiquebeasts", "chests/raid/draugr_raid"), this.world.method_8409().method_43055());
                draugrChest.setShouldDoSpawnAnimation(true);
                System.out.println("[DEBUG] Chest spawn animation activated: " + draugrChest.shouldDoSpawnAnimation);
            }
            AntiqueBeasts.getTickScheduler().schedule(this.world, 15, this::enRaidSound);
        }
    }

    private void enRaidSound(class_3218 world) {
        world.method_8396(null, this.chestPos, ModSounds.WINNING_RAID_1, this.targetPlayer.method_5634(), 0.55f, 1.0f);
    }

    private void spawnLightning(class_3218 world) {
        for (int i = 0; i < 1; ++i) {
            class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)world);
            lightning.method_23327((double)this.centralPos.method_10263(), (double)this.centralPos.method_10264(), (double)this.centralPos.method_10260());
            world.method_8649((class_1297)lightning);
        }
    }

    private void spawnWaveMobs(class_3218 world) {
        int difficultyLevel = AntiqueBeasts.worldDifficultyLevels.getOrDefault(world, 1);
        this.activeMobs.clear();
        this.raidEntityUuid.clear();
        Random random = new Random();
        int mobsToSpawn = 1 + this.currentWave * 2 + difficultyLevel * 2;
        this.initialMaxHealth = 0.0f;
        for (int i = 0; i < mobsToSpawn; ++i) {
            double xOffset = random.nextDouble() * 20.0 - 10.0;
            double zOffset = random.nextDouble() * 20.0 - 10.0;
            class_2338 spawnPos = this.centralPos.method_10069((int)xOffset, 0, (int)zOffset);
            spawnPos = DraugrRaidHelper.findGroundPosition(world, spawnPos);
            class_1299 entityType = DraugrRaidHelper.chooseEntityType(random, this.currentWave, difficultyLevel);
            DraugrEntity draugr = (DraugrEntity)entityType.method_5883((class_1937)world);
            if (draugr == null) continue;
            draugr.method_5808(spawnPos.method_10263(), spawnPos.method_10264(), spawnPos.method_10260(), random.nextFloat() * 360.0f, 0.0f);
            draugr.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16467, null, null);
            draugr.method_5841().method_12778(DraugrEntity.IS_PART_OF_RAID, (Object)true);
            draugr.setHasSpawned(false);
            this.activeMobs.add(draugr);
            world.method_8649((class_1297)draugr);
            draugr.method_5980((class_1309)this.targetPlayer);
            this.raidEntityUuid.add(draugr.method_5667());
            this.initialMaxHealth += (float)draugr.method_26825(class_5134.field_23716);
        }
        if (this.currentWave == NUMBER_OF_WAVES) {
            double xOffset = random.nextDouble() * 10.0 - 5.0;
            double zOffset = random.nextDouble() * 10.0 - 5.0;
            class_2338 overlordPos = this.centralPos.method_10069((int)xOffset, 0, (int)zOffset);
            overlordPos = DraugrRaidHelper.findGroundPosition(world, overlordPos);
            DraugrEntity overlord = (DraugrEntity)((class_1299)class_1299.method_5898((String)"antiquebeasts:draugr_overlord").get()).method_5883((class_1937)world);
            if (overlord != null) {
                overlord.method_5808(overlordPos.method_10263(), overlordPos.method_10264(), overlordPos.method_10260(), random.nextFloat() * 360.0f, 0.0f);
                overlord.method_5943((class_5425)world, world.method_8404(overlordPos), class_3730.field_16467, null, null);
                overlord.method_5841().method_12778(DraugrEntity.IS_PART_OF_RAID, (Object)true);
                overlord.setHasSpawned(false);
                this.activeMobs.add(overlord);
                world.method_8649((class_1297)overlord);
                overlord.method_5980((class_1309)this.targetPlayer);
                this.raidEntityUuid.add(overlord.method_5667());
                this.initialMaxHealth += (float)overlord.method_26825(class_5134.field_23716);
            }
        }
        RaidState raidState = RaidStateManager.getRaidState(world);
        raidState.setActiveMobUUIDs(new ArrayList<UUID>(this.raidEntityUuid));
        raidState.method_80();
        this.waveEntitiesSpawned = true;
        this.updateRaidHealthBar();
        this.saveRaid();
    }
}

