/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.network;

import java.util.function.Supplier;
import net.arphex.ArphexMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ArphexModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ArphexMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ArphexMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ShowOverlay = message.data.ShowOverlay;
                    variables.mothsurvivals = message.data.mothsurvivals;
                    variables.mothtamer = message.data.mothtamer;
                    variables.ShowOverlay2 = message.data.ShowOverlay2;
                    variables.saturationclock = message.data.saturationclock;
                    variables.killedscorpioid = message.data.killedscorpioid;
                    variables.holdingspace = message.data.holdingspace;
                    variables.holdleftclick = message.data.holdleftclick;
                    variables.killedvoidlasher = message.data.killedvoidlasher;
                    variables.ShowOverlay3 = message.data.ShowOverlay3;
                    variables.abyssfly = message.data.abyssfly;
                    variables.doublejumpcool = message.data.doublejumpcool;
                    variables.arphexcompass = message.data.arphexcompass;
                    variables.arphexanglevsyaw = message.data.arphexanglevsyaw;
                    variables.arphextriangx = message.data.arphextriangx;
                    variables.arphextriangz = message.data.arphextriangz;
                    variables.ownedantsnear = message.data.ownedantsnear;
                    variables.tamedants = message.data.tamedants;
                    variables.pocketdimensionx = message.data.pocketdimensionx;
                    variables.shadertime = message.data.shadertime;
                    variables.show_tormentor_overlay = message.data.show_tormentor_overlay;
                    variables.totemfatigue = message.data.totemfatigue;
                    variables.time_in_portal = message.data.time_in_portal;
                    variables.tormentor_respite = message.data.tormentor_respite;
                    variables.recently_attacked_tormentor = message.data.recently_attacked_tormentor;
                    variables.torment_cycle = message.data.torment_cycle;
                    variables.torment_mode = message.data.torment_mode;
                    variables.killedtormentor = message.data.killedtormentor;
                    variables.moth_summon_active = message.data.moth_summon_active;
                    variables.tormentor_summon_active = message.data.tormentor_summon_active;
                    variables.smshealth = message.data.smshealth;
                    variables.tmshealth = message.data.tmshealth;
                    variables.player_dimension = message.data.player_dimension;
                    variables.tormentor_long_range_anim = message.data.tormentor_long_range_anim;
                    variables.player_overlay = message.data.player_overlay;
                    variables.fov_smoothen = message.data.fov_smoothen;
                    variables.overlay_white = message.data.overlay_white;
                    variables.wrath_charge_time = message.data.wrath_charge_time;
                    variables.overlay_black = message.data.overlay_black;
                    variables.sphere_near = message.data.sphere_near;
                    variables.laser_emitter_near = message.data.laser_emitter_near;
                    variables.overlay_red = message.data.overlay_red;
                    variables.tormentor_render = message.data.tormentor_render;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public String ShowOverlay = "\"\"";
        public double mothsurvivals = 0.0;
        public boolean mothtamer = false;
        public String ShowOverlay2 = "\"\"";
        public double saturationclock = 0.0;
        public boolean killedscorpioid = false;
        public boolean holdingspace = false;
        public boolean holdleftclick = false;
        public boolean killedvoidlasher = false;
        public String ShowOverlay3 = "\"\"";
        public boolean abyssfly = false;
        public double doublejumpcool = 0.0;
        public double arphexcompass = 0.0;
        public double arphexanglevsyaw = 0.0;
        public double arphextriangx = 0.0;
        public double arphextriangz = 0.0;
        public double ownedantsnear = 0.0;
        public double tamedants = 0.0;
        public double pocketdimensionx = 0.0;
        public double shadertime = 0.0;
        public boolean show_tormentor_overlay = false;
        public boolean totemfatigue = false;
        public double time_in_portal = 0.0;
        public double tormentor_respite = 0.0;
        public double recently_attacked_tormentor = 0.0;
        public double torment_cycle = 0.0;
        public String torment_mode = "\"\"";
        public double killedtormentor = 0.0;
        public double moth_summon_active = 0.0;
        public double tormentor_summon_active = 0.0;
        public double smshealth = 0.0;
        public double tmshealth = 0.0;
        public String player_dimension = "\"\"";
        public boolean tormentor_long_range_anim = false;
        public boolean player_overlay = false;
        public double fov_smoothen = 0.0;
        public double overlay_white = 0.0;
        public double wrath_charge_time = 0.0;
        public double overlay_black = 0.0;
        public double sphere_near = 0.0;
        public double laser_emitter_near = 0.0;
        public double overlay_red = 0.0;
        public double tormentor_render = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ArphexMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("ShowOverlay", this.ShowOverlay);
            nbt.m_128347_("mothsurvivals", this.mothsurvivals);
            nbt.m_128379_("mothtamer", this.mothtamer);
            nbt.m_128359_("ShowOverlay2", this.ShowOverlay2);
            nbt.m_128347_("saturationclock", this.saturationclock);
            nbt.m_128379_("killedscorpioid", this.killedscorpioid);
            nbt.m_128379_("holdingspace", this.holdingspace);
            nbt.m_128379_("holdleftclick", this.holdleftclick);
            nbt.m_128379_("killedvoidlasher", this.killedvoidlasher);
            nbt.m_128359_("ShowOverlay3", this.ShowOverlay3);
            nbt.m_128379_("abyssfly", this.abyssfly);
            nbt.m_128347_("doublejumpcool", this.doublejumpcool);
            nbt.m_128347_("arphexcompass", this.arphexcompass);
            nbt.m_128347_("arphexanglevsyaw", this.arphexanglevsyaw);
            nbt.m_128347_("arphextriangx", this.arphextriangx);
            nbt.m_128347_("arphextriangz", this.arphextriangz);
            nbt.m_128347_("ownedantsnear", this.ownedantsnear);
            nbt.m_128347_("tamedants", this.tamedants);
            nbt.m_128347_("pocketdimensionx", this.pocketdimensionx);
            nbt.m_128347_("shadertime", this.shadertime);
            nbt.m_128379_("show_tormentor_overlay", this.show_tormentor_overlay);
            nbt.m_128379_("totemfatigue", this.totemfatigue);
            nbt.m_128347_("time_in_portal", this.time_in_portal);
            nbt.m_128347_("tormentor_respite", this.tormentor_respite);
            nbt.m_128347_("recently_attacked_tormentor", this.recently_attacked_tormentor);
            nbt.m_128347_("torment_cycle", this.torment_cycle);
            nbt.m_128359_("torment_mode", this.torment_mode);
            nbt.m_128347_("killedtormentor", this.killedtormentor);
            nbt.m_128347_("moth_summon_active", this.moth_summon_active);
            nbt.m_128347_("tormentor_summon_active", this.tormentor_summon_active);
            nbt.m_128347_("smshealth", this.smshealth);
            nbt.m_128347_("tmshealth", this.tmshealth);
            nbt.m_128359_("player_dimension", this.player_dimension);
            nbt.m_128379_("tormentor_long_range_anim", this.tormentor_long_range_anim);
            nbt.m_128379_("player_overlay", this.player_overlay);
            nbt.m_128347_("fov_smoothen", this.fov_smoothen);
            nbt.m_128347_("overlay_white", this.overlay_white);
            nbt.m_128347_("wrath_charge_time", this.wrath_charge_time);
            nbt.m_128347_("overlay_black", this.overlay_black);
            nbt.m_128347_("sphere_near", this.sphere_near);
            nbt.m_128347_("laser_emitter_near", this.laser_emitter_near);
            nbt.m_128347_("overlay_red", this.overlay_red);
            nbt.m_128347_("tormentor_render", this.tormentor_render);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.ShowOverlay = nbt.m_128461_("ShowOverlay");
            this.mothsurvivals = nbt.m_128459_("mothsurvivals");
            this.mothtamer = nbt.m_128471_("mothtamer");
            this.ShowOverlay2 = nbt.m_128461_("ShowOverlay2");
            this.saturationclock = nbt.m_128459_("saturationclock");
            this.killedscorpioid = nbt.m_128471_("killedscorpioid");
            this.holdingspace = nbt.m_128471_("holdingspace");
            this.holdleftclick = nbt.m_128471_("holdleftclick");
            this.killedvoidlasher = nbt.m_128471_("killedvoidlasher");
            this.ShowOverlay3 = nbt.m_128461_("ShowOverlay3");
            this.abyssfly = nbt.m_128471_("abyssfly");
            this.doublejumpcool = nbt.m_128459_("doublejumpcool");
            this.arphexcompass = nbt.m_128459_("arphexcompass");
            this.arphexanglevsyaw = nbt.m_128459_("arphexanglevsyaw");
            this.arphextriangx = nbt.m_128459_("arphextriangx");
            this.arphextriangz = nbt.m_128459_("arphextriangz");
            this.ownedantsnear = nbt.m_128459_("ownedantsnear");
            this.tamedants = nbt.m_128459_("tamedants");
            this.pocketdimensionx = nbt.m_128459_("pocketdimensionx");
            this.shadertime = nbt.m_128459_("shadertime");
            this.show_tormentor_overlay = nbt.m_128471_("show_tormentor_overlay");
            this.totemfatigue = nbt.m_128471_("totemfatigue");
            this.time_in_portal = nbt.m_128459_("time_in_portal");
            this.tormentor_respite = nbt.m_128459_("tormentor_respite");
            this.recently_attacked_tormentor = nbt.m_128459_("recently_attacked_tormentor");
            this.torment_cycle = nbt.m_128459_("torment_cycle");
            this.torment_mode = nbt.m_128461_("torment_mode");
            this.killedtormentor = nbt.m_128459_("killedtormentor");
            this.moth_summon_active = nbt.m_128459_("moth_summon_active");
            this.tormentor_summon_active = nbt.m_128459_("tormentor_summon_active");
            this.smshealth = nbt.m_128459_("smshealth");
            this.tmshealth = nbt.m_128459_("tmshealth");
            this.player_dimension = nbt.m_128461_("player_dimension");
            this.tormentor_long_range_anim = nbt.m_128471_("tormentor_long_range_anim");
            this.player_overlay = nbt.m_128471_("player_overlay");
            this.fov_smoothen = nbt.m_128459_("fov_smoothen");
            this.overlay_white = nbt.m_128459_("overlay_white");
            this.wrath_charge_time = nbt.m_128459_("wrath_charge_time");
            this.overlay_black = nbt.m_128459_("overlay_black");
            this.sphere_near = nbt.m_128459_("sphere_near");
            this.laser_emitter_near = nbt.m_128459_("laser_emitter_near");
            this.overlay_red = nbt.m_128459_("overlay_red");
            this.tormentor_render = nbt.m_128459_("tormentor_render");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("arphex", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "arphex_mapvars";
        public String LookScareLock = "\"\"";
        public double attackcycle = 0.0;
        public String slightrandom = "\"\"";
        public double clonesize = 0.0;
        public boolean onetimesplash = false;
        public double pocket_dimension_count = -10.0;
        public String tormentor_target_follow = "empty";
        public double tormentor_target_online = 0.0;
        public String tormentor_target_dimension = "\"\"";
        public double tormentor_target_x = 0.0;
        public double tormentor_target_y = 0.0;
        public double tormentor_target_z = 0.0;
        public double tormentor_health = 0.0;
        public double tormentor_x = 0.0;
        public double tormentor_y = 0.0;
        public double tormentor_z = 0.0;
        public double tormentor_entity_loaded = 0.0;
        public String bosskills = "\"\"";
        public double last_forceload_x = 0.0;
        public double last_forceload_z = 0.0;
        public String closest_tormentor_to_alignment = "\"\"";
        public boolean alternatecheck = false;
        public double tormentor_distance_as_uuid = 9.9999999E7;
        public double tormentor_countdown = 0.0;
        public String messagesequence = "\"\"";
        public double playeronlayer1 = 0.0;
        public double playeronlayer2 = 0.0;
        public double playeronlayer3 = 0.0;
        public double playeronlayer4 = 0.0;
        public boolean chunk_removal_complete = false;
        public double tormentor_rotation = 0.0;
        public boolean reload_render = false;
        public double force_unload_repeats = 0.0;
        public boolean full_tormentor_has_previously_spawned = false;
        public boolean limhit_tormentor = false;
        public boolean thunder_check = false;
        public double torchatcooldown = 0.0;
        public boolean tormentor_last_player_spawned = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.LookScareLock = nbt.m_128461_("LookScareLock");
            this.attackcycle = nbt.m_128459_("attackcycle");
            this.slightrandom = nbt.m_128461_("slightrandom");
            this.clonesize = nbt.m_128459_("clonesize");
            this.onetimesplash = nbt.m_128471_("onetimesplash");
            this.pocket_dimension_count = nbt.m_128459_("pocket_dimension_count");
            this.tormentor_target_follow = nbt.m_128461_("tormentor_target_follow");
            this.tormentor_target_online = nbt.m_128459_("tormentor_target_online");
            this.tormentor_target_dimension = nbt.m_128461_("tormentor_target_dimension");
            this.tormentor_target_x = nbt.m_128459_("tormentor_target_x");
            this.tormentor_target_y = nbt.m_128459_("tormentor_target_y");
            this.tormentor_target_z = nbt.m_128459_("tormentor_target_z");
            this.tormentor_health = nbt.m_128459_("tormentor_health");
            this.tormentor_x = nbt.m_128459_("tormentor_x");
            this.tormentor_y = nbt.m_128459_("tormentor_y");
            this.tormentor_z = nbt.m_128459_("tormentor_z");
            this.tormentor_entity_loaded = nbt.m_128459_("tormentor_entity_loaded");
            this.bosskills = nbt.m_128461_("bosskills");
            this.last_forceload_x = nbt.m_128459_("last_forceload_x");
            this.last_forceload_z = nbt.m_128459_("last_forceload_z");
            this.closest_tormentor_to_alignment = nbt.m_128461_("closest_tormentor_to_alignment");
            this.alternatecheck = nbt.m_128471_("alternatecheck");
            this.tormentor_distance_as_uuid = nbt.m_128459_("tormentor_distance_as_uuid");
            this.tormentor_countdown = nbt.m_128459_("tormentor_countdown");
            this.messagesequence = nbt.m_128461_("messagesequence");
            this.playeronlayer1 = nbt.m_128459_("playeronlayer1");
            this.playeronlayer2 = nbt.m_128459_("playeronlayer2");
            this.playeronlayer3 = nbt.m_128459_("playeronlayer3");
            this.playeronlayer4 = nbt.m_128459_("playeronlayer4");
            this.chunk_removal_complete = nbt.m_128471_("chunk_removal_complete");
            this.tormentor_rotation = nbt.m_128459_("tormentor_rotation");
            this.reload_render = nbt.m_128471_("reload_render");
            this.force_unload_repeats = nbt.m_128459_("force_unload_repeats");
            this.full_tormentor_has_previously_spawned = nbt.m_128471_("full_tormentor_has_previously_spawned");
            this.limhit_tormentor = nbt.m_128471_("limhit_tormentor");
            this.thunder_check = nbt.m_128471_("thunder_check");
            this.torchatcooldown = nbt.m_128459_("torchatcooldown");
            this.tormentor_last_player_spawned = nbt.m_128471_("tormentor_last_player_spawned");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128359_("LookScareLock", this.LookScareLock);
            nbt.m_128347_("attackcycle", this.attackcycle);
            nbt.m_128359_("slightrandom", this.slightrandom);
            nbt.m_128347_("clonesize", this.clonesize);
            nbt.m_128379_("onetimesplash", this.onetimesplash);
            nbt.m_128347_("pocket_dimension_count", this.pocket_dimension_count);
            nbt.m_128359_("tormentor_target_follow", this.tormentor_target_follow);
            nbt.m_128347_("tormentor_target_online", this.tormentor_target_online);
            nbt.m_128359_("tormentor_target_dimension", this.tormentor_target_dimension);
            nbt.m_128347_("tormentor_target_x", this.tormentor_target_x);
            nbt.m_128347_("tormentor_target_y", this.tormentor_target_y);
            nbt.m_128347_("tormentor_target_z", this.tormentor_target_z);
            nbt.m_128347_("tormentor_health", this.tormentor_health);
            nbt.m_128347_("tormentor_x", this.tormentor_x);
            nbt.m_128347_("tormentor_y", this.tormentor_y);
            nbt.m_128347_("tormentor_z", this.tormentor_z);
            nbt.m_128347_("tormentor_entity_loaded", this.tormentor_entity_loaded);
            nbt.m_128359_("bosskills", this.bosskills);
            nbt.m_128347_("last_forceload_x", this.last_forceload_x);
            nbt.m_128347_("last_forceload_z", this.last_forceload_z);
            nbt.m_128359_("closest_tormentor_to_alignment", this.closest_tormentor_to_alignment);
            nbt.m_128379_("alternatecheck", this.alternatecheck);
            nbt.m_128347_("tormentor_distance_as_uuid", this.tormentor_distance_as_uuid);
            nbt.m_128347_("tormentor_countdown", this.tormentor_countdown);
            nbt.m_128359_("messagesequence", this.messagesequence);
            nbt.m_128347_("playeronlayer1", this.playeronlayer1);
            nbt.m_128347_("playeronlayer2", this.playeronlayer2);
            nbt.m_128347_("playeronlayer3", this.playeronlayer3);
            nbt.m_128347_("playeronlayer4", this.playeronlayer4);
            nbt.m_128379_("chunk_removal_complete", this.chunk_removal_complete);
            nbt.m_128347_("tormentor_rotation", this.tormentor_rotation);
            nbt.m_128379_("reload_render", this.reload_render);
            nbt.m_128347_("force_unload_repeats", this.force_unload_repeats);
            nbt.m_128379_("full_tormentor_has_previously_spawned", this.full_tormentor_has_previously_spawned);
            nbt.m_128379_("limhit_tormentor", this.limhit_tormentor);
            nbt.m_128379_("thunder_check", this.thunder_check);
            nbt.m_128347_("torchatcooldown", this.torchatcooldown);
            nbt.m_128379_("tormentor_last_player_spawned", this.tormentor_last_player_spawned);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ArphexMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "arphex_worldvars";
        public boolean checkedprojecte = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.checkedprojecte = nbt.m_128471_("checkedprojecte");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("checkedprojecte", this.checkedprojecte);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ArphexMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.mothsurvivals = original.mothsurvivals;
            clone.mothtamer = original.mothtamer;
            clone.saturationclock = original.saturationclock;
            clone.killedscorpioid = original.killedscorpioid;
            clone.killedvoidlasher = original.killedvoidlasher;
            clone.abyssfly = original.abyssfly;
            clone.ownedantsnear = original.ownedantsnear;
            clone.pocketdimensionx = original.pocketdimensionx;
            clone.shadertime = original.shadertime;
            clone.tormentor_respite = original.tormentor_respite;
            clone.recently_attacked_tormentor = original.recently_attacked_tormentor;
            clone.torment_cycle = original.torment_cycle;
            clone.torment_mode = original.torment_mode;
            clone.killedtormentor = original.killedtormentor;
            clone.moth_summon_active = original.moth_summon_active;
            clone.tormentor_summon_active = original.tormentor_summon_active;
            clone.smshealth = original.smshealth;
            clone.tmshealth = original.tmshealth;
            if (!event.isWasDeath()) {
                clone.ShowOverlay = original.ShowOverlay;
                clone.ShowOverlay2 = original.ShowOverlay2;
                clone.holdingspace = original.holdingspace;
                clone.holdleftclick = original.holdleftclick;
                clone.ShowOverlay3 = original.ShowOverlay3;
                clone.doublejumpcool = original.doublejumpcool;
                clone.arphexcompass = original.arphexcompass;
                clone.arphexanglevsyaw = original.arphexanglevsyaw;
                clone.arphextriangx = original.arphextriangx;
                clone.arphextriangz = original.arphextriangz;
                clone.tamedants = original.tamedants;
                clone.show_tormentor_overlay = original.show_tormentor_overlay;
                clone.totemfatigue = original.totemfatigue;
                clone.time_in_portal = original.time_in_portal;
                clone.player_dimension = original.player_dimension;
                clone.tormentor_long_range_anim = original.tormentor_long_range_anim;
                clone.player_overlay = original.player_overlay;
                clone.fov_smoothen = original.fov_smoothen;
                clone.overlay_white = original.overlay_white;
                clone.wrath_charge_time = original.wrath_charge_time;
                clone.overlay_black = original.overlay_black;
                clone.sphere_near = original.sphere_near;
                clone.laser_emitter_near = original.laser_emitter_near;
                clone.overlay_red = original.overlay_red;
                clone.tormentor_render = original.tormentor_render;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ArphexMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ArphexMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ArphexMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

