/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.arphex.entity.SlowLookTestEntity;
import net.arphex.entity.TormentorLaserEntity;
import net.arphex.init.ArphexModItems;
import net.arphex.network.ArphexModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderTest7Procedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.f_82478_;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(double x, double y, double z, int color) {
        RenderTest7Procedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(double x, double y, double z, float u, float v, int color) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (format == DefaultVertexFormat.f_85815_) {
            bufferBuilder.m_5483_(x, y, z).m_193479_(color).m_5752_();
        } else if (format == DefaultVertexFormat.f_85819_) {
            bufferBuilder.m_5483_(x, y, z).m_7421_(u, v).m_193479_(color).m_5752_();
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            if (update) {
                RenderTest7Procedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.f_85815_) {
                    RenderTest7Procedure.mode = mode;
                    RenderTest7Procedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85815_);
                    return true;
                }
                if (format == DefaultVertexFormat.f_85819_) {
                    RenderTest7Procedure.mode = mode;
                    RenderTest7Procedure.format = format;
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(mode, DefaultVertexFormat.f_85819_);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        if (bufferBuilder == null || !bufferBuilder.m_85732_()) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        vertexBuffer.m_85921_();
        vertexBuffer.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderTest7Procedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderTest7Procedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            i = (float)(x - pos.m_7096_());
            j = (float)(y - pos.m_7098_());
            k = (float)(z - pos.m_7094_());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.m_85836_();
        poseStack.m_252880_(i, j, k);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        poseStack.m_252781_(Axis.f_252393_.m_252977_(roll));
        poseStack.m_85841_(xScale, yScale, zScale);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.m_85921_();
        vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, vertexBuffer.m_166892_().hasUV(0) ? GameRenderer.m_172820_() : GameRenderer.m_172811_());
        VertexBuffer.m_85931_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            RenderSystem.depthMask((boolean)false);
            RenderTest7Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            RenderSystem.depthMask((boolean)true);
            RenderTest7Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (level != null && entity != null) {
            poseStack = event.getPoseStack();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.m_20318_(event.getPartialTick());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderTest7Procedure.execute((Event)event, (LevelAccessor)level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        RenderTest7Procedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        ResourceKey resourceKey;
        if (entity == null) {
            return;
        }
        boolean entity_found = false;
        boolean disabled = false;
        double i = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double spheresize = 0.0;
        double col_r = 0.0;
        double col_g = 0.0;
        double col_b = 0.0;
        double negx = 0.0;
        double posx = 0.0;
        double negz = 0.0;
        double posz = 0.0;
        double stretch1 = 0.0;
        double stretch2 = 0.0;
        double pitch_variance = 0.0;
        double distance_scaling_factor = 0.0;
        double yaw_variance = 0.0;
        double convert_yaw = 0.0;
        double ringspan = 0.0;
        double raytrace_distance = 0.0;
        double newpositionz = 0.0;
        double newpositiony = 0.0;
        double ringspin = 0.0;
        double newpositionx = 0.0;
        double pitch_distance_variance = 0.0;
        double distance = 0.0;
        double yaw_distance_variance = 0.0;
        double expand = 0.0;
        double y_offset = 0.0;
        double xfind = 0.0;
        double yfind = 0.0;
        double zfind = 0.0;
        double opacity = 0.0;
        double expandsearch = 0.0;
        double distance_level = 0.0;
        double math_limit = 0.0;
        if (world instanceof Level) {
            Level _lvl = (Level)world;
            resourceKey = _lvl.m_46472_();
        } else if (world instanceof WorldGenLevel) {
            WorldGenLevel _wgl = (WorldGenLevel)world;
            resourceKey = _wgl.m_6018_().m_46472_();
        } else {
            resourceKey = Level.f_46428_;
        }
        if (resourceKey == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("arphex:the_crawling"))) {
            if (RenderTest7Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, true)) {
                RenderTest7Procedure.add(0.5, 0.0, -0.5, -1);
                RenderTest7Procedure.add(0.5, 0.0, 0.5, -1);
                RenderTest7Procedure.add(-0.5, 0.0, 0.5, -1);
                RenderTest7Procedure.add(-0.5, 0.0, -0.5, -1);
                RenderTest7Procedure.end();
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            if (RenderTest7Procedure.target(2)) {
                RenderSystem.defaultBlendFunc();
                math_limit = Math.floor(100.0 - Math.abs(((ArphexModVariables.PlayerVariables)entity.getCapability(ArphexModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ArphexModVariables.PlayerVariables())).crawling_color_cycle / 1.0 - 100.0));
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, 230.2, z, 0.0f, 0.0f, 0.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, 0x64000000 | (int)(70.0 + math_limit) << 16 | 0x1400 | 0);
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, 120.2, z, 0.0f, 0.0f, 0.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, 0x64000000 | (int)(70.0 + math_limit) << 16 | 0 | (int)(100.0 - math_limit));
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, 60.2, z, 0.0f, 0.0f, 0.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, Minecraft.m_91087_().f_91063_.m_109152_() * 2.0f, 0xDC000000 | (int)Math.floor(math_limit / 4.0) << 16 | (int)Math.floor(math_limit / 4.0) << 8 | (int)Math.floor(math_limit / 4.0));
                RenderTest7Procedure.release();
            }
        }
        ArphexModVariables.PlayerVariables playerVariables = new ArphexModVariables.PlayerVariables();
        if (((ArphexModVariables.PlayerVariables)entity.getCapability(ArphexModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)playerVariables)).laser_emitter_near > 0.0) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderTest7Procedure.system(true);
            negx = -3.0;
            posx = 3.0;
            negz = -3.0;
            posz = 3.0;
            stretch1 = 0.0;
            pitch_distance_variance = 140.0;
            yaw_distance_variance = 40.0;
            distance_scaling_factor = 1.0;
            y_offset = 1.0;
            expandsearch = 200.0;
            ArphexModVariables.PlayerVariables playerVariables2 = new ArphexModVariables.PlayerVariables();
            if (((ArphexModVariables.PlayerVariables)entity.getCapability(ArphexModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)playerVariables2)).laser_emitter_near > 6.0) {
                expandsearch = 500.0;
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(expandsearch / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
            for (Entity entityiterator : _entfound) {
                ItemStack itemStack;
                if (entityiterator instanceof Player) {
                    ItemStack itemStack2;
                    if (entityiterator instanceof LivingEntity) {
                        LivingEntity _entUseItem40 = (LivingEntity)entityiterator;
                        itemStack2 = _entUseItem40.m_21211_();
                    } else {
                        itemStack2 = ItemStack.f_41583_;
                    }
                    if (itemStack2.m_41720_() == ArphexModItems.VISIONARY_SPEAR.get()) {
                        if (RenderTest7Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, false)) {
                            RenderTest7Procedure.add(0.5, -0.5, -0.5, -6250336);
                            RenderTest7Procedure.add(0.5, -0.5, 0.5, -6250336);
                            RenderTest7Procedure.add(-0.5, -0.5, 0.5, -6250336);
                            RenderTest7Procedure.add(-0.5, -0.5, -0.5, -6250336);
                            RenderTest7Procedure.add(0.5, 0.5, 0.5, -1);
                            RenderTest7Procedure.add(0.5, 0.5, -0.5, -1);
                            RenderTest7Procedure.add(-0.5, 0.5, -0.5, -1);
                            RenderTest7Procedure.add(-0.5, 0.5, 0.5, -1);
                            RenderTest7Procedure.add(0.5, 0.5, -0.5, -2039584);
                            RenderTest7Procedure.add(0.5, -0.5, -0.5, -2039584);
                            RenderTest7Procedure.add(-0.5, -0.5, -0.5, -2039584);
                            RenderTest7Procedure.add(-0.5, 0.5, -0.5, -2039584);
                            RenderTest7Procedure.add(-0.5, 0.5, 0.5, -2039584);
                            RenderTest7Procedure.add(-0.5, -0.5, 0.5, -2039584);
                            RenderTest7Procedure.add(0.5, -0.5, 0.5, -2039584);
                            RenderTest7Procedure.add(0.5, 0.5, 0.5, -2039584);
                            RenderTest7Procedure.add(0.5, 0.5, 0.5, -4144960);
                            RenderTest7Procedure.add(0.5, -0.5, 0.5, -4144960);
                            RenderTest7Procedure.add(0.5, -0.5, -0.5, -4144960);
                            RenderTest7Procedure.add(0.5, 0.5, -0.5, -4144960);
                            RenderTest7Procedure.add(-0.5, 0.5, -0.5, -4144960);
                            RenderTest7Procedure.add(-0.5, -0.5, -0.5, -4144960);
                            RenderTest7Procedure.add(-0.5, -0.5, 0.5, -4144960);
                            RenderTest7Procedure.add(-0.5, 0.5, 0.5, -4144960);
                            RenderTest7Procedure.end();
                        }
                        if (RenderTest7Procedure.target(2)) {
                            RenderSystem.defaultBlendFunc();
                            RenderSystem.disableCull();
                            RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, y, z, 0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, 335595600);
                            RenderTest7Procedure.release();
                        }
                    }
                }
                if (!(entityiterator instanceof SlowLookTestEntity) && !(entityiterator instanceof TormentorLaserEntity)) {
                    ItemStack itemStack3;
                    if (!(entityiterator instanceof Player)) continue;
                    if (entityiterator instanceof LivingEntity) {
                        LivingEntity _entUseItem100 = (LivingEntity)entityiterator;
                        itemStack3 = _entUseItem100.m_21211_();
                    } else {
                        itemStack3 = ItemStack.f_41583_;
                    }
                    if (itemStack3.m_41720_() != ArphexModItems.OBLIVION_RAY.get()) continue;
                }
                distance = Math.sqrt((entity.m_20185_() - entityiterator.m_20185_()) * (entity.m_20185_() - entityiterator.m_20185_()) + (entity.m_20186_() - (entityiterator.m_20186_() + y_offset)) * (entity.m_20186_() - (entityiterator.m_20186_() + y_offset)) + (entity.m_20189_() - entityiterator.m_20189_()) * (entity.m_20189_() - entityiterator.m_20189_()));
                if (entityiterator instanceof TormentorLaserEntity) {
                    RenderSystem.disableCull();
                    if (distance > 170.0) {
                        RenderSystem.enableDepthTest();
                    } else {
                        RenderSystem.disableDepthTest();
                    }
                }
                opacity = 200.0;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _entUseItem118 = (LivingEntity)entityiterator;
                    itemStack = _entUseItem118.m_21211_();
                } else {
                    itemStack = ItemStack.f_41583_;
                }
                if (itemStack.m_41720_() == ArphexModItems.OBLIVION_RAY.get()) {
                    double d;
                    if (entity instanceof LivingEntity) {
                        LivingEntity _entUseTicks120 = (LivingEntity)entity;
                        d = _entUseTicks120.m_21252_();
                    } else {
                        d = 0.0;
                    }
                    opacity = d;
                }
                spheresize = 1.0;
                pitch_variance = pitch_distance_variance / (distance / 0.7);
                yaw_variance = yaw_distance_variance / (distance / 2.0);
                if (entityiterator instanceof TormentorLaserEntity) {
                    xfind = entityiterator.m_9236_().m_45547_(new ClipContext(entityiterator.m_20299_(1.0f), entityiterator.m_20299_(1.0f).m_82549_(entityiterator.m_20252_(1.0f).m_82490_(300.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).m_82425_().m_123341_();
                    yfind = entityiterator.m_9236_().m_45547_(new ClipContext(entityiterator.m_20299_(1.0f), entityiterator.m_20299_(1.0f).m_82549_(entityiterator.m_20252_(1.0f).m_82490_(300.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).m_82425_().m_123342_();
                    zfind = entityiterator.m_9236_().m_45547_(new ClipContext(entityiterator.m_20299_(1.0f), entityiterator.m_20299_(1.0f).m_82549_(entityiterator.m_20252_(1.0f).m_82490_(300.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).m_82425_().m_123343_();
                } else {
                    xfind = entityiterator.m_9236_().m_45547_(new ClipContext(entityiterator.m_20299_(1.0f), entityiterator.m_20299_(1.0f).m_82549_(entityiterator.m_20252_(1.0f).m_82490_(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).m_82425_().m_123341_();
                    yfind = entityiterator.m_9236_().m_45547_(new ClipContext(entityiterator.m_20299_(1.0f), entityiterator.m_20299_(1.0f).m_82549_(entityiterator.m_20252_(1.0f).m_82490_(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).m_82425_().m_123342_();
                    zfind = entityiterator.m_9236_().m_45547_(new ClipContext(entityiterator.m_20299_(1.0f), entityiterator.m_20299_(1.0f).m_82549_(entityiterator.m_20252_(1.0f).m_82490_(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).m_82425_().m_123343_();
                }
                expand = Math.sqrt((xfind - entityiterator.m_20185_()) * (xfind - entityiterator.m_20185_()) + (yfind - (entityiterator.m_20186_() + y_offset)) * (yfind - (entityiterator.m_20186_() + y_offset)) + (zfind - entityiterator.m_20189_()) * (zfind - entityiterator.m_20189_())) + 2.0;
                stretch2 = 0.0 - expand;
                if (entityiterator instanceof TormentorLaserEntity) {
                    int n;
                    double d;
                    TormentorLaserEntity _datEntI;
                    double d2;
                    RandomSource randomSource = RandomSource.m_216327_();
                    if (entityiterator instanceof TormentorLaserEntity) {
                        TormentorLaserEntity _datEntI2 = (TormentorLaserEntity)entityiterator;
                        d2 = ((Integer)_datEntI2.m_20088_().m_135370_(TormentorLaserEntity.DATA_growspawn)).intValue();
                    } else {
                        d2 = 0.0;
                    }
                    if (entityiterator instanceof TormentorLaserEntity) {
                        _datEntI = (TormentorLaserEntity)entityiterator;
                        d = ((Integer)_datEntI.m_20088_().m_135370_(TormentorLaserEntity.DATA_growspawn)).intValue();
                    } else {
                        d = 0.0;
                    }
                    spheresize = Mth.m_216263_((RandomSource)randomSource, (double)d2, (double)d) / 10.0;
                    stretch2 = (0.0 - expand) / 5.0;
                    if (entityiterator instanceof TormentorLaserEntity) {
                        _datEntI = (TormentorLaserEntity)entityiterator;
                        n = (Integer)_datEntI.m_20088_().m_135370_(TormentorLaserEntity.DATA_timer);
                    } else {
                        n = 0;
                    }
                    if (n > 30) {
                        RenderSystem.defaultBlendFunc();
                        opacity = 30.0;
                        col_r = 200.0;
                        col_g = 20.0;
                        col_b = 20.0;
                    } else {
                        RenderSystem.defaultBlendFunc();
                        opacity = 80.0;
                        col_r = 230.0;
                        col_g = 100.0;
                        col_b = 100.0;
                    }
                } else {
                    col_r = 255.0;
                    col_g = 120.0;
                    col_b = 120.0;
                    if ("1.20.1".startsWith("1.19.")) {
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    } else {
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    }
                }
                if (RenderTest7Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, true)) {
                    RenderTest7Procedure.add(posx, stretch2, negz, -1);
                    RenderTest7Procedure.add(posx, stretch2, posz, -1);
                    RenderTest7Procedure.add(negx, stretch2, posz, -1);
                    RenderTest7Procedure.add(negx, stretch2, negz, -1);
                    RenderTest7Procedure.add(0.5, stretch1, 0.5, -1);
                    RenderTest7Procedure.add(0.5, stretch1, -0.5, -1);
                    RenderTest7Procedure.add(-0.5, stretch1, -0.5, -1);
                    RenderTest7Procedure.add(-0.5, stretch1, 0.5, -1);
                    RenderTest7Procedure.add(0.5, stretch1, -0.5, -1);
                    RenderTest7Procedure.add(posx, stretch2, negz, -1);
                    RenderTest7Procedure.add(negx, stretch2, negz, -1);
                    RenderTest7Procedure.add(-0.5, stretch1, -0.5, -1);
                    RenderTest7Procedure.add(-0.5, stretch1, 0.5, -1);
                    RenderTest7Procedure.add(negx, stretch2, posz, -1);
                    RenderTest7Procedure.add(posx, stretch2, posz, -1);
                    RenderTest7Procedure.add(0.5, stretch1, 0.5, -1);
                    RenderTest7Procedure.add(0.5, stretch1, 0.5, -1);
                    RenderTest7Procedure.add(posx, stretch2, posz, -1);
                    RenderTest7Procedure.add(posx, stretch2, negz, -1);
                    RenderTest7Procedure.add(0.5, stretch1, -0.5, -1);
                    RenderTest7Procedure.add(-0.5, stretch1, -0.5, -1);
                    RenderTest7Procedure.add(negx, stretch2, negz, -1);
                    RenderTest7Procedure.add(negx, stretch2, posz, -1);
                    RenderTest7Procedure.add(-0.5, stretch1, 0.5, -1);
                    RenderTest7Procedure.end();
                }
                if (!RenderTest7Procedure.target(2)) continue;
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), entityiterator.m_20185_(), entityiterator.m_20186_() + y_offset, entityiterator.m_20189_(), entityiterator.m_146908_(), entityiterator.m_146909_() - 90.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)opacity << 24 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                RenderTest7Procedure.release();
            }
        }
    }
}

