/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.handler;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.EnchantmentSwitchClient;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EditEnchantmentsScreen;
import fuzs.enchantmentswitch.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SlotOverlayHandler {
    public static final int MAX_TRIGGER_TIME = 72000;
    private static int triggerTime;
    private static int lastTriggerTime;
    @Nullable
    private static Slot hoveredSlot;

    public static EventResult onRenderTooltip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY, List<ClientTooltipComponent> components, ClientTooltipPositioner positioner) {
        Screen screen;
        if ((float)triggerTime > 0.0f && (screen = Minecraft.getInstance().screen) instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (hoveredSlot != null && hoveredSlot.hasItem() && screen2.hoveredSlot == hoveredSlot && screen2.getMenu().getCarried().isEmpty()) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void renderGuiLayer(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        float partialTick;
        Player player = Minecraft.getInstance().gui.getCameraPlayer();
        if (player != null && SlotOverlayHandler.getNormalizedTriggerTime(partialTick = deltaTracker.getGameTimeDeltaPartialTick(false)) > 0.0f) {
            int selectedSlot = Minecraft.getInstance().player.getInventory().getSelectedSlot();
            int posX = guiGraphics.guiWidth() / 2 - 90 + selectedSlot * 20 + 2;
            int posY = guiGraphics.guiHeight() - 16 - 3;
            SlotOverlayHandler.renderSlotOverlay(guiGraphics, posX, posY, partialTick);
        }
    }

    public static void onAfterRender(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (hoveredSlot != null && SlotOverlayHandler.getNormalizedTriggerTime(partialTick) > 0.0f) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)screen.leftPos, (float)screen.topPos);
            SlotOverlayHandler.renderSlotOverlay(guiGraphics, SlotOverlayHandler.hoveredSlot.x, SlotOverlayHandler.hoveredSlot.y, partialTick);
            guiGraphics.pose().popMatrix();
        }
    }

    private static void renderSlotOverlay(GuiGraphics guiGraphics, int posX, int posY, float partialTick) {
        float animationProgress = Math.clamp(SlotOverlayHandler.getNormalizedTriggerTime(partialTick), 0.0f, 1.0f);
        guiGraphics.fill(posX, posY + Mth.floor((float)(16.0f * (1.0f - animationProgress))), posX + 16, posY + 16, -1990870528);
    }

    private static float getNormalizedTriggerTime(float partialTick) {
        return Mth.lerp((float)partialTick, (float)SlotOverlayHandler.normalizeTriggerTime(lastTriggerTime), (float)SlotOverlayHandler.normalizeTriggerTime(triggerTime));
    }

    private static float normalizeTriggerTime(int triggerTime) {
        return Math.clamp((float)triggerTime / (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks, 0.0f, 1.0f);
    }

    public static void onEndClientTick(Minecraft minecraft) {
        if (minecraft.player != null) {
            lastTriggerTime = triggerTime;
            if (SlotOverlayHandler.isKeyDown(EnchantmentSwitchClient.EDIT_ENCHANTMENTS_KEY_MAPPING) && !((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEditorInstantly()) {
                Slot slot = SlotOverlayHandler.getHoveredSlot(minecraft.screen, (Player)minecraft.player);
                SlotOverlayHandler.resetTriggerValues(slot);
                if (SlotOverlayHandler.isValidSlot(slot, (Player)minecraft.player)) {
                    SlotOverlayHandler.incrementTriggerTime(minecraft, slot);
                }
            } else {
                SlotOverlayHandler.resetTriggerValues(null);
            }
        }
    }

    private static void resetTriggerValues(@Nullable Slot slot) {
        if (hoveredSlot != slot) {
            triggerTime = 0;
            hoveredSlot = slot;
        }
    }

    @Nullable
    private static Slot getHoveredSlot(@Nullable Screen screen, Player player) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
            if (abstractContainerScreen.getMenu().getCarried().isEmpty()) {
                return abstractContainerScreen.hoveredSlot;
            }
        } else if (screen == null) {
            NonNullList slots = player.inventoryMenu.slots;
            for (int i = slots.size() - 1; i >= 0; --i) {
                if (((Slot)slots.get(i)).getContainerSlot() != player.getInventory().getSelectedSlot()) continue;
                return (Slot)slots.get(i);
            }
        }
        return null;
    }

    private static boolean isValidSlot(@Nullable Slot slot, Player player) {
        if (slot != null && slot.allowModification(player)) {
            ItemStack itemStack = slot.getItem();
            return itemStack.isEnchanted();
        }
        return false;
    }

    private static void incrementTriggerTime(Minecraft minecraft, Slot slot) {
        if (triggerTime < 72000 && ++triggerTime >= ((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks) {
            SlotOverlayHandler.executeTriggerAction(minecraft, slot);
            triggerTime = 72000;
        }
    }

    public static void executeTriggerAction(Minecraft minecraft) {
        if (((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEditorInstantly()) {
            Slot slot = SlotOverlayHandler.getHoveredSlot(minecraft.screen, (Player)minecraft.player);
            SlotOverlayHandler.executeTriggerAction(minecraft, slot);
        }
    }

    private static void executeTriggerAction(Minecraft minecraft, Slot slot) {
        if (SlotOverlayHandler.isValidSlot(slot, (Player)minecraft.player)) {
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            minecraft.setScreen((Screen)new EditEnchantmentsScreen(minecraft.screen, minecraft.player.containerMenu.containerId, slot.getItem(), SlotOverlayHandler.unwrapSlot((Slot)slot).index));
        }
    }

    public static Slot unwrapSlot(Slot slot) {
        Slot slot2;
        if (slot instanceof CreativeModeInventoryScreen.SlotWrapper) {
            CreativeModeInventoryScreen.SlotWrapper slotWrapper = (CreativeModeInventoryScreen.SlotWrapper)slot;
            slot2 = slotWrapper.target;
        } else {
            slot2 = slot;
        }
        return slot2;
    }

    public static boolean isKeyDown(KeyMapping keyMapping) {
        if (keyMapping.key.getType() == InputConstants.Type.KEYSYM && !keyMapping.isUnbound()) {
            return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)keyMapping.key.getValue());
        }
        return false;
    }
}

