/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.handler;

import com.mojang.blaze3d.platform.InputConstants;
import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.EnchantmentSwitchClient;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EditEnchantmentsScreen;
import fuzs.enchantmentswitch.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TriggerLockRenderHandler {
    public static final int MAX_TRIGGER_TIME = 72000;
    private static float triggerTime;
    @Nullable
    private static Slot hoveredSlot;

    public static EventResult onRenderTooltip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY, List<ClientTooltipComponent> components, ClientTooltipPositioner positioner) {
        ClientTooltipComponent clientTooltipComponent;
        if (triggerTime > 0.0f && Minecraft.getInstance().screen instanceof AbstractContainerScreen && hoveredSlot != null && hoveredSlot.hasItem() && !components.isEmpty() && (clientTooltipComponent = components.getFirst()) instanceof ClientTextTooltip) {
            ClientTextTooltip textTooltip = (ClientTextTooltip)clientTooltipComponent;
            StringBuilder builder = new StringBuilder();
            textTooltip.text.accept((width, style, codePoint) -> {
                builder.append(Character.toChars(codePoint));
                return true;
            });
            Component hoverName = hoveredSlot.getItem().getHoverName();
            if (hoverName.getString().contentEquals(builder)) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onAfterRender(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (screen.getMenu().getCarried().isEmpty() && TriggerLockRenderHandler.isKeyDown(EnchantmentSwitchClient.EDIT_ENCHANTMENTS_KEY_MAPPING)) {
            Slot hoveredSlot = screen.hoveredSlot;
            if (TriggerLockRenderHandler.hoveredSlot != hoveredSlot) {
                TriggerLockRenderHandler.resetTriggerValues(hoveredSlot);
            }
            if (TriggerLockRenderHandler.isValidSlot(hoveredSlot, (Player)screen.minecraft.player)) {
                TriggerLockRenderHandler.incrementTriggerTime(screen, hoveredSlot, partialTick);
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().translate((float)screen.leftPos, (float)screen.topPos);
                float animationProgress = Math.clamp(triggerTime / (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks, 0.0f, 1.0f);
                int posX = hoveredSlot.x;
                int posY = hoveredSlot.y + Mth.floor((float)(16.0f * (1.0f - animationProgress)));
                guiGraphics.fill(posX, posY, posX + 16, posY + Mth.ceil((float)(16.0f * animationProgress)), -1990870528);
                guiGraphics.pose().popMatrix();
            }
        } else {
            TriggerLockRenderHandler.resetTriggerValues(null);
        }
    }

    public static void resetTriggerValues(@Nullable Slot hoveredSlot) {
        triggerTime = 0.0f;
        TriggerLockRenderHandler.hoveredSlot = hoveredSlot;
    }

    private static boolean isValidSlot(@Nullable Slot slot, Player player) {
        if (slot != null && slot.allowModification(player)) {
            ItemStack itemStack = slot.getItem();
            return itemStack.isEnchanted();
        }
        return false;
    }

    private static void incrementTriggerTime(AbstractContainerScreen<?> screen, Slot slot, float partialTick) {
        float f;
        triggerTime += partialTick;
        if (f >= (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks && triggerTime < 72000.0f) {
            screen.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            TriggerLockRenderHandler.executeTriggerAction(screen, slot);
        }
    }

    private static void executeTriggerAction(AbstractContainerScreen<?> screen, Slot slot) {
        TriggerLockRenderHandler.resetTriggerValues(null);
        screen.minecraft.setScreen((Screen)new EditEnchantmentsScreen((Screen)screen, screen.getMenu().containerId, slot.getItem(), TriggerLockRenderHandler.getSlotIndex(slot)));
    }

    public static int getSlotIndex(Slot slot) {
        int n;
        if (slot instanceof CreativeModeInventoryScreen.SlotWrapper) {
            CreativeModeInventoryScreen.SlotWrapper slotWrapper = (CreativeModeInventoryScreen.SlotWrapper)slot;
            n = slotWrapper.target.index;
        } else {
            n = slot.index;
        }
        return n;
    }

    public static boolean isKeyDown(KeyMapping keyMapping) {
        if (keyMapping.key.getType() == InputConstants.Type.KEYSYM && keyMapping.key.getValue() != InputConstants.UNKNOWN.getValue()) {
            return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyMapping.key.getValue());
        }
        return false;
    }
}

