/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.gui.screens.inventory;

import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.gui.components.AbstractMenuSelectionList;
import fuzs.enchantmentswitch.client.gui.components.ClickableEnchantmentButton;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EnchantmentState;
import fuzs.enchantmentswitch.client.gui.util.EnchantmentTooltipHelper;
import fuzs.enchantmentswitch.init.ModRegistry;
import fuzs.enchantmentswitch.network.client.ServerboundSetEnchantmentsMessage;
import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipRenderHelper;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class EditEnchantmentsScreen
extends Screen {
    public static final Component COMPONENT_EDIT_ENCHANTMENTS = Component.translatable((String)"enchantments.edit");
    public static final ResourceLocation EDIT_ENCHANTMENTS_TEXTURE = EnchantmentSwitch.id("textures/gui/enchantments.png");
    private static final ResourceLocation TEXT_FIELD_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"container/anvil/text_field");
    private static final ResourceLocation TEXT_FIELD_DISABLED_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"container/anvil/text_field_disabled");
    private final Screen lastScreen;
    private final int containerId;
    private final ItemStack itemStack;
    private final int slotIndex;
    private final ItemEnchantments enchantmentLookup;
    private final ItemEnchantments.Mutable itemEnchantments;
    private final ItemEnchantments.Mutable storedEnchantments;
    public int imageWidth = 176;
    public int imageHeight = 166;
    public int leftPos;
    public int topPos;
    private EditBox name;
    private EnchantmentSelectionList scrollingList;
    private List<? extends ClientTooltipComponent> itemTooltip;

    public EditEnchantmentsScreen(Screen lastScreen, int containerId, ItemStack itemStack, int slotIndex) {
        super(COMPONENT_EDIT_ENCHANTMENTS);
        this.lastScreen = lastScreen;
        this.containerId = containerId;
        this.itemStack = itemStack.copy();
        this.slotIndex = slotIndex;
        this.enchantmentLookup = ServerboundSetEnchantmentsMessage.createEnchantmentLookup(itemStack);
        this.itemEnchantments = new ItemEnchantments.Mutable((ItemEnchantments)this.itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        this.storedEnchantments = new ItemEnchantments.Mutable((ItemEnchantments)this.itemStack.getOrDefault((DataComponentType)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.value(), (Object)ItemEnchantments.EMPTY));
    }

    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + this.imageWidth - 3 - 26 + 5, this.topPos - 23 + 5, 16, 16, this.imageWidth + 5, 5, 23, EDIT_ENCHANTMENTS_TEXTURE, 256, 256, button -> this.onClose()));
        this.name = new EditBox(this.font, this.leftPos + 62, this.topPos + 24, 103, 12, COMPONENT_EDIT_ENCHANTMENTS);
        this.name.setFocused(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setValue(this.itemStack.getHoverName().getString());
        this.name.setEditable(false);
        this.addWidget((GuiEventListener)this.name);
        this.scrollingList = new EnchantmentSelectionList(this.leftPos + 18, this.topPos + 64);
        this.addRenderableWidget((GuiEventListener)this.scrollingList);
        this.refreshScrollingList();
    }

    private void refreshScrollingList() {
        EnchantmentState enchantmentState;
        this.refreshItemTooltip();
        int size = this.scrollingList.children().size();
        this.scrollingList.clearEntries();
        RegistryAccess.Frozen registries = this.minecraft.getConnection().registryAccess();
        HolderSet.Named holders = registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(EnchantmentTags.TOOLTIP_ORDER);
        for (Holder enchantment : holders) {
            int enchantmentLevel = this.enchantmentLookup.getLevel(enchantment);
            if (enchantmentLevel <= 0) continue;
            enchantmentState = EnchantmentState.create((Holder<Enchantment>)enchantment, this.itemEnchantments.getLevel(enchantment) > 0, enchantmentLevel, this.itemEnchantments.toImmutable());
            EnchantmentSelectionList enchantmentSelectionList = this.scrollingList;
            Objects.requireNonNull(enchantmentSelectionList);
            this.scrollingList.addEntry(enchantmentSelectionList.new EnchantmentSelectionList.Entry((Holder<Enchantment>)enchantment, enchantmentState));
        }
        for (Object2IntMap.Entry entry : this.enchantmentLookup.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            if (holders.contains(enchantment)) continue;
            enchantmentState = EnchantmentState.create((Holder<Enchantment>)enchantment, this.itemEnchantments.getLevel(enchantment) > 0, entry.getIntValue(), this.itemEnchantments.toImmutable());
            EnchantmentSelectionList enchantmentSelectionList = this.scrollingList;
            Objects.requireNonNull(enchantmentSelectionList);
            this.scrollingList.addEntry(enchantmentSelectionList.new EnchantmentSelectionList.Entry((Holder<Enchantment>)enchantment, enchantmentState));
        }
        if (size != this.scrollingList.children().size()) {
            this.scrollingList.setScrollAmount(0.0);
        }
    }

    private void refreshItemTooltip() {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        tooltipLines.add(EnchantmentTooltipHelper.getItemDisplayName(this.itemStack));
        Item.TooltipContext tooltipContext = Item.TooltipContext.of((Level)this.minecraft.level);
        this.itemEnchantments.toImmutable().addToTooltip(tooltipContext, tooltipLines::add, (TooltipFlag)TooltipFlag.NORMAL, (DataComponentGetter)this.itemStack);
        this.storedEnchantments.toImmutable().addToTooltip(tooltipContext, component -> tooltipLines.add(EnchantmentTooltipHelper.applyStoredEnchantmentStyle(component)), (TooltipFlag)TooltipFlag.NORMAL, (DataComponentGetter)this.itemStack);
        this.itemTooltip = ClientComponentSplitter.splitTooltipLines(tooltipLines).map(ClientTooltipComponent::create).toList();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawString(this.font, this.title, this.leftPos + 62, this.topPos + 8, -12566464, false);
        this.name.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().scale(2.0f, 2.0f);
        guiGraphics.renderFakeItem(this.itemStack, (this.leftPos + 17) / 2, (this.topPos + 8) / 2);
        guiGraphics.pose().popMatrix();
        if (this.itemTooltip != null && ScreenHelper.isHovering((int)(this.leftPos + 17), (int)(this.topPos + 8), (int)32, (int)32, (double)mouseX, (double)mouseY)) {
            TooltipRenderHelper.renderTooltipComponents((GuiGraphics)guiGraphics, (int)mouseX, (int)mouseY, this.itemTooltip);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, EDIT_ENCHANTMENTS_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, EDIT_ENCHANTMENTS_TEXTURE, this.leftPos + this.imageWidth - 3 - 26, this.topPos - 23, (float)this.imageWidth, 0.0f, 26, 23, 256, 256);
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, TEXT_FIELD_SPRITE, this.leftPos + 59, this.topPos + 20, 110, 16);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (super.keyPressed(keyEvent)) {
            return true;
        }
        if (KeyMappingHelper.isKeyActiveAndMatches((KeyMapping)this.minecraft.options.keyInventory, (KeyEvent)keyEvent)) {
            this.onClose();
            return true;
        }
        return false;
    }

    public void onClose() {
        ItemEnchantments storedEnchantments = (ItemEnchantments)this.itemStack.getOrDefault((DataComponentType)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.value(), (Object)ItemEnchantments.EMPTY);
        if (!Objects.equals(this.storedEnchantments.toImmutable(), storedEnchantments)) {
            ServerboundSetEnchantmentsMessage.setEnchantments((Player)this.minecraft.player, this.containerId, this.slotIndex, this.storedEnchantments.keySet());
            MessageSender.broadcast((Message)new ServerboundSetEnchantmentsMessage(this.containerId, this.slotIndex, this.storedEnchantments.keySet()));
        }
        this.minecraft.setScreen(this.lastScreen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private boolean moveEnchantmentToOppositeList(Holder<Enchantment> enchantment) {
        int enchantmentLevel = this.itemEnchantments.getLevel(enchantment);
        if (enchantmentLevel > 0) {
            this.itemEnchantments.set(enchantment, 0);
            this.storedEnchantments.set(enchantment, enchantmentLevel);
            return true;
        }
        enchantmentLevel = this.storedEnchantments.getLevel(enchantment);
        if (enchantmentLevel > 0 && EnchantmentHelper.isEnchantmentCompatible((Collection)this.itemEnchantments.keySet(), enchantment)) {
            this.storedEnchantments.set(enchantment, 0);
            this.itemEnchantments.set(enchantment, enchantmentLevel);
            return true;
        }
        return false;
    }

    private class EnchantmentSelectionList
    extends AbstractMenuSelectionList<Entry> {
        public EnchantmentSelectionList(int x, int y) {
            super(EditEnchantmentsScreen.this.minecraft, x, y, 126, 90, 20, 9);
        }

        class Entry
        extends AbstractMenuSelectionList.Entry<Entry> {
            public Entry(Holder<Enchantment> enchantment, EnchantmentState enchantmentState) {
                this.addRenderableWidget(new ClickableEnchantmentButton(EnchantmentSelectionList.this.getX(), EnchantmentSelectionList.this.getY(), enchantment, enchantmentState, button -> {
                    if (EditEnchantmentsScreen.this.moveEnchantmentToOppositeList(enchantment)) {
                        EditEnchantmentsScreen.this.refreshScrollingList();
                    }
                }));
            }
        }
    }
}

