/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.network.client;

import com.google.common.collect.Sets;
import fuzs.enchantmentswitch.init.ModRegistry;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ServerboundPlayMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record ServerboundSetEnchantmentsMessage(int containerId, int slotIndex, Set<Holder<Enchantment>> storedEnchantments) implements ServerboundPlayMessage
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSetEnchantmentsMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ServerboundSetEnchantmentsMessage::containerId, (StreamCodec)ByteBufCodecs.VAR_INT, ServerboundSetEnchantmentsMessage::slotIndex, (StreamCodec)Enchantment.STREAM_CODEC.apply(ByteBufCodecs.collection(Sets::newHashSetWithExpectedSize)), ServerboundSetEnchantmentsMessage::storedEnchantments, ServerboundSetEnchantmentsMessage::new);

    public MessageListener<ServerboundPlayMessage.Context> getListener() {
        return new MessageListener<ServerboundPlayMessage.Context>(){

            public void accept(ServerboundPlayMessage.Context context) {
                ServerboundSetEnchantmentsMessage.setEnchantments((Player)context.player(), ServerboundSetEnchantmentsMessage.this.containerId, ServerboundSetEnchantmentsMessage.this.slotIndex, ServerboundSetEnchantmentsMessage.this.storedEnchantments);
            }
        };
    }

    public static void setEnchantments(Player player, int containerId, int slotIndex, Set<Holder<Enchantment>> storedEnchantments) {
        Slot slot;
        AbstractContainerMenu menu = player.containerMenu;
        if (containerId == menu.containerId && slotIndex < menu.slots.size() && (slot = menu.getSlot(slotIndex)).hasItem() && slot.allowModification(player)) {
            ItemStack itemStack = slot.getItem();
            ItemEnchantments enchantmentLookup = ServerboundSetEnchantmentsMessage.createEnchantmentLookup(itemStack);
            ItemEnchantments.Mutable mutableItemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            ItemEnchantments.Mutable mutableStoredEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            for (Object2IntMap.Entry entry : enchantmentLookup.entrySet()) {
                Holder enchantment = (Holder)entry.getKey();
                if (!(enchantment.is(ModRegistry.PERSISTENT_ENCHANTMENTS_ENCHANTMENT_TAG) || !storedEnchantments.contains(enchantment) && EnchantmentHelper.isEnchantmentCompatible((Collection)mutableItemEnchantments.keySet(), (Holder)enchantment))) {
                    mutableStoredEnchantments.set(enchantment, entry.getIntValue());
                    continue;
                }
                mutableItemEnchantments.set(enchantment, entry.getIntValue());
            }
            itemStack.set(DataComponents.ENCHANTMENTS, (Object)mutableItemEnchantments.toImmutable());
            itemStack.set((DataComponentType)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.value(), (Object)mutableStoredEnchantments.toImmutable());
            slot.set(itemStack);
        }
    }

    public static ItemEnchantments createEnchantmentLookup(ItemStack itemStack) {
        ItemEnchantments itemEnchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments storedEnchantments = (ItemEnchantments)itemStack.getOrDefault((DataComponentType)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.value(), (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(storedEnchantments);
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            mutable.set((Holder)entry.getKey(), entry.getIntValue());
        }
        return mutable.toImmutable();
    }
}

