/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.handler;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.EnchantmentSwitchClient;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EditEnchantmentsScreen;
import fuzs.enchantmentswitch.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TriggerLockRenderHandler {
    private static final ItemStack ENCHANTED_BOOK_ITEM_STACK = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
    public static final int MAX_TRIGGER_TIME = 72000;
    public static final int CIRCLE_RADIUS = 12;
    private static final float COLOR_RED = 0.0f;
    private static final float COLOR_GREEN = 0.875f;
    private static final float COLOR_BLUE = 0.325f;
    private static float triggerTime;
    @Nullable
    private static Slot hoveredSlot;

    public static EventResult onRenderTooltip(GuiGraphics guiGraphics, Font font, int mouseX, int mouseY, List<ClientTooltipComponent> components, ClientTooltipPositioner positioner) {
        ClientTooltipComponent clientTooltipComponent;
        if (triggerTime > 0.0f && Minecraft.getInstance().screen instanceof AbstractContainerScreen && hoveredSlot != null && hoveredSlot.hasItem() && !components.isEmpty() && (clientTooltipComponent = components.getFirst()) instanceof ClientTextTooltip) {
            ClientTextTooltip textTooltip = (ClientTextTooltip)clientTooltipComponent;
            StringBuilder builder = new StringBuilder();
            textTooltip.text.accept((width, style, codePoint) -> {
                builder.append(Character.toChars(codePoint));
                return true;
            });
            Component hoverName = hoveredSlot.getItem().getHoverName();
            if (hoverName.getString().contentEquals(builder)) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onAfterRender(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (screen.getMenu().getCarried().isEmpty() && TriggerLockRenderHandler.isKeyDown(EnchantmentSwitchClient.EDIT_ENCHANTMENTS_KEY_MAPPING)) {
            Slot hoveredSlot = screen.hoveredSlot;
            if (TriggerLockRenderHandler.hoveredSlot != hoveredSlot) {
                TriggerLockRenderHandler.resetTriggerValues(hoveredSlot);
            }
            if (TriggerLockRenderHandler.isValidSlot(hoveredSlot, (Player)screen.minecraft.player)) {
                TriggerLockRenderHandler.incrementTriggerTime(screen, hoveredSlot, partialTick);
                TriggerLockRenderHandler.renderLockTrigger(screen.minecraft, guiGraphics, mouseX, mouseY, partialTick, 600);
            }
        } else {
            TriggerLockRenderHandler.resetTriggerValues(null);
        }
    }

    public static void resetTriggerValues(@Nullable Slot hoveredSlot) {
        triggerTime = 0.0f;
        TriggerLockRenderHandler.hoveredSlot = hoveredSlot;
    }

    private static boolean isValidSlot(@Nullable Slot slot, Player player) {
        if (slot != null && slot.allowModification(player)) {
            ItemStack itemStack = slot.getItem();
            return itemStack.isEnchanted();
        }
        return false;
    }

    private static void incrementTriggerTime(AbstractContainerScreen<?> screen, Slot slot, float partialTick) {
        float f;
        triggerTime += partialTick;
        if (f >= (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks && triggerTime < 72000.0f) {
            screen.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            TriggerLockRenderHandler.executeTriggerAction(screen, slot);
        }
    }

    private static void executeTriggerAction(AbstractContainerScreen<?> screen, Slot slot) {
        TriggerLockRenderHandler.resetTriggerValues(null);
        screen.minecraft.setScreen((Screen)new EditEnchantmentsScreen((Screen)screen, screen.getMenu().containerId, slot.getItem(), TriggerLockRenderHandler.getSlotIndex(slot)));
    }

    public static int getSlotIndex(Slot slot) {
        int n;
        if (slot instanceof CreativeModeInventoryScreen.SlotWrapper) {
            CreativeModeInventoryScreen.SlotWrapper slotWrapper = (CreativeModeInventoryScreen.SlotWrapper)slot;
            n = slotWrapper.target.index;
        } else {
            n = slot.index;
        }
        return n;
    }

    public static boolean isKeyDown(KeyMapping keyMapping) {
        if (keyMapping.key.getType() == InputConstants.Type.KEYSYM && keyMapping.key.getValue() != InputConstants.UNKNOWN.getValue()) {
            return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyMapping.key.getValue());
        }
        return false;
    }

    private static void renderLockTrigger(Minecraft minecraft, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int zOffset) {
        float angles;
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_COLOR);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        float alpha = 0.5f + 0.2f * ((float)Math.cos((float)minecraft.player.tickCount + partialTick / 10.0f) * 0.5f + 0.5f);
        bufferBuilder.addVertex((float)mouseX, (float)mouseY, (float)zOffset).setColor(0.0f, 0.4375f, 0.1625f, alpha);
        for (float f = angles = Math.min(1.0f, triggerTime / (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks) * 360.0f; f >= 0.0f; f -= 1.0f) {
            float rad = (f - 90.0f) / 180.0f * (float)Math.PI;
            bufferBuilder.addVertex((float)mouseX + Mth.cos((float)rad) * 12.0f, (float)mouseY + Mth.sin((float)rad) * 12.0f, (float)zOffset).setColor(0.0f, 0.875f, 0.325f, 1.0f);
        }
        bufferBuilder.addVertex((float)mouseX, (float)mouseY, (float)zOffset).setColor(0.0f, 0.875f, 0.325f, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, (float)zOffset);
        guiGraphics.renderFakeItem(ENCHANTED_BOOK_ITEM_STACK, mouseX - 8, mouseY - 8);
        guiGraphics.pose().popPose();
    }
}

