/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.gui.screens.inventory;

import com.google.common.collect.ImmutableSet;
import fuzs.enchantmentswitch.client.util.EnchantmentTooltipHelper;
import fuzs.enchantmentswitch.init.ModRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record EnchantmentState(int enchantmentLevel, boolean isPresent, Collection<Holder<Enchantment>> incompatibleEnchantments, boolean isPersistent) {
    public static EnchantmentState create(Holder<Enchantment> enchantment, boolean isPresent, int enchantmentLevel, ItemEnchantments itemEnchantments) {
        HashSet<Holder> incompatibleEnchantments = new HashSet<Holder>();
        for (Holder holder : itemEnchantments.keySet()) {
            if (enchantment.is(holder) || Enchantment.areCompatible(enchantment, (Holder)holder)) continue;
            incompatibleEnchantments.add(holder);
        }
        return new EnchantmentState(enchantmentLevel, isPresent, (Collection<Holder<Enchantment>>)ImmutableSet.copyOf(incompatibleEnchantments), enchantment.is(ModRegistry.PERSISTENT_ENCHANTMENTS_ENCHANTMENT_TAG));
    }

    public boolean isIncompatible() {
        return !this.incompatibleEnchantments.isEmpty();
    }

    public boolean isInactive() {
        return this.isPersistent() || this.isIncompatible();
    }

    public Component getDisplayName(Holder<Enchantment> enchantment) {
        return EnchantmentTooltipHelper.getDisplayName(enchantment);
    }

    public List<Component> getTooltip(Holder<Enchantment> enchantment) {
        if (this.isIncompatible()) {
            return EnchantmentTooltipHelper.getIncompatibleEnchantmentsTooltip(this.incompatibleEnchantments);
        }
        return EnchantmentTooltipHelper.getEnchantmentTooltip(enchantment, this.enchantmentLevel);
    }
}

