/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.handler;

import fuzs.enchantmentswitch.client.util.EnchantmentTooltipHelper;
import fuzs.enchantmentswitch.init.ModRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

public class StoredEnchantmentsTooltipHandler {
    public static void onItemTooltip(ItemStack itemStack, List<Component> tooltipLines, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipType) {
        ItemEnchantments itemEnchantments = (ItemEnchantments)itemStack.getOrDefault((DataComponentType)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.value(), (Object)ItemEnchantments.EMPTY);
        if (!itemEnchantments.isEmpty()) {
            int index = StoredEnchantmentsTooltipHandler.getLastEnchantmentIndex(tooltipLines);
            ArrayList enchantmentLines = new ArrayList();
            itemEnchantments.addToTooltip(tooltipContext, component -> enchantmentLines.add(EnchantmentTooltipHelper.applyStoredEnchantmentStyle(component)), tooltipType, (DataComponentGetter)itemStack);
            tooltipLines.addAll(index, enchantmentLines);
        }
    }

    private static int getLastEnchantmentIndex(List<Component> lines) {
        int index = lines.isEmpty() ? 0 : 1;
        for (int i = 0; i < lines.size(); ++i) {
            TranslatableContents contents;
            ComponentContents componentContents;
            Component component = lines.get(i);
            if (component.getContents() == PlainTextContents.EMPTY && !component.getSiblings().isEmpty()) {
                component = (Component)component.getSiblings().getFirst();
            }
            if (!((componentContents = component.getContents()) instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).getKey().matches("^enchantment\\.[a-z0-9_.-]+\\.[a-z0-9/._-]+")) continue;
            index = i + 1;
        }
        return index;
    }
}

