/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class EnchantmentTooltipHelper {
    public static final String KEY_INCOMPATIBLE_ENCHANTMENTS = "gui.enchantmentswitch.tooltip.incompatible";

    public static Component getItemDisplayName(ItemStack itemStack) {
        MutableComponent mutableComponent = Component.empty().append(itemStack.getHoverName()).withStyle(itemStack.getRarity().color());
        if (itemStack.has(DataComponents.CUSTOM_NAME)) {
            mutableComponent.withStyle(ChatFormatting.ITALIC);
        }
        return mutableComponent;
    }

    public static List<Component> getIncompatibleEnchantmentsTooltip(Collection<Holder<Enchantment>> incompatibleEnchantments) {
        MutableComponent component = Component.translatable((String)KEY_INCOMPATIBLE_ENCHANTMENTS, (Object[])new Object[]{incompatibleEnchantments.stream().map(EnchantmentTooltipHelper::getDisplayName).reduce((o1, o2) -> o1.append(", ").append((Component)o2)).orElse(Component.empty()).withStyle(ChatFormatting.GRAY)});
        return Collections.singletonList(component);
    }

    public static List<Component> getEnchantmentTooltip(Holder<Enchantment> enchantment, int enchantmentLevel) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        tooltipLines.add(Enchantment.getFullname(enchantment, (int)enchantmentLevel));
        String translationKey = EnchantmentTooltipHelper.getEnchantmentDescriptionKey(enchantment);
        if (translationKey != null) {
            tooltipLines.add((Component)Component.translatable((String)translationKey).withStyle(ChatFormatting.GRAY));
        }
        return tooltipLines;
    }

    @Nullable
    private static String getEnchantmentDescriptionKey(Holder<Enchantment> enchantment) {
        String translationKey = enchantment.unwrapKey().map(resourceKey -> Util.makeDescriptionId((String)resourceKey.registry().getPath(), (ResourceLocation)resourceKey.location())).orElse(null);
        if (translationKey == null) {
            return null;
        }
        if (Language.getInstance().has(translationKey + ".desc")) {
            return translationKey + ".desc";
        }
        if (Language.getInstance().has(translationKey + ".description")) {
            return translationKey + ".description";
        }
        return null;
    }

    public static MutableComponent getDisplayName(Holder<Enchantment> enchantment) {
        return ((Enchantment)enchantment.value()).description().copy().setStyle(Style.EMPTY);
    }

    public static Component applyStoredEnchantmentStyle(Component component) {
        return Component.empty().append(component).withStyle(ChatFormatting.STRIKETHROUGH);
    }
}

