/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.gui.screens.inventory;

import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.gui.components.AbstractMenuSelectionList;
import fuzs.enchantmentswitch.client.gui.components.ClickableEnchantmentButton;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EnchantmentState;
import fuzs.enchantmentswitch.client.util.EnchantmentTooltipHelper;
import fuzs.enchantmentswitch.init.ModRegistry;
import fuzs.enchantmentswitch.network.client.ServerboundSetEnchantmentsMessage;
import fuzs.puzzleslib.api.client.gui.v2.ScreenHelper;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ClientComponentSplitter;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipRenderHelper;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public class EditEnchantmentsScreen
extends class_437 {
    public static final class_2561 COMPONENT_EDIT_ENCHANTMENTS = class_2561.method_43471((String)"enchantments.edit");
    public static final class_2960 EDIT_ENCHANTMENTS_TEXTURE = EnchantmentSwitch.id("textures/gui/enchantments.png");
    private static final class_2960 TEXT_FIELD_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"container/anvil/text_field");
    private static final class_2960 TEXT_FIELD_DISABLED_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"container/anvil/text_field_disabled");
    @Nullable
    private final class_437 lastScreen;
    private final int containerId;
    private final class_1799 itemStack;
    private final int slotIndex;
    private final class_9304 enchantmentLookup;
    private final class_9304.class_9305 itemEnchantments;
    private final class_9304.class_9305 storedEnchantments;
    public int imageWidth = 176;
    public int imageHeight = 166;
    public int leftPos;
    public int topPos;
    private class_342 name;
    private EnchantmentSelectionList scrollingList;
    private List<? extends class_5684> itemTooltip;

    public EditEnchantmentsScreen(@Nullable class_437 lastScreen, int containerId, class_1799 itemStack, int slotIndex) {
        super(COMPONENT_EDIT_ENCHANTMENTS);
        this.lastScreen = lastScreen;
        this.containerId = containerId;
        this.itemStack = itemStack.method_7972();
        this.slotIndex = slotIndex;
        this.enchantmentLookup = ServerboundSetEnchantmentsMessage.createEnchantmentLookup(itemStack);
        this.itemEnchantments = new class_9304.class_9305((class_9304)this.itemStack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385));
        this.storedEnchantments = new class_9304.class_9305((class_9304)this.itemStack.method_58695((class_9331)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.comp_349(), (Object)class_9304.field_49385));
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.method_37063((class_364)new SpritelessImageButton(this.leftPos + this.imageWidth - 3 - 26 + 5, this.topPos - 23 + 5, 16, 16, this.imageWidth + 5, 5, 23, EDIT_ENCHANTMENTS_TEXTURE, 256, 256, button -> this.method_25419()));
        this.name = new class_342(this.field_22793, this.leftPos + 62, this.topPos + 24, 103, 12, COMPONENT_EDIT_ENCHANTMENTS);
        this.name.method_25365(false);
        this.name.method_1868(-1);
        this.name.method_1860(-1);
        this.name.method_1858(false);
        this.name.method_1880(50);
        this.name.method_1852(this.itemStack.method_7964().getString());
        this.name.method_1888(false);
        this.method_25429((class_364)this.name);
        this.scrollingList = new EnchantmentSelectionList(this.leftPos + 18, this.topPos + 64);
        this.method_37063((class_364)this.scrollingList);
        this.refreshScrollingList();
    }

    private void refreshScrollingList() {
        EnchantmentState enchantmentState;
        this.refreshItemTooltip();
        int size = this.scrollingList.method_25396().size();
        this.scrollingList.method_25339();
        class_5455.class_6890 registries = this.field_22787.method_1562().method_29091();
        class_6885.class_6888 holders = registries.method_46762(class_7924.field_41265).method_46735(class_9636.field_51362);
        for (class_6880 enchantment : holders) {
            int enchantmentLevel = this.enchantmentLookup.method_57536(enchantment);
            if (enchantmentLevel <= 0) continue;
            enchantmentState = EnchantmentState.create((class_6880<class_1887>)enchantment, this.itemEnchantments.method_57546(enchantment) > 0, enchantmentLevel, this.itemEnchantments.method_57549());
            EnchantmentSelectionList enchantmentSelectionList = this.scrollingList;
            Objects.requireNonNull(enchantmentSelectionList);
            this.scrollingList.addEntry(enchantmentSelectionList.new EnchantmentSelectionList.Entry((class_6880<class_1887>)enchantment, enchantmentState));
        }
        for (Object2IntMap.Entry entry : this.enchantmentLookup.method_57539()) {
            class_6880 enchantment = (class_6880)entry.getKey();
            if (holders.method_40241(enchantment)) continue;
            enchantmentState = EnchantmentState.create((class_6880<class_1887>)enchantment, this.itemEnchantments.method_57546(enchantment) > 0, entry.getIntValue(), this.itemEnchantments.method_57549());
            EnchantmentSelectionList enchantmentSelectionList = this.scrollingList;
            Objects.requireNonNull(enchantmentSelectionList);
            this.scrollingList.addEntry(enchantmentSelectionList.new EnchantmentSelectionList.Entry((class_6880<class_1887>)enchantment, enchantmentState));
        }
        if (size != this.scrollingList.method_25396().size()) {
            this.scrollingList.method_44382(0.0);
        }
    }

    private void refreshItemTooltip() {
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
        tooltipLines.add(EnchantmentTooltipHelper.getItemDisplayName(this.itemStack));
        class_1792.class_9635 tooltipContext = class_1792.class_9635.method_59528((class_1937)this.field_22787.field_1687);
        this.itemEnchantments.method_57549().method_57409(tooltipContext, tooltipLines::add, (class_1836)class_1836.field_41070, (class_9473)this.itemStack);
        this.storedEnchantments.method_57549().method_57409(tooltipContext, component -> tooltipLines.add(EnchantmentTooltipHelper.applyStoredEnchantmentStyle(component)), (class_1836)class_1836.field_41070, (class_9473)this.itemStack);
        this.itemTooltip = ClientComponentSplitter.splitTooltipLines(tooltipLines).map(class_5684::method_32662).toList();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.leftPos + 62, this.topPos + 8, -12566464, false);
        this.name.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(2.0f, 2.0f);
        guiGraphics.method_51445(this.itemStack, (this.leftPos + 17) / 2, (this.topPos + 8) / 2);
        guiGraphics.method_51448().popMatrix();
        if (this.itemTooltip != null && ScreenHelper.isHovering((int)(this.leftPos + 17), (int)(this.topPos + 8), (int)32, (int)32, (double)mouseX, (double)mouseY)) {
            TooltipRenderHelper.renderTooltipComponents((class_332)guiGraphics, (int)mouseX, (int)mouseY, this.itemTooltip);
        }
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_52752(guiGraphics);
        guiGraphics.method_25290(class_10799.field_56883, EDIT_ENCHANTMENTS_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.method_25290(class_10799.field_56883, EDIT_ENCHANTMENTS_TEXTURE, this.leftPos + this.imageWidth - 3 - 26, this.topPos - 23, (float)this.imageWidth, 0.0f, 26, 23, 256, 256);
        guiGraphics.method_52706(class_10799.field_56883, TEXT_FIELD_SPRITE, this.leftPos + 59, this.topPos + 20, 110, 16);
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (super.method_25404(keyEvent)) {
            return true;
        }
        if (KeyMappingHelper.isKeyActiveAndMatches((class_304)this.field_22787.field_1690.field_1822, (class_11908)keyEvent)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25419() {
        class_9304 storedEnchantments = (class_9304)this.itemStack.method_58695((class_9331)ModRegistry.STORED_ENCHANTMENTS_DATA_COMPONENT_TYPE.comp_349(), (Object)class_9304.field_49385);
        if (!Objects.equals(this.storedEnchantments.method_57549(), storedEnchantments)) {
            ServerboundSetEnchantmentsMessage.setEnchantments((class_1657)this.field_22787.field_1724, this.containerId, this.slotIndex, this.storedEnchantments.method_57545());
            MessageSender.broadcast((Message)new ServerboundSetEnchantmentsMessage(this.containerId, this.slotIndex, this.storedEnchantments.method_57545()));
        }
        this.field_22787.method_1507(this.lastScreen);
    }

    public boolean method_25421() {
        return false;
    }

    private boolean moveEnchantmentToOppositeList(class_6880<class_1887> enchantment) {
        int enchantmentLevel = this.itemEnchantments.method_57546(enchantment);
        if (enchantmentLevel > 0) {
            this.itemEnchantments.method_57547(enchantment, 0);
            this.storedEnchantments.method_57547(enchantment, enchantmentLevel);
            return true;
        }
        enchantmentLevel = this.storedEnchantments.method_57546(enchantment);
        if (enchantmentLevel > 0 && class_1890.method_8201((Collection)this.itemEnchantments.method_57545(), enchantment)) {
            this.storedEnchantments.method_57547(enchantment, 0);
            this.itemEnchantments.method_57547(enchantment, enchantmentLevel);
            return true;
        }
        return false;
    }

    private class EnchantmentSelectionList
    extends AbstractMenuSelectionList<Entry> {
        public EnchantmentSelectionList(int x, int y) {
            super(EditEnchantmentsScreen.this.field_22787, x, y, 126, 90, 20, 9);
        }

        class Entry
        extends AbstractMenuSelectionList.Entry<Entry> {
            public Entry(class_6880<class_1887> enchantment, EnchantmentState enchantmentState) {
                this.addRenderableWidget(new ClickableEnchantmentButton(EnchantmentSelectionList.this.method_46426(), EnchantmentSelectionList.this.method_46427(), enchantment, enchantmentState, button -> {
                    if (EditEnchantmentsScreen.this.moveEnchantmentToOppositeList(enchantment)) {
                        EditEnchantmentsScreen.this.refreshScrollingList();
                    }
                }));
            }
        }
    }
}

