/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantmentswitch.client.handler;

import fuzs.enchantmentswitch.EnchantmentSwitch;
import fuzs.enchantmentswitch.client.EnchantmentSwitchClient;
import fuzs.enchantmentswitch.client.gui.screens.inventory.EditEnchantmentsScreen;
import fuzs.enchantmentswitch.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_8000;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class SlotOverlayHandler {
    public static final int MAX_TRIGGER_TIME = 72000;
    private static int triggerTime;
    private static int lastTriggerTime;
    @Nullable
    private static class_1735 hoveredSlot;

    public static EventResult onRenderTooltip(class_332 guiGraphics, class_327 font, int mouseX, int mouseY, List<class_5684> components, class_8000 positioner) {
        class_437 class_4372;
        if ((float)triggerTime > 0.0f && (class_4372 = class_310.method_1551().field_1755) instanceof class_465) {
            class_465 screen = (class_465)class_4372;
            if (hoveredSlot != null && hoveredSlot.method_7681() && screen.field_2787 == hoveredSlot && screen.method_17577().method_34255().method_7960()) {
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void renderGuiLayer(class_332 guiGraphics, class_9779 deltaTracker) {
        float partialTick;
        class_1657 player = class_310.method_1551().field_1705.method_1737();
        if (player != null && SlotOverlayHandler.getNormalizedTriggerTime(partialTick = deltaTracker.method_60637(false)) > 0.0f) {
            int selectedSlot = class_310.method_1551().field_1724.method_31548().method_67532();
            int posX = guiGraphics.method_51421() / 2 - 90 + selectedSlot * 20 + 2;
            int posY = guiGraphics.method_51443() - 16 - 3;
            SlotOverlayHandler.renderSlotOverlay(guiGraphics, posX, posY, partialTick);
        }
    }

    public static void onAfterRender(class_465<?> screen, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (hoveredSlot != null && SlotOverlayHandler.getNormalizedTriggerTime(partialTick) > 0.0f) {
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)screen.field_2776, (float)screen.field_2800);
            SlotOverlayHandler.renderSlotOverlay(guiGraphics, SlotOverlayHandler.hoveredSlot.field_7873, SlotOverlayHandler.hoveredSlot.field_7872, partialTick);
            guiGraphics.method_51448().popMatrix();
        }
    }

    private static void renderSlotOverlay(class_332 guiGraphics, int posX, int posY, float partialTick) {
        float animationProgress = Math.clamp(SlotOverlayHandler.getNormalizedTriggerTime(partialTick), 0.0f, 1.0f);
        guiGraphics.method_25294(posX, posY + class_3532.method_15375((float)(16.0f * (1.0f - animationProgress))), posX + 16, posY + 16, -1990870528);
    }

    private static float getNormalizedTriggerTime(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)SlotOverlayHandler.normalizeTriggerTime(lastTriggerTime), (float)SlotOverlayHandler.normalizeTriggerTime(triggerTime));
    }

    private static float normalizeTriggerTime(int triggerTime) {
        return Math.clamp((float)triggerTime / (float)((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks, 0.0f, 1.0f);
    }

    public static void onEndClientTick(class_310 minecraft) {
        if (minecraft.field_1724 != null) {
            lastTriggerTime = triggerTime;
            if (SlotOverlayHandler.isKeyDown(EnchantmentSwitchClient.EDIT_ENCHANTMENTS_KEY_MAPPING) && !((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEditorInstantly()) {
                class_1735 slot = SlotOverlayHandler.getHoveredSlot(minecraft.field_1755, (class_1657)minecraft.field_1724);
                SlotOverlayHandler.resetTriggerValues(slot);
                if (SlotOverlayHandler.isValidSlot(slot, (class_1657)minecraft.field_1724)) {
                    SlotOverlayHandler.incrementTriggerTime(minecraft, slot);
                }
            } else {
                SlotOverlayHandler.resetTriggerValues(null);
            }
        }
    }

    private static void resetTriggerValues(@Nullable class_1735 slot) {
        if (hoveredSlot != slot) {
            triggerTime = 0;
            hoveredSlot = slot;
        }
    }

    @Nullable
    private static class_1735 getHoveredSlot(@Nullable class_437 screen, class_1657 player) {
        if (screen instanceof class_465) {
            class_465 abstractContainerScreen = (class_465)screen;
            if (abstractContainerScreen.method_17577().method_34255().method_7960()) {
                return abstractContainerScreen.field_2787;
            }
        } else if (screen == null) {
            class_2371 slots = player.field_7498.field_7761;
            for (int i = slots.size() - 1; i >= 0; --i) {
                if (((class_1735)slots.get(i)).method_34266() != player.method_31548().method_67532()) continue;
                return (class_1735)slots.get(i);
            }
        }
        return null;
    }

    private static boolean isValidSlot(@Nullable class_1735 slot, class_1657 player) {
        if (slot != null && slot.method_32754(player)) {
            class_1799 itemStack = slot.method_7677();
            return itemStack.method_7942();
        }
        return false;
    }

    private static void incrementTriggerTime(class_310 minecraft, class_1735 slot) {
        if (triggerTime < 72000 && ++triggerTime >= ((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEnchantmentsEditorTicks) {
            SlotOverlayHandler.executeTriggerAction(minecraft, slot);
            triggerTime = 72000;
        }
    }

    public static void executeTriggerAction(class_310 minecraft) {
        if (((ClientConfig)EnchantmentSwitch.CONFIG.get(ClientConfig.class)).openEditorInstantly()) {
            class_1735 slot = SlotOverlayHandler.getHoveredSlot(minecraft.field_1755, (class_1657)minecraft.field_1724);
            SlotOverlayHandler.executeTriggerAction(minecraft, slot);
        }
    }

    private static void executeTriggerAction(class_310 minecraft, class_1735 slot) {
        if (SlotOverlayHandler.isValidSlot(slot, (class_1657)minecraft.field_1724)) {
            minecraft.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            minecraft.method_1507((class_437)new EditEnchantmentsScreen(minecraft.field_1755, minecraft.field_1724.field_7512.field_7763, slot.method_7677(), SlotOverlayHandler.unwrapSlot((class_1735)slot).field_7874));
        }
    }

    public static class_1735 unwrapSlot(class_1735 slot) {
        class_1735 class_17352;
        if (slot instanceof class_481.class_484) {
            class_481.class_484 slotWrapper = (class_481.class_484)slot;
            class_17352 = slotWrapper.field_2898;
        } else {
            class_17352 = slot;
        }
        return class_17352;
    }

    public static boolean isKeyDown(class_304 keyMapping) {
        if (keyMapping.field_1655.method_1442() == class_3675.class_307.field_1668 && !keyMapping.method_1415()) {
            return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)keyMapping.field_1655.method_1444());
        }
        return false;
    }
}

